/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol.server.msg.json;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.protocol.common.json.JsonApiRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonApiResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonBaseRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonBaseResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonDeserializer;
import com.vmware.vapi.internal.protocol.common.json.JsonError;
import com.vmware.vapi.internal.protocol.common.json.JsonErrorResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidDataValueException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidMethodException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidMethodParamsException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonInvokeParams;
import com.vmware.vapi.internal.protocol.common.json.JsonInvokeRequestParams2;
import com.vmware.vapi.internal.protocol.common.json.JsonMsgDeserializer2;
import com.vmware.vapi.internal.protocol.common.json.JsonMsgSerializer2;
import com.vmware.vapi.internal.protocol.common.json.JsonProgressResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonSerializer;
import com.vmware.vapi.internal.security.SecurityUtil;
import com.vmware.vapi.internal.util.io.IoUtil;
import com.vmware.vapi.protocol.Constants;
import com.vmware.vapi.protocol.RequestProcessor;
import com.vmware.vapi.protocol.server.rpc.RequestReceiver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonServerConnection
implements RequestReceiver {
    private static Logger logger = LoggerFactory.getLogger(JsonServerConnection.class);
    private final ApiProvider provider;
    private final JsonSerializer jsonSerializer2;
    private final JsonDeserializer jsonDeserializer2;
    private final List<RequestProcessor> processorChain;
    private static final int INVALID_PARAMS_CODE = -32602;
    private static final int INVALID_REQUEST_CODE = -32600;
    private static final int METHOD_NOT_FOUND_CODE = -32601;
    private static final int INTERNAL_JSONRPC_ERROR_CODE = -32603;
    private static final String INVALID_PARAMS_MSG = "Invalid params";
    private static final String INVALID_REQUEST_MSG = "Invalid Request";
    private static final String METHOD_NOT_FOUND_MSG = "Method not found";
    private static final String INTERNAL_JSONRPC_ERROR_MSG = "Internal error";
    private static final String UTF8_CHARSET = "UTF-8";

    public JsonServerConnection(ApiProvider provider, List<RequestProcessor> processorChain) {
        Validate.notNull((Object)provider);
        Validate.notNull(processorChain);
        this.provider = provider;
        this.jsonDeserializer2 = new JsonMsgDeserializer2();
        this.jsonSerializer2 = new JsonMsgSerializer2();
        this.processorChain = Collections.unmodifiableList(processorChain);
    }

    @Override
    public void requestReceived(InputStream request, RequestReceiver.TransportContext transport) throws IOException {
        Validate.notNull((Object)request);
        Validate.notNull((Object)transport);
        byte[] buffer = IoUtil.readAll(request);
        if (buffer.length == 0) {
            logger.error("Empty request");
            JsonErrorResponse response = this.createErrorResponse(null, -32600, INVALID_REQUEST_MSG, "Empty request");
            this.sendResponse(response, transport, true);
            return;
        }
        logger.debug("Received request of size: {}", (Object)buffer.length);
        String jsonRpcRequest = new String(buffer, UTF8_CHARSET);
        if (logger.isDebugEnabled() && Constants.shouldLogRawRequestResponse()) {
            logger.debug("JSON request: {}", (Object)jsonRpcRequest);
        }
        JsonBaseRequest jsonRpcRequestObj = null;
        JsonErrorResponse errorResponse = null;
        String id = null;
        HashMap<String, Object> procMetaData = new HashMap<String, Object>();
        try {
            logger.debug("Deserializing JSON request");
            jsonRpcRequestObj = this.jsonDeserializer2.requestDeserialize(jsonRpcRequest);
            for (RequestProcessor proc : this.processorChain) {
                logger.debug("Execution request pre-processor {}", (Object)proc.toString());
                buffer = proc.process(buffer, procMetaData, this.convert((JsonInvokeRequestParams2)((JsonApiRequest)jsonRpcRequestObj).getParams()));
            }
        }
        catch (JsonInvalidMethodParamsException e) {
            logger.debug("Invalid parameters: {}", (Object)e.getMessage(), (Object)e);
            errorResponse = this.createErrorResponse(e.getId(), -32602, INVALID_PARAMS_MSG, e.getMessage());
        }
        catch (JsonInvalidRequest e) {
            logger.debug("Invalid JSON request: {}", (Object)e.getMsg(), (Object)e);
            errorResponse = this.createErrorResponse(null, -32600, INVALID_REQUEST_MSG, e.getMsg());
        }
        catch (JsonInvalidDataValueException e) {
            logger.debug("Invalid DataValue JSON detected in request: {}", (Object)e.getMessage(), (Object)e);
            errorResponse = this.createErrorResponse(null, -32600, INVALID_REQUEST_MSG, e.getMessage());
        }
        catch (JsonInvalidMethodException e) {
            logger.debug("Method not found: {}", (Object)e.getMsg(), (Object)e);
            errorResponse = this.createErrorResponse(e.getId(), -32601, METHOD_NOT_FOUND_MSG, e.getMsg());
        }
        catch (Exception e) {
            logger.debug("JSON-RPC error", (Throwable)e);
            errorResponse = this.createErrorResponse(null, -32603, INTERNAL_JSONRPC_ERROR_MSG, e.getMessage());
        }
        catch (Throwable t) {
            logger.error("Severe internal error", t);
            errorResponse = this.createErrorResponse(null, -32603, INTERNAL_JSONRPC_ERROR_MSG, t.getMessage());
        }
        if (errorResponse != null) {
            logger.error("Stop processing invalid JSON request: {}", (Object)jsonRpcRequest);
            this.sendResponse(errorResponse, transport, true);
        } else {
            id = jsonRpcRequestObj.getId();
            logger.debug("Processing JSON request with id {} for method {}", (Object)jsonRpcRequestObj.getId(), (Object)jsonRpcRequestObj.getMethod());
            if (jsonRpcRequestObj instanceof JsonApiRequest) {
                this.processApiRequest((JsonApiRequest)jsonRpcRequestObj, id, procMetaData, transport);
            }
        }
    }

    private void sendResponse(JsonBaseResponse response, RequestReceiver.TransportContext transport, boolean isFinal) {
        byte[] jsonResponse = null;
        try {
            jsonResponse = this.jsonSerializer2.serialize(response);
        }
        catch (RuntimeException t) {
            logger.warn("Failed to serialize JSON response", (Throwable)t);
            return;
        }
        this.dumpResponse(jsonResponse);
        this.sendResponse(jsonResponse, transport, isFinal);
    }

    private void dumpResponse(byte[] jsonResponse) {
        if (logger.isDebugEnabled() && Constants.shouldLogRawRequestResponse()) {
            try {
                String strJsonResponse = new String(jsonResponse, UTF8_CHARSET);
                logger.debug("JSON response: {}", (Object)strJsonResponse);
            }
            catch (UnsupportedEncodingException ex) {
                logger.error("JSON response is not valid UTF-8", (Throwable)ex);
            }
        }
    }

    private void processApiRequest(JsonApiRequest jsonApiRequest, final String id, Map<String, Object> procMetaData, RequestReceiver.TransportContext transport) {
        JsonInvokeParams invokeParams = jsonApiRequest.getParams();
        ExecutionContext parsedCtx = invokeParams.getCtx();
        ExecutionContext.SecurityContext securityCtx = this.updateSecurityContext(procMetaData, parsedCtx.retrieveSecurityContext());
        ExecutionContext ctx = new ExecutionContext(parsedCtx.retrieveApplicationData(), securityCtx);
        AsyncHandleImpl<MethodResult> cb = new AsyncHandleImpl<MethodResult>(transport, id, true){

            @Override
            protected JsonBaseResponse toJson(MethodResult result) {
                return new JsonApiResponse(id, result);
            }
        };
        JsonInvokeRequestParams2 invokeRequestParams2 = (JsonInvokeRequestParams2)invokeParams;
        this.provider.invoke(invokeRequestParams2.getServiceId(), invokeRequestParams2.getOperationId(), invokeRequestParams2.getInput(), ctx, (AsyncHandle<MethodResult>)cb);
    }

    private ExecutionContext.SecurityContext updateSecurityContext(Map<String, Object> procMetaData, ExecutionContext.SecurityContext requestCtx) {
        assert (procMetaData != null);
        ExecutionContext.SecurityContext updatedCtx = requestCtx;
        Object procSecCtx = procMetaData.get("security_processor_metadata");
        if (procSecCtx != null && procSecCtx instanceof Map) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (requestCtx != null) {
                props.putAll(requestCtx.getAllProperties());
            }
            props.put("security_processor_metadata", procSecCtx);
            updatedCtx = SecurityUtil.createDefaultSecurityContext(props);
        } else if (requestCtx != null && requestCtx.getProperty("security_processor_metadata") != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Removed {security_processor_metadata," + requestCtx.getProperty("security_processor_metadata") + "} key/value pair from the security context");
            }
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.putAll(requestCtx.getAllProperties());
            props.remove("security_processor_metadata");
            updatedCtx = SecurityUtil.createDefaultSecurityContext(props);
        }
        return updatedCtx;
    }

    private void sendResponse(byte[] resp, RequestReceiver.TransportContext transport, boolean isFinal) {
        int respSize = resp.length;
        try {
            logger.debug("Sending JSON response of size {}", (Object)respSize);
            transport.send(new ByteArrayInputStream(resp), resp.length, isFinal);
        }
        catch (IOException e) {
            logger.error("Unable to send JSON response", (Throwable)e);
        }
    }

    private JsonErrorResponse createErrorResponse(String id, int code, String message, String data) {
        JsonError jsonError = new JsonError(code, message, data);
        return new JsonErrorResponse(id, jsonError);
    }

    private RequestProcessor.Request convert(JsonInvokeRequestParams2 params) {
        return new RequestProcessor.Request(params.getServiceId(), params.getOperationId(), params.getCtx(), params.getInput());
    }

    private abstract class AsyncHandleImpl<T>
    extends AsyncHandle<T> {
        private final RequestReceiver.TransportContext transport;
        private final String id;
        private final boolean sendProgressUpdates;

        AsyncHandleImpl(RequestReceiver.TransportContext transport, String id, boolean sendProgressUpdates) {
            Validate.notNull((Object)transport);
            Validate.notNull((Object)id);
            this.transport = transport;
            this.id = id;
            this.sendProgressUpdates = sendProgressUpdates;
        }

        @Override
        public void updateProgress(DataValue progress) {
            if (this.sendProgressUpdates) {
                JsonServerConnection.this.sendResponse(new JsonProgressResponse(this.id, progress), this.transport, false);
            } else {
                logger.debug("Skipping progress update for request with id {}", (Object)this.id);
            }
        }

        @Override
        public void setResult(T result) {
            JsonBaseResponse jsonObj;
            try {
                jsonObj = this.toJson(result);
            }
            catch (RuntimeException ex) {
                logger.error("Result for request with id {} could not be converted to JSON", (Object)this.id, (Object)ex);
                jsonObj = JsonServerConnection.this.createErrorResponse(null, -32603, JsonServerConnection.INTERNAL_JSONRPC_ERROR_MSG, ex.getMessage());
            }
            JsonServerConnection.this.sendResponse(jsonObj, this.transport, true);
        }

        @Override
        public void setError(RuntimeException error) {
            logger.error("Provider returned error for request with id {}", (Object)this.id, (Object)error);
            JsonErrorResponse jsonObj = JsonServerConnection.this.createErrorResponse(null, -32603, JsonServerConnection.INTERNAL_JSONRPC_ERROR_MSG, error.getMessage());
            JsonServerConnection.this.sendResponse(jsonObj, this.transport, true);
        }

        protected abstract JsonBaseResponse toJson(T var1);
    }
}

