"""
Unit tests for log module
"""

__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright (c) 2016 VMware, Inc.  All rights reserved.'

import logging
import unittest

from six.moves import cStringIO

from vmware.vapi.lib.log import get_raw_request_logger


class TestLogging(unittest.TestCase):

    def setUp(self):
        self.logger = get_raw_request_logger()
        self.log_capture_string = cStringIO()
        self.ch = logging.StreamHandler(self.log_capture_string)
        self.ch.setLevel(logging.DEBUG)
        self.root_logger = logging.getLogger()
        self.root_logger.addHandler(self.ch)

    def tearDown(self):
        self.log_capture_string.close()
        self.root_logger.removeHandler(self.ch)

    def test_raw_request_disabled(self):
        log_str = 'This should not appear in logs'
        self.logger.debug(log_str)
        self.assertTrue(log_str not in self.log_capture_string.getvalue())

    def test_raw_request_enabled(self):
        #Enable raw request logger
        self.logger.propagate = True
        #Test
        log_str = 'This should appear in logs'
        self.logger.debug(log_str)
        self.assertTrue(log_str in self.log_capture_string.getvalue())


if __name__ == "__main__":
    unittest.main()
