#- Copyright 2014 VMware, Inc.  All rights reserved.
#- VMware Confidential


module VAPI::Bindings

    # Configuration data for vAPI stub classes
    #
    # @!attribute [r] connector
    #     @return [VAPI::Protocol::Connector] Connection to be used to talk to the remote ApiProvider
    # @!attribute [r] api_provider
    #     @return [VAPI::Core::ApiProvider] the ApiProvider implementation
    class VapiConfig
        attr_reader :connector, :api_provider

        # Constructs a new instance.
        def initialize(uri, rpc=:http, msg=:json)
            @connector = VAPI::Protocol.create_connector(uri, rpc, msg)
            @api_provider = @connector.api_provider
        end

        def set_security_context(sec_ctx)
            self.connector.security_context = sec_ctx
        end
    end
end

