/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import java.io.Serializable;
import javax.cim.CIMClass;
import javax.cim.CIMDateTime;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import org.sblim.cimclient.internal.util.MOF;

public class CIMDataType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int BOOLEAN = 9;
    public static final CIMDataType BOOLEAN_ARRAY_T = new CIMDataType(9, 0);
    public static final CIMDataType BOOLEAN_T = new CIMDataType(9);
    public static final int CHAR16 = 13;
    public static final CIMDataType CHAR16_ARRAY_T = new CIMDataType(13, 0);
    public static final CIMDataType CHAR16_T = new CIMDataType(13);
    public static final int CLASS = 17;
    public static final CIMDataType CLASS_T = new CIMDataType(17);
    public static final int DATETIME = 12;
    public static final CIMDataType DATETIME_ARRAY_T = new CIMDataType(12, 0);
    public static final CIMDataType DATETIME_T = new CIMDataType(12);
    public static final int INVALID = -1;
    public static final CIMDataType INVALID_T = new CIMDataType(-1);
    public static final int NULL = 16;
    public static final int OBJECT = 15;
    public static final CIMDataType OBJECT_ARRAY_T = new CIMDataType(15, 0);
    public static final CIMDataType OBJECT_T = new CIMDataType(15);
    public static final int REAL32 = 10;
    public static final CIMDataType REAL32_ARRAY_T = new CIMDataType(10, 0);
    public static final CIMDataType REAL32_T = new CIMDataType(10);
    public static final int REAL64 = 11;
    public static final CIMDataType REAL64_ARRAY_T = new CIMDataType(11, 0);
    public static final CIMDataType REAL64_T = new CIMDataType(11);
    public static final int REFERENCE = 14;
    public static final int SINT16 = 3;
    public static final CIMDataType SINT16_ARRAY_T = new CIMDataType(3, 0);
    public static final CIMDataType SINT16_T = new CIMDataType(3);
    public static final int SINT32 = 5;
    public static final CIMDataType SINT32_ARRAY_T = new CIMDataType(5, 0);
    public static final CIMDataType SINT32_T = new CIMDataType(5);
    public static final int SINT64 = 7;
    public static final CIMDataType SINT64_ARRAY_T = new CIMDataType(7, 0);
    public static final CIMDataType SINT64_T = new CIMDataType(7);
    public static final int SINT8 = 1;
    public static final CIMDataType SINT8_ARRAY_T = new CIMDataType(1, 0);
    public static final CIMDataType SINT8_T = new CIMDataType(1);
    public static final int STRING = 8;
    public static final CIMDataType STRING_ARRAY_T = new CIMDataType(8, 0);
    public static final CIMDataType STRING_T = new CIMDataType(8);
    public static final int UINT16 = 2;
    public static final CIMDataType UINT16_ARRAY_T = new CIMDataType(2, 0);
    public static final CIMDataType UINT16_T = new CIMDataType(2);
    public static final int UINT32 = 4;
    public static final CIMDataType UINT32_ARRAY_T = new CIMDataType(4, 0);
    public static final CIMDataType UINT32_T = new CIMDataType(4);
    public static final int UINT64 = 6;
    public static final CIMDataType UINT64_ARRAY_T = new CIMDataType(6, 0);
    public static final CIMDataType UINT64_T = new CIMDataType(6);
    public static final int UINT8 = 0;
    public static final CIMDataType UINT8_ARRAY_T = new CIMDataType(0, 0);
    public static final CIMDataType UINT8_T = new CIMDataType(0);
    private int iTypeCode;
    private int iBound;
    private String iRefClassName;

    private void setType(int pType) {
        this.iTypeCode = pType;
        this.iBound = -1;
    }

    private void setType(int pType, int pBound) {
        this.iTypeCode = pType;
        this.iBound = pBound;
    }

    private CIMDataType(int pType) throws IllegalArgumentException {
        this.setType(pType);
    }

    public CIMDataType(int pType, int pSize) throws IllegalArgumentException {
        this.setType(pType, pSize);
    }

    public CIMDataType(String pClassName) {
        this.setType(14);
        this.iRefClassName = pClassName;
    }

    public CIMDataType(String pClassName, int pSize) {
        this.setType(14, pSize);
        this.iRefClassName = pClassName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CIMDataType)) {
            return false;
        }
        CIMDataType that = (CIMDataType)obj;
        if (this.iRefClassName == null && that.iRefClassName != null) {
            return false;
        }
        boolean refMatch = this.iRefClassName == null ? true : this.iRefClassName.equals(that.iRefClassName);
        return this.iTypeCode == that.iTypeCode && this.isArray() == that.isArray() && refMatch;
    }

    public static final CIMDataType getDataType(Object o) throws IllegalArgumentException {
        if (o instanceof Byte) {
            return SINT8_T;
        }
        if (o instanceof Byte[]) {
            return SINT8_ARRAY_T;
        }
        if (o instanceof Short) {
            return SINT16_T;
        }
        if (o instanceof Short[]) {
            return SINT16_ARRAY_T;
        }
        if (o instanceof Integer) {
            return SINT32_T;
        }
        if (o instanceof Integer[]) {
            return SINT32_ARRAY_T;
        }
        if (o instanceof Long) {
            return SINT64_T;
        }
        if (o instanceof Long[]) {
            return SINT64_ARRAY_T;
        }
        if (o instanceof UnsignedInteger8) {
            return UINT8_T;
        }
        if (o instanceof UnsignedInteger8[]) {
            return UINT8_ARRAY_T;
        }
        if (o instanceof UnsignedInteger16) {
            return UINT16_T;
        }
        if (o instanceof UnsignedInteger16[]) {
            return UINT16_ARRAY_T;
        }
        if (o instanceof UnsignedInteger32) {
            return UINT32_T;
        }
        if (o instanceof UnsignedInteger32[]) {
            return UINT32_ARRAY_T;
        }
        if (o instanceof UnsignedInteger64) {
            return UINT64_T;
        }
        if (o instanceof UnsignedInteger64[]) {
            return UINT64_ARRAY_T;
        }
        if (o instanceof Boolean) {
            return BOOLEAN_T;
        }
        if (o instanceof Boolean[]) {
            return BOOLEAN_ARRAY_T;
        }
        if (o instanceof Character) {
            return CHAR16_T;
        }
        if (o instanceof Character[]) {
            return CHAR16_ARRAY_T;
        }
        if (o instanceof String) {
            return STRING_T;
        }
        if (o instanceof String[]) {
            return STRING_ARRAY_T;
        }
        if (o instanceof Float) {
            return REAL32_T;
        }
        if (o instanceof Float[]) {
            return REAL32_ARRAY_T;
        }
        if (o instanceof Double) {
            return REAL64_T;
        }
        if (o instanceof Double[]) {
            return REAL64_ARRAY_T;
        }
        if (o instanceof CIMDateTime) {
            return DATETIME_T;
        }
        if (o instanceof CIMDateTime[]) {
            return DATETIME_ARRAY_T;
        }
        if (o instanceof CIMClass) {
            return CLASS_T;
        }
        if (o instanceof CIMClass[]) {
            return new CIMDataType(17, 0);
        }
        if (o instanceof CIMInstance) {
            return OBJECT_T;
        }
        if (o instanceof CIMInstance[]) {
            return OBJECT_ARRAY_T;
        }
        if (o instanceof CIMObjectPath) {
            CIMObjectPath op = (CIMObjectPath)o;
            return new CIMDataType(op.getObjectName());
        }
        if (o instanceof CIMObjectPath[]) {
            CIMObjectPath[] ops = (CIMObjectPath[])o;
            CIMObjectPath op = ops[0];
            return new CIMDataType(op.getObjectName(), 0);
        }
        return INVALID_T;
    }

    public String getRefClassName() {
        return this.iRefClassName;
    }

    public int getSize() {
        return this.iBound;
    }

    public int getType() {
        return this.iTypeCode;
    }

    public boolean isArray() {
        return this.iBound >= 0;
    }

    public String toString() {
        return MOF.dataType(this);
    }
}

