/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cim;

import com.vmware.cim.helpers.GetCim;
import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.connection.helpers.ApiValidator;
import com.vmware.vim25.HostServiceTicket;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.WBEMClient;

@Sample(name="cim-reader", description="allows you to walk the Common Information Model (CIM) data associated with an ESX Host You cannot read CIM data from a vCenter. This sample relies on classes in the javax.cim and javax.wbem packages. Implementations can be found in the sblim-cim-client2-2.1.1.jar or equivalent library. This sample allows you to drill down into CIM information by first connecting to a CIM service then exploring it's namespaces, classes, and class instances. ")
public class CIMReader
extends ConnectedVimServiceBase {
    private GetCim getCim;
    String host = null;
    int cimPort = 5989;
    String namespace = null;
    String cimClass = null;
    String instance = null;
    Boolean descendants = Boolean.FALSE;

    @Option(name="host", required=false, description="host's entity name or IP to gather CIM data from (if not talking directly to the ESX host).")
    public void setHost(String string) {
        this.host = string;
    }

    @Option(name="port", required=false, description="The port number on our remote host that the CIM services are running on. Defaults to 5989 if not specified.")
    public void setCimPort(String string) {
        this.cimPort = string != null && !"".equals(string) ? Integer.parseInt(string) : 5989;
    }

    @Option(name="namespace", required=false, description="the namespace to explore, if none is specified, then the command will list all namespaces available at the target.")
    public void setNamespace(String string) {
        this.namespace = string;
    }

    @Option(name="class", required=false, description="the CIM class to explore, if none specified, then the command will list all available class names under the namespace.")
    public void setCimClass(String string) {
        this.cimClass = string;
    }

    @Option(name="instance", required=false, description="the CIM class instance to list properties of, if none specified then the command will list all available instances of the specified class")
    public void setInstance(String string) {
        this.instance = string;
    }

    @Option(name="descendants", required=false, description="the CIM class inheritance details the command will list class inheritance hierarchy for the specified class", parameter=false)
    public void setdescendants(Boolean bl) {
        this.descendants = bl;
    }

    public URL cimBaseUrl() {
        URL uRL;
        try {
            String string = this.host != null ? this.host : this.connection.getHost();
            uRL = new URL("https", string, this.cimPort, "/");
        }
        catch (MalformedURLException malformedURLException) {
            throw new CIMReaderIllegalArgumentException("check your CIM port & host parameters", malformedURLException);
        }
        return this.check(uRL) ? uRL : null;
    }

    public boolean check(URL uRL) {
        boolean bl;
        try {
            uRL.openConnection();
            bl = true;
        }
        catch (IOException iOException) {
            throw new CIMReaderUnreachableHost(uRL, iOException);
        }
        return bl;
    }

    public Collection<CIMObjectPath> listNamespaces() throws WBEMException {
        LinkedList<CIMObjectPath> linkedList = new LinkedList<CIMObjectPath>();
        for (String string : GetCim.NAMESPACES) {
            CIMObjectPath cIMObjectPath = this.getCim().baseObjectPath(this.cimBaseUrl(), string);
            linkedList.add(cIMObjectPath);
        }
        return linkedList;
    }

    public Collection<String> listNamespaces(Collection<CIMObjectPath> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (CIMObjectPath cIMObjectPath : collection) {
            hashSet.add(cIMObjectPath.getNamespace());
        }
        return hashSet;
    }

    public Collection<CIMClass> listClasses(WBEMClient wBEMClient, String string) throws WBEMException {
        CIMObjectPath cIMObjectPath = this.getCim().baseObjectPath(this.cimBaseUrl(), string);
        LinkedList<CIMClass> linkedList = new LinkedList<CIMClass>();
        CloseableIterator closeableIterator = wBEMClient.enumerateClasses(cIMObjectPath, true, true, true, true);
        while (closeableIterator.hasNext()) {
            linkedList.add((CIMClass)closeableIterator.next());
        }
        return linkedList;
    }

    public Collection<CIMInstance> listInstances(WBEMClient wBEMClient, String string, String string2) throws WBEMException {
        CIMObjectPath cIMObjectPath = this.getCim().objectPath(this.cimBaseUrl(), string, string2);
        LinkedList<CIMInstance> linkedList = new LinkedList<CIMInstance>();
        CloseableIterator closeableIterator = wBEMClient.enumerateInstances(cIMObjectPath, true, true, true, null);
        while (closeableIterator.hasNext()) {
            linkedList.add((CIMInstance)closeableIterator.next());
        }
        return linkedList;
    }

    public Collection<CIMClass> listdescendants(WBEMClient wBEMClient, String string, String string2) throws WBEMException {
        CIMObjectPath cIMObjectPath = this.getCim().baseObjectPath(this.cimBaseUrl(), string);
        LinkedList<CIMClass> linkedList = new LinkedList<CIMClass>();
        CloseableIterator closeableIterator = wBEMClient.enumerateClasses(cIMObjectPath, true, true, true, true);
        boolean bl = false;
        do {
            CIMClass cIMClass;
            if (!(cIMClass = (CIMClass)closeableIterator.next()).getName().equals(string2)) continue;
            string2 = CIMReader.GetParent(cIMClass);
            if (bl) {
                linkedList.add(cIMClass);
            }
            bl = true;
            closeableIterator = wBEMClient.enumerateClasses(cIMObjectPath, true, true, true, true);
        } while (closeableIterator.hasNext());
        return linkedList;
    }

    public static String GetParent(CIMClass cIMClass) {
        return cIMClass.getSuperClassName();
    }

    public CIMInstance getInstance(WBEMClient wBEMClient, String string) throws WBEMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
        return this.getInstance(wBEMClient, cIMObjectPath);
    }

    public CIMInstance getInstance(WBEMClient wBEMClient, CIMObjectPath cIMObjectPath) throws WBEMException {
        return wBEMClient.getInstance(cIMObjectPath, true, true, null);
    }

    public Map<String, Object> listProperties(CIMInstance cIMInstance) throws WBEMException {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (CIMProperty cIMProperty : cIMInstance.getProperties()) {
            linkedHashMap.put(cIMProperty.getName(), cIMProperty.getValue());
        }
        return linkedHashMap;
    }

    public GetCim getCim() {
        if (this.getCim == null) {
            String string = this.isDirectConnection() != false ? this.connection.getHost() : this.host;
            this.getCim = new GetCim(this.connection, string);
        }
        return this.getCim;
    }

    int detectParams(String[] stringArray) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            n = i;
        }
        return n + 1;
    }

    public WBEMClient client(String string) {
        WBEMClient wBEMClient;
        if (this.isDirectConnection().booleanValue()) {
            wBEMClient = this.getCim().client(this.connection.getUsername(), this.connection.getPassword(), this.cimBaseUrl(), string);
        } else {
            HostServiceTicket hostServiceTicket = this.getCim().ticket();
            wBEMClient = this.getCim().client(hostServiceTicket, this.cimBaseUrl(), string);
        }
        return wBEMClient;
    }

    boolean checkTypeAndHost() {
        ApiValidator apiValidator = new ApiValidator(this.connection);
        String string = apiValidator.getApiType();
        boolean bl = false;
        if (this.host == null) {
            bl |= "HostAgent".equals(string);
            if ("VirtualCenter".equals(string)) {
                System.out.println(String.format("when talking to a '%s' you must specify a --host <name> to talk to", "VirtualCenter"));
            }
        } else {
            bl |= "VirtualCenter".equals(string);
        }
        return bl;
    }

    public Boolean isDirectConnection() {
        return this.isDirectConnection(this.getConnectionType());
    }

    public String getConnectionType() {
        ApiValidator apiValidator = new ApiValidator(this.connection);
        return apiValidator.getApiType();
    }

    public Boolean isDirectConnection(String string) {
        return "HostAgent".equals(string);
    }

    private String alias(Object object, boolean bl) {
        if (object instanceof CIMClass) {
            return this.alias((CIMClass)object);
        }
        if (object instanceof CIMInstance) {
            CIMInstance cIMInstance = (CIMInstance)object;
            String string = cIMInstance.getObjectPath().toString();
            return String.format("\t'%s'\n", string);
        }
        if (object instanceof CIMObjectPath) {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)object;
            String string = cIMObjectPath.toString();
            return String.format("\"%s\"", string.replaceAll("\"", "\\\""));
        }
        if (object instanceof CIMProperty[]) {
            return this.cimProperties((CIMProperty[])object, bl ? "\t%s=\"%s\"\n" : "%s=\"%s\",");
        }
        if (object instanceof Object[]) {
            return this.listing((Object[])object);
        }
        return object != null ? object.toString() : "";
    }

    private String listing(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(objectArray[i]);
            if (i + 1 >= objectArray.length) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public String alias(CIMObjectPath cIMObjectPath) {
        String string = cIMObjectPath.getObjectName();
        String string2 = this.cimProperties(cIMObjectPath.getKeys(), "%s=\"%s\",");
        return String.format("%s(%s);", string, string2);
    }

    public String alias(CIMClass cIMClass) {
        return cIMClass.getName();
    }

    public String alias(CIMInstance cIMInstance) {
        return this.alias(cIMInstance.getObjectPath());
    }

    public String instanceProperties(CIMInstance cIMInstance) {
        CIMProperty[] cIMPropertyArray = cIMInstance.getProperties();
        return this.cimProperties(cIMPropertyArray, "%s=\"%s\",");
    }

    public String cimProperties(CIMProperty<?>[] cIMPropertyArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (CIMProperty<?> cIMProperty : cIMPropertyArray) {
            String string2 = cIMProperty.getName();
            Object object = cIMProperty.getValue();
            if (object instanceof Object[]) {
                object = this.listing((Object[])object);
            }
            stringBuffer.append(String.format(string, string2, object != null ? object : ""));
        }
        return stringBuffer.toString();
    }

    private void browseCIMData() throws WBEMException {
        System.out.println();
        Collection<Object> collection = new LinkedList();
        if (this.namespace != null) {
            if (this.cimClass != null) {
                if (this.instance != null) {
                    System.out.println("listing properties");
                    collection.add(this.getInstance(this.client(this.namespace), this.instance).getProperties());
                } else if (this.descendants.booleanValue()) {
                    System.out.println("listing inheritance hierarchy");
                    collection = this.listdescendants(this.client(this.namespace), this.namespace, this.cimClass);
                } else {
                    System.out.println("listing instances look inside an instance using --instance a URL from below ");
                    collection = this.listInstances(this.client(this.namespace), this.namespace, this.cimClass);
                }
            } else {
                System.out.println("choose a class using --class ");
                collection = this.listClasses(this.client(this.namespace), this.namespace);
            }
        } else {
            System.out.println("choose a namespace using --namespace ");
            collection = this.listNamespaces(this.listNamespaces());
        }
        System.out.println("--");
        for (Object object : collection) {
            System.out.println(this.alias(object, true));
        }
        if (collection.size() == 0) {
            System.out.print(System.getProperty("cim.results.empty", "\tno results to display"));
        }
        System.out.println("--");
    }

    @Action
    public void run() throws WBEMException {
        if (this.checkTypeAndHost()) {
            this.browseCIMData();
        }
    }

    private class CIMReaderUnreachableHost
    extends CIMReaderException {
        private static final long serialVersionUID = 1890494682069661937L;

        public CIMReaderUnreachableHost(URL uRL, IOException iOException) {
            super("could not talk to: " + uRL.toString(), iOException);
        }
    }

    private class CIMReaderIllegalArgumentException
    extends CIMReaderException {
        private static final long serialVersionUID = -3208774982004613509L;

        public CIMReaderIllegalArgumentException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private class CIMReaderException
    extends RuntimeException {
        private static final long serialVersionUID = 3798539954464044318L;

        public CIMReaderException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

