/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.httpfileaccess;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceFileBackingInfo;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualMachineConfigInfo;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.ws.BindingProvider;

@Sample(name="get-vm-files", description="gets all the config files, snapshots files, logs files, virtual disk files to the local system.")
public class GetVMFiles
extends ConnectedVimServiceBase {
    Map<String, String> downloadedDir = new HashMap<String, String>();
    String cookieValue = "";
    String vmName = null;
    String localPath = null;

    @Option(name="vmname", description="Name of the virtual machine")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="localpath", description="localpath to copy files into")
    public void setLocalPath(String string) {
        this.localPath = string;
    }

    List<SelectionSpec> buildTraversalSpecForVMToDatacenter() {
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName("VisitFolders");
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setType("Folder");
        traversalSpec.setPath("parent");
        traversalSpec.setSkip(Boolean.FALSE);
        traversalSpec.setName("VisitFolders");
        traversalSpec.getSelectSet().add(selectionSpec);
        SelectionSpec selectionSpec2 = new SelectionSpec();
        selectionSpec2.setName("vAppToVApp");
        SelectionSpec selectionSpec3 = new SelectionSpec();
        selectionSpec3.setName("vAppToFolder");
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setType("VirtualApp");
        traversalSpec2.setPath("parentFolder");
        traversalSpec2.setSkip(Boolean.FALSE);
        traversalSpec2.setName("vAppToFolder");
        traversalSpec2.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec3 = new TraversalSpec();
        traversalSpec3.setType("VirtualApp");
        traversalSpec3.setPath("parentVApp");
        traversalSpec3.setSkip(Boolean.FALSE);
        traversalSpec3.setName("vAppToVApp");
        traversalSpec3.getSelectSet().add(selectionSpec2);
        traversalSpec3.getSelectSet().add(selectionSpec3);
        TraversalSpec traversalSpec4 = new TraversalSpec();
        traversalSpec4.setType("VirtualMachine");
        traversalSpec4.setPath("parentVApp");
        traversalSpec4.setSkip(Boolean.FALSE);
        traversalSpec4.setName("vmTovApp");
        traversalSpec4.getSelectSet().add(traversalSpec3);
        traversalSpec4.getSelectSet().add(traversalSpec2);
        TraversalSpec traversalSpec5 = new TraversalSpec();
        traversalSpec5.setType("VirtualMachine");
        traversalSpec5.setPath("parent");
        traversalSpec5.setSkip(Boolean.FALSE);
        traversalSpec5.setName("vmToFolder");
        traversalSpec5.getSelectSet().add(selectionSpec);
        ArrayList<SelectionSpec> arrayList = new ArrayList<SelectionSpec>();
        arrayList.add((SelectionSpec)traversalSpec5);
        arrayList.add((SelectionSpec)traversalSpec4);
        arrayList.add((SelectionSpec)traversalSpec);
        return arrayList;
    }

    String getDatacenterOfVM(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        String string;
        block2: {
            Iterator iterator;
            string = "";
            PropertySpec propertySpec = new PropertySpec();
            propertySpec.setAll(Boolean.FALSE);
            propertySpec.setType("Datacenter");
            propertySpec.getPathSet().add("name");
            ObjectSpec objectSpec = new ObjectSpec();
            objectSpec.setObj(managedObjectReference);
            objectSpec.setSkip(Boolean.TRUE);
            objectSpec.getSelectSet().addAll(this.buildTraversalSpecForVMToDatacenter());
            PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
            propertyFilterSpec.getPropSet().add(propertySpec);
            propertyFilterSpec.getObjectSet().add(objectSpec);
            ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
            arrayList.add(propertyFilterSpec);
            RetrieveOptions retrieveOptions = new RetrieveOptions();
            RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.serviceContent.getPropertyCollector(), arrayList, retrieveOptions);
            List list = retrieveResult.getObjects();
            if (list == null || !(iterator = list.iterator()).hasNext()) break block2;
            ObjectContent objectContent = (ObjectContent)iterator.next();
            List list2 = objectContent.getPropSet();
            if (list2 != null) {
                for (DynamicProperty dynamicProperty : list2) {
                    string = (String)dynamicProperty.getVal();
                }
            }
            System.out.println("VM is present under " + string + " Datacenter");
        }
        return string;
    }

    void getVM() throws IllegalArgumentException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, IOException {
        File file = new File(this.localPath);
        if (!file.exists()) {
            System.out.println("Wrong or invalid path " + this.localPath);
            return;
        }
        ManagedObjectReference managedObjectReference = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "VirtualMachine").get(this.vmName);
        if (managedObjectReference != null) {
            boolean bl;
            String string;
            String string2;
            Object object;
            System.out.println("vmRef: " + managedObjectReference.getValue());
            this.getDiskSizeInKB(managedObjectReference);
            String string3 = this.getDatacenterOfVM(managedObjectReference);
            String[] stringArray = this.getVmDirectory(managedObjectReference);
            if (stringArray[0] != null) {
                System.out.println("vmDirectory-0: " + stringArray[0] + " datacenter as : " + string3);
                System.out.println("Downloading Virtual Machine Configuration Directory");
                object = stringArray[0].substring(stringArray[0].indexOf("[") + 1, stringArray[0].lastIndexOf("]"));
                string2 = stringArray[0].substring(stringArray[0].indexOf("]") + 2, stringArray[0].lastIndexOf("/"));
                boolean bl2 = new File(this.localPath + "/" + string2 + "#vm#" + (String)object).mkdir();
                if (!bl2) {
                    System.out.println("Could not create " + this.localPath + "/" + string2 + "#vm#" + (String)object + "directory");
                }
                this.downloadDirectory(string2, string2 + "#vm#" + (String)object, (String)object, string3);
                this.downloadedDir.put(string2 + "#vm#" + (String)object, "Directory");
                System.out.println("Downloading Virtual Machine Configuration Directory Complete");
            }
            if (stringArray[1] != null) {
                System.out.println("Downloading Virtual Machine Snapshot / Suspend / Log Directory");
                for (int i = 1; i < stringArray.length; ++i) {
                    string2 = stringArray[i].substring(stringArray[i].indexOf("[") + 1, stringArray[i].lastIndexOf("]"));
                    String string4 = "";
                    string = this.serviceContent.getAbout().getApiType();
                    string4 = string.equalsIgnoreCase("VirtualCenter") ? stringArray[i].substring(stringArray[i].indexOf("]") + 2, stringArray[i].length() - 1) : stringArray[i].substring(stringArray[i].indexOf("]") + 2);
                    if (!this.downloadedDir.containsKey(string4 + "#vm#" + string2)) {
                        bl = new File(this.localPath + "/" + string4 + "#vm#" + string2).mkdir();
                        if (!bl) {
                            System.out.println("Could not create " + this.localPath + "/" + string4 + "#vm#" + string2 + "directory");
                        }
                        this.downloadDirectory(string4, string4 + "#vm#" + string2, string2, string3);
                        this.downloadedDir.put(string4 + "#vm#" + string2, "Directory");
                        continue;
                    }
                    System.out.println("Already Downloaded");
                }
                System.out.println("Downloading Virtual Machine Snapshot / Suspend / Log Directory Complete");
            }
            if ((object = this.getVDiskLocations(managedObjectReference)) != null) {
                System.out.println("Downloading Virtual Disks");
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (object[i] != null) {
                        String string5 = object[i].substring(object[i].indexOf("[") + 1, object[i].lastIndexOf("]"));
                        string = object[i].substring(object[i].indexOf("]") + 2, object[i].lastIndexOf("/"));
                        if (!this.downloadedDir.containsKey(string + "#vm#" + string5)) {
                            bl = new File(this.localPath + "/" + string + "#vdisk#" + string5).mkdir();
                            if (!bl) {
                                System.out.println("Could not create " + this.localPath + "/" + string + "#vdisk#" + string5 + "directory");
                            }
                            this.downloadDirectory(string, string + "#vdisk#" + string5, string5, string3);
                            this.downloadedDir.put(string + "#vdisk#" + string5, "Directory");
                            continue;
                        }
                        System.out.println("Already Downloaded");
                        continue;
                    }
                    System.out.println("Already Downloaded");
                }
                System.out.println("Downloading Virtual Disks Complete");
            } else {
                System.out.println("Downloading Virtual Disks Complete");
            }
        } else {
            throw new IllegalArgumentException("Virtual Machine " + this.vmName + " Not Found.");
        }
    }

    String[] getVmDirectory(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        String[] stringArray = new String[4];
        VirtualMachineConfigInfo virtualMachineConfigInfo = (VirtualMachineConfigInfo)this.getMOREFs.entityProps(managedObjectReference, new String[]{"config"}).get("config");
        if (virtualMachineConfigInfo != null) {
            stringArray[0] = virtualMachineConfigInfo.getFiles().getVmPathName();
            stringArray[1] = virtualMachineConfigInfo.getFiles().getSnapshotDirectory();
            stringArray[2] = virtualMachineConfigInfo.getFiles().getSuspendDirectory();
            stringArray[3] = virtualMachineConfigInfo.getFiles().getLogDirectory();
        } else {
            System.out.println("Connot Restore VM. Not Able To Find The Virtual Machine Config Info");
        }
        return stringArray;
    }

    void getDiskSizeInKB(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        VirtualMachineConfigInfo virtualMachineConfigInfo = (VirtualMachineConfigInfo)this.getMOREFs.entityProps(managedObjectReference, new String[]{"config"}).get("config");
        if (virtualMachineConfigInfo != null) {
            List list = virtualMachineConfigInfo.getHardware().getDevice();
            for (VirtualDevice virtualDevice : list) {
                if (!(virtualDevice instanceof VirtualDisk)) continue;
                System.out.println("Disk size in kb: " + ((VirtualDisk)virtualDevice).getCapacityInKB());
            }
        }
    }

    String[] getVDiskLocations(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        VirtualMachineConfigInfo virtualMachineConfigInfo = (VirtualMachineConfigInfo)this.getMOREFs.entityProps(managedObjectReference, new String[]{"config"}).get("config");
        System.out.println("vmconfig info : " + virtualMachineConfigInfo);
        if (virtualMachineConfigInfo != null) {
            List list = virtualMachineConfigInfo.getHardware().getDevice();
            VirtualDevice[] virtualDeviceArray = list.toArray(new VirtualDevice[list.size()]);
            int n = 0;
            String[] stringArray = new String[virtualDeviceArray.length];
            for (int i = 0; i < virtualDeviceArray.length; ++i) {
                if (!virtualDeviceArray[i].getClass().getCanonicalName().equalsIgnoreCase("com.vmware.vim25.VirtualDisk")) continue;
                try {
                    long l = ((VirtualDisk)virtualDeviceArray[i]).getCapacityInKB();
                    System.out.println("Disk size in kb: " + l);
                    VirtualDeviceFileBackingInfo virtualDeviceFileBackingInfo = (VirtualDeviceFileBackingInfo)virtualDeviceArray[i].getBacking();
                    stringArray[n] = virtualDeviceFileBackingInfo.getFileName();
                    System.out.println("virtualDisk : " + stringArray[n]);
                    ++n;
                    continue;
                }
                catch (ClassCastException classCastException) {
                    System.out.println("Got Exception : " + classCastException);
                }
            }
            return stringArray;
        }
        System.out.println("Connot Restore VM. Not Able To Find The Virtual Machine Config Info");
        return null;
    }

    void downloadDirectory(String string, String string2, String string3, String string4) throws IOException {
        String string5 = this.connection.getUrl();
        string5 = string5.substring(0, string5.lastIndexOf("sdk") - 1);
        String string6 = string5 + "/folder/" + string + "?dcPath=" + string4 + "&dsName=" + string3;
        string6 = string6.replaceAll("\\ ", "%20");
        System.out.println("httpUrl : " + string6);
        String[] stringArray = this.getListFiles(string6);
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("Downloading VM File " + stringArray[i]);
            String string7 = string5 + stringArray[i];
            String string8 = string2 + "/" + stringArray[i].substring(stringArray[i].lastIndexOf("/"), stringArray[i].lastIndexOf("?"));
            string7 = string7.replaceAll("\\ ", "%20");
            this.getData(string7, string8);
        }
    }

    String[] getListFiles(String string) throws IOException {
        String string2;
        Object object;
        HttpURLConnection httpURLConnection = null;
        URL uRL = new URL(string);
        httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setAllowUserInteraction(true);
        String string3 = "$Version=\"1\"; ";
        List list = (List)this.headers.get("Set-cookie");
        if (list.size() > 0) {
            this.cookieValue = (String)list.get(0);
            object = new StringTokenizer(this.cookieValue, ";");
            this.cookieValue = ((StringTokenizer)object).nextToken();
            string2 = "$" + ((StringTokenizer)object).nextToken();
            string3 = string3 + this.cookieValue + "; " + string2;
        }
        object = new HashMap<String, List<String>>();
        object.put("Cookie", Collections.singletonList(string3));
        ((BindingProvider)this.vimPort).getRequestContext().put("javax.xml.ws.http.request.headers", object);
        httpURLConnection.setRequestProperty("Cookie", string3);
        httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        httpURLConnection.setRequestProperty("Expect", "100-continue");
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setRequestProperty("Content-Length", "1024");
        string2 = null;
        String string4 = "";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            string4 = string4 + string2;
        }
        string4 = string4.replaceAll("&amp;", "&");
        string4 = string4.replaceAll("%2e", ".");
        string4 = string4.replaceAll("%2d", "-");
        string4 = string4.replaceAll("%5f", "_");
        ArrayList<String> arrayList = this.getFileLinks(string4);
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = arrayList.get(i);
        }
        return stringArray;
    }

    ArrayList<String> getFileLinks(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("<a href=\".*?\">");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            int n;
            String string2 = matcher.group();
            int n2 = string2.indexOf("\"") + 1;
            if ((string2 = string2.substring(n2, n = string2.lastIndexOf("\""))).indexOf("folder?") != -1) continue;
            System.out.println("fileLinks data : " + string2);
            arrayList.add(string2);
        }
        return arrayList;
    }

    void getData(String string, String string2) throws IOException {
        HttpURLConnection httpURLConnection = null;
        URL uRL = new URL(string);
        httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setAllowUserInteraction(true);
        List list = (List)this.headers.get("Set-cookie");
        this.cookieValue = (String)list.get(0);
        StringTokenizer stringTokenizer = new StringTokenizer(this.cookieValue, ";");
        this.cookieValue = stringTokenizer.nextToken();
        String string3 = "$" + stringTokenizer.nextToken();
        String string4 = "$Version=\"1\"; " + this.cookieValue + "; " + string3;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("Cookie", Collections.singletonList(string4));
        ((BindingProvider)this.vimPort).getRequestContext().put("javax.xml.ws.http.request.headers", hashMap);
        httpURLConnection.setRequestProperty("Cookie", string4);
        httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        httpURLConnection.setRequestProperty("Expect", "100-continue");
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setRequestProperty("Content-Length", "1024");
        InputStream inputStream = httpURLConnection.getInputStream();
        int n = string2.lastIndexOf("/");
        String string5 = string2.substring(0, n - 1);
        String string6 = string2.substring(n + 1);
        string6 = string6.replace("%20", " ");
        string5 = this.replaceSpecialChar(string5);
        string2 = this.localPath + "/" + string5 + "/" + string6;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        int n2 = 9216;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = null;
        int n3 = 0;
        int n4 = 0;
        while ((n3 = inputStream.read(byArray, 0, n2)) != -1) {
            n4 += n3;
            byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            ((OutputStream)bufferedOutputStream).write(byArray2, 0, n3);
        }
        inputStream.close();
        ((OutputStream)bufferedOutputStream).close();
    }

    String replaceSpecialChar(String string) {
        string = string.replace(':', '_');
        string = string.replace('*', '_');
        string = string.replace('<', '_');
        string = string.replace('>', '_');
        string = string.replace('|', '_');
        return string;
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, IOException, InvalidPropertyFaultMsg {
        this.getVM();
    }
}

