/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.performance;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.performance.widgets.StatsTable;
import com.vmware.vim25.ArrayOfPerfCounterInfo;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PerfCompositeMetric;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetric;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfMetricIntSeries;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.PerfSampleInfo;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.soap.SOAPFaultException;

@Sample(name="vi-top", description="an ESX-Top-like application that lets administrators specify the CPU and memory counters by name to obtain metrics for a specified host")
public class VITop
extends ConnectedVimServiceBase {
    String hostname;
    String cpu;
    String memory;
    StatsTable statsTable;
    ManagedObjectReference perfManager;
    PerfQuerySpec querySpec;
    private ManagedObjectReference hostmor;

    @Option(name="host", description="name of the host")
    public void setHostname(String string) {
        this.hostname = string;
    }

    @Option(name="cpu", description="CPU counter name [usage|ready|guaranteed]")
    public void setCpu(String string) {
        this.cpu = string;
    }

    @Option(name="memory", description="memory counter name [usage|granted]")
    public void setMemory(String string) {
        this.memory = string;
    }

    void createAndShowGUI(String string, List<String> list) {
        Object object;
        try {
            object = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel((String)object);
            JFrame.setDefaultLookAndFeelDecorated(true);
        }
        catch (SOAPFaultException sOAPFaultException) {
            this.printSoapFaultException(sOAPFaultException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new JFrame("VITop");
        ((JFrame)object).setDefaultCloseOperation(3);
        ((Window)object).addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                try {
                    VITop.this.connection.disconnect();
                }
                catch (SOAPFaultException sOAPFaultException) {
                    VITop.this.printSoapFaultException(sOAPFaultException);
                }
                catch (Exception exception) {
                    System.out.println("Failed to disconnect - " + exception.getMessage());
                    exception.printStackTrace();
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }
        });
        String[] stringArray = new String[list.size() + 1];
        stringArray[0] = string;
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i + 1] = list.get(i);
        }
        this.statsTable = new StatsTable(stringArray);
        this.statsTable.setOpaque(true);
        ((JFrame)object).setContentPane(this.statsTable);
        ((Window)object).pack();
        ((Window)object).setVisible(true);
    }

    String getEntityName(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        String string = null;
        Map<String, Object> map = null;
        try {
            map = this.getMOREFs.entityProps(managedObjectReference, new String[]{"name"});
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            invalidPropertyFaultMsg.printStackTrace();
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            runtimeFaultFaultMsg.printStackTrace();
        }
        try {
            string = (String)map.get("name");
        }
        catch (SOAPFaultException sOAPFaultException) {
            this.printSoapFaultException(sOAPFaultException);
        }
        catch (Exception exception) {
            return "<Unknown Entity>";
        }
        if (string != null) {
            return string;
        }
        return "<Unknown Entity>";
    }

    XMLGregorianCalendar displayStats(List<PerfMetricId> list, PerfCompositeMetric perfCompositeMetric) throws RuntimeException, RemoteException, InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        List list2;
        if (perfCompositeMetric == null || perfCompositeMetric.getEntity() == null) {
            return null;
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        PerfEntityMetric perfEntityMetric = (PerfEntityMetric)perfCompositeMetric.getEntity();
        PerfMetricIntSeries perfMetricIntSeries = (PerfMetricIntSeries)perfEntityMetric.getValue().get(0);
        int n = perfEntityMetric.getSampleInfo().size();
        XMLGregorianCalendar xMLGregorianCalendar = ((PerfSampleInfo)perfEntityMetric.getSampleInfo().get(n - 1)).getTimestamp();
        long l = (Long)perfMetricIntSeries.getValue().get(n - 1);
        System.out.println("Info Updated");
        int n2 = list.size() + 1;
        List list3 = list2 = perfCompositeMetric.getChildEntity();
        for (int i = 0; i < list3.size(); ++i) {
            PerfEntityMetric perfEntityMetric2 = (PerfEntityMetric)list3.get(i);
            String string = this.getEntityName(perfEntityMetric2.getEntity());
            int n3 = perfEntityMetric2.getSampleInfo().size();
            Object[] objectArray = new Object[n2];
            objectArray[0] = string;
            for (int j = 0; j < perfEntityMetric2.getValue().size(); ++j) {
                PerfMetricIntSeries perfMetricIntSeries2 = (PerfMetricIntSeries)perfEntityMetric2.getValue().get(j);
                int n4 = this.findStatsIndex(list, perfMetricIntSeries2.getId());
                if (n4 < 0) continue;
                long l2 = (Long)perfMetricIntSeries2.getValue().get(n3 - 1);
                objectArray[n4 + 1] = new Long(l2);
            }
            arrayList.add(objectArray);
        }
        if (this.statsTable != null) {
            this.statsTable.setData(xMLGregorianCalendar.toGregorianCalendar(), l, "Mhz", arrayList);
        }
        return xMLGregorianCalendar;
    }

    int findStatsIndex(List<PerfMetricId> list, PerfMetricId perfMetricId) {
        int n = 0;
        for (PerfMetricId perfMetricId2 : list) {
            if (perfMetricId2.getCounterId() == perfMetricId.getCounterId() && perfMetricId2.getInstance().equals(perfMetricId.getInstance())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    PerfCounterInfo getCounterInfo(List<PerfCounterInfo> list, String string, String string2) {
        for (PerfCounterInfo perfCounterInfo : list) {
            if (!perfCounterInfo.getGroupInfo().getKey().equals(string) || !perfCounterInfo.getNameInfo().getKey().equals(string2)) continue;
            return perfCounterInfo;
        }
        return null;
    }

    String[][] getCounters() {
        int n;
        String[] stringArray = this.cpu.split(",");
        String[] stringArray2 = this.memory.split(",");
        String[][] stringArray3 = new String[stringArray.length + stringArray2.length][2];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = new String[]{"cpu", stringArray[n]};
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[stringArray.length + n] = new String[]{"mem", stringArray2[n]};
        }
        return stringArray3;
    }

    void refreshStats() {
        try {
            PerfCompositeMetric perfCompositeMetric = this.vimPort.queryPerfComposite(this.perfManager, this.querySpec);
            XMLGregorianCalendar xMLGregorianCalendar = this.displayStats(this.querySpec.getMetricId(), perfCompositeMetric);
            if (xMLGregorianCalendar != null) {
                this.querySpec.setStartTime(xMLGregorianCalendar);
            }
        }
        catch (SOAPFaultException sOAPFaultException) {
            this.printSoapFaultException(sOAPFaultException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void displayStats() throws RuntimeFaultFaultMsg, InvocationTargetException, NoSuchMethodException, IllegalAccessException, InterruptedException {
        Object object;
        String string;
        PerfCounterInfo perfCounterInfo;
        String[][] stringArray = this.getCounters();
        Map<String, ManagedObjectReference> map = null;
        try {
            map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem", new RetrieveOptions());
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            runtimeFaultFaultMsg.printStackTrace();
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            invalidPropertyFaultMsg.printStackTrace();
        }
        this.hostmor = (ManagedObjectReference)map.get(this.hostname);
        if (this.hostmor == null) {
            System.out.println("Host " + this.hostname + " Not Found");
            return;
        }
        Map<String, Object> map2 = null;
        try {
            map2 = this.getMOREFs.entityProps(this.perfManager, new String[]{"perfCounter"});
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            invalidPropertyFaultMsg.printStackTrace();
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            runtimeFaultFaultMsg.printStackTrace();
        }
        ArrayOfPerfCounterInfo arrayOfPerfCounterInfo = (ArrayOfPerfCounterInfo)map2.get("perfCounter");
        List list = arrayOfPerfCounterInfo.getPerfCounterInfo();
        ArrayList<PerfMetricId> arrayList = new ArrayList<PerfMetricId>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            perfCounterInfo = this.getCounterInfo(list, stringArray[i][0], stringArray[i][1]);
            if (perfCounterInfo == null) {
                System.out.println("Warning: Unable to find stat " + stringArray[i][0] + " " + stringArray[i][1]);
                continue;
            }
            string = perfCounterInfo.getNameInfo().getLabel();
            arrayList2.add(string);
            object = new PerfMetricId();
            object.setCounterId(perfCounterInfo.getKey());
            object.setInstance("");
            arrayList.add((PerfMetricId)object);
        }
        ArrayList arrayList3 = new ArrayList(arrayList);
        Collections.copy(arrayList3, arrayList);
        perfCounterInfo = this.vimPort.queryPerfProviderSummary(this.perfManager, this.hostmor);
        string = new PerfQuerySpec();
        string.setEntity(this.hostmor);
        string.getMetricId().addAll(arrayList3);
        string.setIntervalId(perfCounterInfo.getRefreshRate());
        this.querySpec = string;
        object = arrayList2;
        SwingUtilities.invokeLater(new Runnable((List)object){
            final /* synthetic */ List val$statNames2;
            {
                this.val$statNames2 = list;
            }

            @Override
            public void run() {
                VITop.this.createAndShowGUI("VM Name", this.val$statNames2);
            }
        });
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                VITop.this.refreshStats();
            }
        }, 1000L, 21000L);
        Thread.currentThread().join();
    }

    void printSoapFaultException(SOAPFaultException sOAPFaultException) {
        System.out.println("SOAP Fault -");
        if (sOAPFaultException.getFault().hasDetail()) {
            System.out.println(sOAPFaultException.getFault().getDetail().getFirstChild().getLocalName());
        }
        if (sOAPFaultException.getFault().getFaultString() != null) {
            System.out.println("\n Message: " + sOAPFaultException.getFault().getFaultString());
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvocationTargetException, NoSuchMethodException, IllegalAccessException, InterruptedException {
        this.perfManager = this.serviceContent.getPerfManager();
        this.displayStats();
    }
}

