/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.sms;

import com.vmware.apputils.SmServiceConnection;
import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.vim.sms.CertificateNotTrusted;
import com.vmware.vim.sms.SmsPortType;
import com.vmware.vim.sms.SmsProviderSpec;
import com.vmware.vim.sms.SmsTaskInfo;
import com.vmware.vim.sms.VasaProviderInfo;
import com.vmware.vim.sms.VasaProviderSpec;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MethodFault;
import java.util.List;

@Sample(name="SampleProvider", description="This sample demonstrates registration, listing and deregistration of a VASA provider. It requires access to an active VASA provider.")
public class SampleProvider {
    private String url;
    private String username;
    private String password;
    private String provUsername;
    private String provPassword;
    private String provUrl;
    private SmServiceConnection conn;
    private VasaProviderSpec spec;
    private LocalizedMethodFault temp;
    private SmsPortType service;
    private ManagedObjectReference storageMgr;
    private ManagedObjectReference provider;
    private final int MAX_ATTEMPTS = 100;
    private final int SLEEP_INTERVAL = 1000;

    @Option(name="url", required=true, description="url of the vCenter web service")
    public void setUrl(String string) {
        this.url = string;
    }

    @Option(name="username", required=true, description="username for authenticating with vCenter")
    public void setUsername(String string) {
        this.username = string;
    }

    @Option(name="password", required=true, description="password for authenticating with vCenter")
    public void setPassword(String string) {
        this.password = string;
    }

    @Option(name="provUsername", required=true, description="username for authenticating with the provider")
    public void setProvUsername(String string) {
        this.provUsername = string;
    }

    @Option(name="provPassword", required=true, description="password for authenticating with the provider")
    public void setProvPassword(String string) {
        this.provPassword = string;
    }

    @Option(name="provUrl", required=true, description="url of the VASA provider web service")
    public void setProvUrl(String string) {
        this.provUrl = string;
    }

    public void init() throws Exception {
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType("SmsServiceInstance");
        managedObjectReference.setValue("ServiceInstance");
        this.service = this.conn.getSmsPort();
        this.storageMgr = this.service.queryStorageManager(managedObjectReference);
    }

    private void registerProvider() throws Exception {
        block1: {
            while (true) {
                RegistrationResult registrationResult = this.registerProvider(this.spec);
                this.provider = registrationResult.getProvider();
                if (this.provider != null) break block1;
                MethodFault methodFault = registrationResult.getFault();
                if (methodFault == null || !(methodFault instanceof CertificateNotTrusted)) break;
                this.spec.setCertificate(((CertificateNotTrusted)methodFault).getCertificate());
            }
            throw new RuntimeException("Registration failed");
        }
    }

    private RegistrationResult registerProvider(VasaProviderSpec vasaProviderSpec) throws Exception {
        ManagedObjectReference managedObjectReference = this.service.registerProviderTask(this.storageMgr, (SmsProviderSpec)vasaProviderSpec);
        SmsTaskInfo smsTaskInfo = this.waitForTask(managedObjectReference);
        RegistrationResult registrationResult = new RegistrationResult();
        if (smsTaskInfo != null) {
            if (smsTaskInfo.getState().equals("error")) {
                LocalizedMethodFault localizedMethodFault = smsTaskInfo.getError();
                registrationResult.setFault(localizedMethodFault.getFault());
                return registrationResult;
            }
            if (smsTaskInfo.getState().equals("success")) {
                registrationResult.setProvider((ManagedObjectReference)this.service.querySmsTaskResult(managedObjectReference));
                return registrationResult;
            }
        }
        throw new RuntimeException("Register timed out");
    }

    private void listProviders() throws Exception {
        List list = this.service.queryProvider(this.storageMgr);
        if (list == null || list.isEmpty()) {
            System.out.println("No providers found.");
            return;
        }
        for (ManagedObjectReference managedObjectReference : list) {
            VasaProviderInfo vasaProviderInfo = (VasaProviderInfo)this.service.queryProviderInfo(managedObjectReference);
            System.out.println("Found provider:");
            System.out.println("Name: " + vasaProviderInfo.getName());
            System.out.println("Url: " + vasaProviderInfo.getUrl());
            System.out.println("API Version: " + vasaProviderInfo.getVasaVersion());
            System.out.println("Status: " + vasaProviderInfo.getStatus());
        }
    }

    private void unregisterProvider() throws Exception {
        VasaProviderInfo vasaProviderInfo = (VasaProviderInfo)this.service.queryProviderInfo(this.provider);
        ManagedObjectReference managedObjectReference = this.service.unregisterProviderTask(this.storageMgr, vasaProviderInfo.getUid());
        SmsTaskInfo smsTaskInfo = this.waitForTask(managedObjectReference);
        if (smsTaskInfo != null) {
            if (smsTaskInfo.getState().equals("error")) {
                throw new RuntimeException("Unregister failed");
            }
            if (smsTaskInfo.getState().equals("success")) {
                return;
            }
        }
        throw new RuntimeException("Unregister timed out");
    }

    private SmsTaskInfo waitForTask(ManagedObjectReference managedObjectReference) throws Exception {
        SmsTaskInfo smsTaskInfo = null;
        for (int i = 0; i < 100; ++i) {
            Thread.sleep(1000L);
            smsTaskInfo = this.service.querySmsTaskInfo(managedObjectReference);
            if (!smsTaskInfo.getState().equals("running")) break;
        }
        return smsTaskInfo;
    }

    private static void printUsage() {
        System.out.println("This sample demonstrates registration, listing and deregistration of a VASA provider. It requires access to an active VASA provider.");
        System.out.println("\nParameters:");
        System.out.println("url             [required] : url of the vCenter web service.");
        System.out.println("username        [required] : username for authentication with vCenter");
        System.out.println("password        [required] : password for authentication with vCenter");
        System.out.println("provUrl         [required] : url of the VASA provider web service");
        System.out.println("provUsername    [required] : username for authentication with the provider");
        System.out.println("provPassword    [required] : password for authentication with the provider");
        System.out.println("\nCommand:");
        System.out.println("run[.bat|.sh] com.vmware.samples.sms.SampleProvider --url [webserviceurl]");
        System.out.println("--username [username] --password [password]");
        System.out.println("--provUrl [provUrl] --provUsername [provUsername] --provPassword [provPassword]");
    }

    @Action
    public void main() throws Exception {
        if (this.url == null || this.username == null || this.password == null || this.provUsername == null || this.provPassword == null || this.provUrl == null) {
            SampleProvider.printUsage();
            return;
        }
        this.conn = new SmServiceConnection(this.url, this.username, this.password);
        this.spec = new VasaProviderSpec();
        this.spec.setName("VasaProvider");
        this.spec.setUrl(this.provUrl);
        this.spec.setUsername(this.provUsername);
        this.spec.setPassword(this.provPassword);
        this.init();
        System.out.println("Querying registered providers...");
        this.listProviders();
        System.out.println("\n\nRegistering provider...");
        this.registerProvider();
        System.out.println("\n\nQuerying registered providers...");
        this.listProviders();
        System.out.println("\n\nUnregistering provider...");
        this.unregisterProvider();
        System.out.println("\n\nQuerying registered providers...");
        this.listProviders();
    }

    private static class RegistrationResult {
        private ManagedObjectReference provider;
        private MethodFault fault;

        private RegistrationResult() {
        }

        public void setProvider(ManagedObjectReference managedObjectReference) {
            this.provider = managedObjectReference;
        }

        public ManagedObjectReference getProvider() {
            return this.provider;
        }

        public void setFault(MethodFault methodFault) {
            this.fault = methodFault;
        }

        public MethodFault getFault() {
            return this.fault;
        }
    }
}

