/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.samples;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.pbm.InvalidArgumentFaultMsg;
import com.vmware.pbm.PbmCapabilityConstraintInstance;
import com.vmware.pbm.PbmCapabilityConstraints;
import com.vmware.pbm.PbmCapabilityDescription;
import com.vmware.pbm.PbmCapabilityDiscreteSet;
import com.vmware.pbm.PbmCapabilityInstance;
import com.vmware.pbm.PbmCapabilityMetadata;
import com.vmware.pbm.PbmCapabilityProfileCreateSpec;
import com.vmware.pbm.PbmCapabilityPropertyInstance;
import com.vmware.pbm.PbmCapabilityPropertyMetadata;
import com.vmware.pbm.PbmCapabilitySubProfile;
import com.vmware.pbm.PbmCapabilitySubProfileConstraints;
import com.vmware.pbm.PbmDuplicateNameFaultMsg;
import com.vmware.pbm.PbmFaultProfileStorageFaultFaultMsg;
import com.vmware.pbm.PbmProfileId;
import com.vmware.pbm.PbmServiceInstanceContent;
import com.vmware.spbm.connection.ConnectedServiceBase;
import com.vmware.spbm.connection.helpers.PbmUtil;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.List;

@Sample(name="createprofile", description="Creates a new storage tag-based storage profile with one rule-set. The rule-set contains a rule based on tags.")
public class CreateProfile
extends ConnectedServiceBase {
    private PbmServiceInstanceContent spbmsc;
    private String tagCategoryName;
    private String profileName;

    @Action
    public void createProfile() throws RuntimeFaultFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, InvalidArgumentFaultMsg, PbmDuplicateNameFaultMsg, PbmFaultProfileStorageFaultFaultMsg {
        Object object2;
        this.spbmsc = this.connection.getPbmServiceContent();
        ManagedObjectReference managedObjectReference = this.spbmsc.getProfileManager();
        List list = this.connection.getPbmPort().pbmFetchCapabilityMetadata(managedObjectReference, PbmUtil.getStorageResourceType(), null);
        PbmCapabilityMetadata pbmCapabilityMetadata = PbmUtil.getTagCategoryMeta(this.tagCategoryName, list);
        if (pbmCapabilityMetadata == null) {
            throw new InvalidArgumentFaultMsg("Specified Tag Category does not exist", null);
        }
        List list2 = pbmCapabilityMetadata.getPropertyMetadata();
        PbmCapabilityPropertyMetadata pbmCapabilityPropertyMetadata = (PbmCapabilityPropertyMetadata)list2.get(0);
        PbmCapabilityPropertyInstance pbmCapabilityPropertyInstance = new PbmCapabilityPropertyInstance();
        pbmCapabilityPropertyInstance.setId(pbmCapabilityPropertyMetadata.getId());
        PbmCapabilityDiscreteSet pbmCapabilityDiscreteSet = (PbmCapabilityDiscreteSet)pbmCapabilityPropertyMetadata.getAllowedValue();
        if (pbmCapabilityDiscreteSet == null || pbmCapabilityDiscreteSet.getValues().isEmpty()) {
            throw new RuntimeFaultFaultMsg("Specified Tag Category '" + this.tagCategoryName + "' does not have any associated tags", null);
        }
        PbmCapabilityDiscreteSet pbmCapabilityDiscreteSet2 = new PbmCapabilityDiscreteSet();
        for (Object object2 : pbmCapabilityDiscreteSet.getValues()) {
            pbmCapabilityDiscreteSet2.getValues().add(((PbmCapabilityDescription)object2).getValue());
        }
        pbmCapabilityPropertyInstance.setValue((Object)pbmCapabilityDiscreteSet2);
        PbmCapabilityConstraintInstance pbmCapabilityConstraintInstance = new PbmCapabilityConstraintInstance();
        pbmCapabilityConstraintInstance.getPropertyInstance().add(pbmCapabilityPropertyInstance);
        object2 = new PbmCapabilityInstance();
        object2.setId(pbmCapabilityMetadata.getId());
        object2.getConstraint().add(pbmCapabilityConstraintInstance);
        PbmCapabilitySubProfile pbmCapabilitySubProfile = new PbmCapabilitySubProfile();
        pbmCapabilitySubProfile.getCapability().add(object2);
        PbmCapabilitySubProfileConstraints pbmCapabilitySubProfileConstraints = new PbmCapabilitySubProfileConstraints();
        pbmCapabilitySubProfile.setName("Rule-Set" + (pbmCapabilitySubProfileConstraints.getSubProfiles().size() + 1));
        pbmCapabilitySubProfileConstraints.getSubProfiles().add(pbmCapabilitySubProfile);
        PbmCapabilityProfileCreateSpec pbmCapabilityProfileCreateSpec = new PbmCapabilityProfileCreateSpec();
        pbmCapabilityProfileCreateSpec.setName(this.profileName);
        pbmCapabilityProfileCreateSpec.setDescription("Tag Based Storage Profile Created by SDK Samples. Rule based on tags from Category " + this.tagCategoryName);
        pbmCapabilityProfileCreateSpec.setResourceType(PbmUtil.getStorageResourceType());
        pbmCapabilityProfileCreateSpec.setConstraints((PbmCapabilityConstraints)pbmCapabilitySubProfileConstraints);
        PbmProfileId pbmProfileId = this.connection.getPbmPort().pbmCreate(managedObjectReference, pbmCapabilityProfileCreateSpec);
        System.out.println("Profile " + this.profileName + " created with ID: " + pbmProfileId.getUniqueId());
    }

    @Option(name="profilename", description="Name of the storage profile", required=true)
    public void setProfileName(String string) {
        this.profileName = string;
    }

    @Option(name="tag_category", description="Category Name of the tags. All tags in this category are added to the rule.", required=true)
    public void setTagCategoryName(String string) {
        this.tagCategoryName = string;
    }
}

