/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.config.impl;

import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.binding.vim.vm.ConfigSpec;
import com.vmware.vim.binding.vim.vm.ReplicationConfigSpec;
import com.vmware.vim.binding.vmodl.DynamicData;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.vm.VmConfigSpec;
import com.vmware.vsphere.client.vm.util.Util;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigSpecBuilder {
    private static final Log _logger = LogFactory.getLog(ConfigSpecBuilder.class);

    public static ConfigSpec createSpec(ConfigInfo config) throws Exception {
        _logger.debug((Object)"createSpec from ConfigInfo");
        ConfigSpec spec = new ConfigSpec();
        Field[] fldsInfo = ConfigInfo.class.getDeclaredFields();
        Field[] fldsSpec = ConfigSpec.class.getDeclaredFields();
        for (Field infoField : fldsInfo) {
            if (!Modifier.isPublic(infoField.getModifiers())) continue;
            Object value = infoField.get(config);
            if (value == null) {
                _logger.debug((Object)("...Skipping null value field " + infoField.getName()));
                continue;
            }
            Boolean bFound = false;
            for (Field specField : fldsSpec) {
                if (infoField.getName() != specField.getName()) continue;
                if (infoField.getType() != specField.getType()) {
                    _logger.debug((Object)("...Skipping bad type field " + infoField.getName()));
                    continue;
                }
                specField.set(spec, value);
                bFound = true;
                break;
            }
            if (bFound.booleanValue()) continue;
            _logger.debug((Object)("...Skipping unmatched field " + infoField.getName()));
        }
        if (config.hardware != null) {
            spec.numCPUs = config.hardware.numCPU;
            spec.numCoresPerSocket = config.hardware.numCoresPerSocket;
            spec.memoryMB = config.hardware.memoryMB;
            spec.virtualICH7MPresent = config.hardware.virtualICH7MPresent;
            spec.virtualSMCPresent = config.hardware.virtualSMCPresent;
        }
        spec.powerOpInfo = config.defaultPowerOps;
        return spec;
    }

    public static ConfigSpec createSpec(VmConfigSpec vmSpec) throws Exception {
        ConfigSpec spec = ConfigSpecBuilder.createSpec(vmSpec.config);
        spec.deviceChange = vmSpec.deviceChange;
        spec.cpuFeatureMask = vmSpec.cpuFeatureMask;
        spec.npivWorldWideNameOp = vmSpec.npivWwnOp;
        spec.vmProfile = vmSpec.profile;
        spec.crypto = vmSpec.cryptoSpec;
        return spec;
    }

    public static ConfigSpec buildSpec(VmConfigSpec vmConfigSpec) throws Exception {
        _logger.debug((Object)"buildSpec");
        ConfigInfo originalConfig = vmConfigSpec.originalConfig;
        ConfigInfo desiredConfig = vmConfigSpec.config;
        if (originalConfig == null) {
            ConfigSpec result = ConfigSpecBuilder.createSpec(desiredConfig);
            result.vmProfile = vmConfigSpec.profile;
            return result;
        }
        ConfigSpec outSpec = ConfigSpecBuilder.createSpec(originalConfig);
        ConfigSpecBuilder.makeDiff(outSpec, desiredConfig);
        outSpec.numCPUs = originalConfig.hardware.numCPU != desiredConfig.hardware.numCPU ? new Integer(desiredConfig.hardware.numCPU) : null;
        Integer origCoresPerSocket = originalConfig.hardware.numCoresPerSocket;
        Integer desiredCoresPerSocket = desiredConfig.hardware.numCoresPerSocket;
        outSpec.numCoresPerSocket = origCoresPerSocket != null && desiredCoresPerSocket != null && origCoresPerSocket.compareTo(desiredCoresPerSocket) != 0 ? desiredCoresPerSocket : null;
        outSpec.memoryMB = originalConfig.hardware.memoryMB != desiredConfig.hardware.memoryMB ? new Long(desiredConfig.hardware.memoryMB) : null;
        outSpec.virtualICH7MPresent = desiredConfig.hardware.virtualICH7MPresent != null && desiredConfig.hardware.virtualICH7MPresent != originalConfig.hardware.virtualICH7MPresent ? desiredConfig.hardware.virtualICH7MPresent : null;
        outSpec.virtualSMCPresent = desiredConfig.hardware.virtualSMCPresent != null && desiredConfig.hardware.virtualSMCPresent != originalConfig.hardware.virtualSMCPresent ? desiredConfig.hardware.virtualSMCPresent : null;
        outSpec.npivWorldWideNameOp = vmConfigSpec.npivWwnOp;
        outSpec.deviceChange = vmConfigSpec.deviceChange;
        outSpec.cpuFeatureMask = vmConfigSpec.cpuFeatureMask;
        if (vmConfigSpec.vAppConfigRemoved) {
            outSpec.vAppConfigRemoved = true;
        } else {
            outSpec.vAppConfig = vmConfigSpec.vAppConfig;
        }
        outSpec.vmProfile = vmConfigSpec.profile;
        return outSpec;
    }

    private static boolean makeDiff(Object oldObj, Object newObj) throws Exception {
        String propName;
        int modifiers;
        Field[] fiedlds;
        assert (oldObj != null);
        assert (newObj != null);
        Class<?> type = oldObj.getClass();
        boolean areObjectsEqual = true;
        Map<String, Boolean> mapOptionalProps = ConfigSpecBuilder.getOptionalFields(type);
        HashMap<String, Field> mapNewObjPropsByName = new HashMap<String, Field>();
        for (Field fld : fiedlds = newObj.getClass().getDeclaredFields()) {
            modifiers = fld.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            propName = fld.getName();
            if (propName == "defaultPowerOps") {
                propName = "powerOpInfo";
            }
            mapNewObjPropsByName.put(propName, fld);
        }
        for (Field oldField : fiedlds = type.getDeclaredFields()) {
            Class<?> propType;
            Field newField;
            modifiers = oldField.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || (newField = (Field)mapNewObjPropsByName.get(propName = oldField.getName())) == null) continue;
            Object oldProp = oldField.get(oldObj);
            Object newProp = newField.get(newObj);
            if (propName == "changeVersion") {
                oldField.set(oldObj, newProp);
                continue;
            }
            if (propName == "cpuFeatureMask" || propName == "vAppConfig") continue;
            Boolean isOptional = mapOptionalProps.get(propName);
            if (isOptional == null) {
                String errorMsg = ResourceUtil.getString((String)Util.VM_SERVICE_STRINGS, (String)"error.unrecognizedVmProperty", (String[])new String[]{propName}, (ClassLoader)ConfigSpecBuilder.class.getClassLoader());
                _logger.error((Object)errorMsg);
                throw new Exception(errorMsg);
            }
            if (oldProp != null) {
                propType = oldProp.getClass();
            } else {
                if (newProp == null) continue;
                propType = newProp.getClass();
            }
            if (oldProp == null || newProp == null) {
                oldField.set(oldObj, newProp);
                areObjectsEqual = false;
                continue;
            }
            if (DynamicData.class.isAssignableFrom(propType)) {
                if (ConfigSpecBuilder.makeDiff(oldProp, newProp)) {
                    if (!isOptional.booleanValue()) continue;
                    oldField.set(oldObj, null);
                    continue;
                }
                areObjectsEqual = false;
                continue;
            }
            if (ConfigSpecBuilder.compare(oldProp, newProp)) {
                if (!isOptional.booleanValue()) continue;
                oldField.set(oldObj, null);
                continue;
            }
            oldField.set(oldObj, newProp);
            areObjectsEqual = false;
        }
        return areObjectsEqual;
    }

    private static Map<String, Boolean> getOptionalFields(Class<?> type) {
        Method[] methods;
        assert (type != null);
        HashMap<String, Boolean> mapOptionalProps = new HashMap<String, Boolean>();
        if (type == null) {
            return mapOptionalProps;
        }
        for (Method method : methods = type.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            boolean hasReturnValue = !Void.TYPE.equals(returnType);
            boolean returnsBool = Boolean.TYPE.equals(returnType) || Boolean.class.equals(returnType);
            boolean hasParams = method.getParameterTypes().length != 0;
            boolean hasPrefixGet = methodName.startsWith("get");
            boolean hasPrefixIs = methodName.startsWith("is");
            if (!hasPrefixGet && (!hasPrefixIs || !returnsBool) || !hasReturnValue || hasParams) continue;
            optional ann = method.getAnnotation(optional.class);
            Boolean isOptional = ann != null;
            String propName = hasPrefixGet ? methodName.substring(3, 4).toLowerCase(Locale.ENGLISH) + methodName.substring(4) : methodName.substring(2, 3).toLowerCase(Locale.ENGLISH) + methodName.substring(3);
            mapOptionalProps.put(propName, isOptional);
        }
        return mapOptionalProps;
    }

    private static boolean compare(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class<?> type = a.getClass();
        assert (type == b.getClass());
        if (type.isArray()) {
            if (type == int[].class) {
                return Arrays.equals((int[])a, (int[])b);
            }
            if (type == long[].class) {
                return Arrays.equals((long[])a, (long[])b);
            }
            if (type == boolean[].class) {
                return Arrays.equals((boolean[])a, (boolean[])b);
            }
            if (type == short[].class) {
                return Arrays.equals((short[])a, (short[])b);
            }
            if (type == byte[].class) {
                return Arrays.equals((byte[])a, (byte[])b);
            }
            if (type == char[].class) {
                return Arrays.equals((char[])a, (char[])b);
            }
            if (type == double[].class) {
                return Arrays.equals((double[])a, (double[])b);
            }
            if (type == float[].class) {
                return Arrays.equals((float[])a, (float[])b);
            }
            if (DynamicData[].class.isAssignableFrom(type)) {
                if (type == OptionValue[].class) {
                    return ConfigSpecBuilder.compareOptionValueArrays((OptionValue[])a, (OptionValue[])b);
                }
                if (type == ReplicationConfigSpec.DiskSettings[].class) {
                    boolean result = ConfigSpecBuilder.compareReplicationConfigSpec_DiskSettingsArrays((ReplicationConfigSpec.DiskSettings[])a, (ReplicationConfigSpec.DiskSettings[])b);
                    return result;
                }
                return false;
            }
            return Arrays.equals((Object[])a, (Object[])b);
        }
        return a.equals(b);
    }

    private static boolean compareReplicationConfigSpec_DiskSettingsArrays(ReplicationConfigSpec.DiskSettings[] a, ReplicationConfigSpec.DiskSettings[] b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null || a != null && b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].key == b[i].key && Objects.equals(a[i].diskReplicationId, b[i].diskReplicationId)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareOptionValueArrays(OptionValue[] a, OptionValue[] b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null || a != null && b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Objects.equals(a[i].key, b[i].key) && Objects.equals(a[i].value, b[i].value)) continue;
            return false;
        }
        return true;
    }
}

