/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.customizations.impl;

import com.vmware.vim.binding.vim.CustomizationSpecItem;
import com.vmware.vim.binding.vim.CustomizationSpecManager;
import com.vmware.vim.binding.vim.vm.customization.Sysprep;
import com.vmware.vim.binding.vim.vm.customization.SysprepText;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationImportValidationResult;
import com.vmware.vsphere.client.vm.customizations.VmCustomizationImportValidationSpec;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmCustomizationValidator {
    private static Log _logger = LogFactory.getLog(VmCustomizationValidator.class);

    public ValidationResult checkImport(VmCustomizationImportValidationSpec spec) {
        ValidationResult result = new ValidationResult();
        try {
            CustomizationSpecManager manager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.customizationSpecManager);
            assert (spec.customizationSpecText.length() > 0);
            CustomizationSpecItem specItem = manager.xmlToSpecItem(spec.customizationSpecText);
            VmCustomizationImportValidationResult validationResult = new VmCustomizationImportValidationResult();
            validationResult.customizationSpecItem = specItem;
            validationResult.validationSucceeded = VmCustomizationValidator.checkPublicKey(manager, specItem);
            result.result = validationResult;
        }
        catch (Exception ex) {
            _logger.error((Object)"Error occurred while importing vm customization spec.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public static boolean checkPublicKey(CustomizationSpecManager specMgr, CustomizationSpecItem specItem) {
        if (!"Windows".equalsIgnoreCase(specItem.info.type)) {
            return true;
        }
        if (specItem.spec.identity instanceof SysprepText) {
            return true;
        }
        byte[] key = specMgr.getEncryptionKey();
        if (!Arrays.equals(key, specItem.spec.encryptionKey)) {
            Sysprep identity = (Sysprep)specItem.spec.identity;
            if (identity.guiUnattended.password != null) {
                identity.guiUnattended.password.value = "";
                identity.guiUnattended.password.plainText = true;
            }
            if (identity.identification.domainAdminPassword != null) {
                identity.identification.domainAdminPassword.value = "";
                identity.identification.domainAdminPassword.plainText = true;
            }
            return false;
        }
        return true;
    }
}

