/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.guest.auth.impl;

import com.vmware.vim.binding.vim.vm.guest.AliasManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.vm.guest.auth.GuestAliasAdditionSpec;
import com.vmware.vsphere.client.vm.guest.auth.GuestAliasRemovalSpec;
import com.vmware.vsphere.client.vm.guest.auth.GuestAuthSpec;
import com.vmware.vsphere.client.vm.guest.auth.impl.VmGuestUtilities;

public class VmGuestAliasMutationProvider
implements MutationProvider {
    public OperationResult apply(ManagedObjectReference vmRef, GuestAliasAdditionSpec spec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{spec});
        OperationResult result = this.createGenericOperationResult(vmRef);
        try {
            AliasManager aliasMgr = VmGuestUtilities.getAliasManager(vmRef);
            GuestAuthSpec guestAuthSpec = VmGuestUtilities.decrypt(spec.auth, vmRef);
            aliasMgr.addAlias(spec.vm, guestAuthSpec.guestAuth, spec.username, true, spec.base64Cert, spec.aliasInfo);
        }
        catch (Exception exception) {
            result.error = exception;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vmRef, GuestAliasRemovalSpec spec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{spec});
        OperationResult result = this.createGenericOperationResult(vmRef);
        try {
            AliasManager aliasMgr = VmGuestUtilities.getAliasManager(vmRef);
            GuestAuthSpec guestAuthSpec = VmGuestUtilities.decrypt(spec.auth, vmRef);
            aliasMgr.removeAlias(spec.vm, guestAuthSpec.guestAuth, spec.username, spec.base64Cert, spec.subject);
        }
        catch (Exception exception) {
            result.error = exception;
        }
        return result;
    }

    private OperationResult createGenericOperationResult(ManagedObjectReference vmRef) {
        OperationResult result = new OperationResult();
        OperationEffect effect = new OperationEffect();
        effect.affectedEntites = new Object[]{vmRef};
        result.effect = effect;
        return result;
    }
}

