/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.ConfigInfoEx;
import com.vmware.vim.binding.vim.vm.CloneSpec;
import com.vmware.vim.binding.vim.vm.RelocateSpec;
import com.vmware.vim.binding.vim.vm.check.TestType;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.vm.VmCloneSpec;
import com.vmware.vsphere.client.vm.VmProvisioningType;
import com.vmware.vsphere.client.vm.impl.CompatibilityResult;
import com.vmware.vsphere.client.vm.impl.CompatibilityValidator;
import com.vmware.vsphere.client.vm.util.CompatibilityCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceCompatibilityValidator
implements CompatibilityValidator {
    public static final String PROPERTY_IS_RP_IN_VAPP = "isInVApp";
    public static final String PARENT_VAPP = "vapp";
    public static final String PARENT_FOLDER = "folder";
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;

    public ResourceCompatibilityValidator(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryExecutor, querySpecBuilder});
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @Override
    public CompatibilityResult validate(ManagedObjectReference objRef, CompatibilityCheck preCheckSpec) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objRef, preCheckSpec, preCheckSpec.targetRef});
        ManagedObjectReference targetRef = preCheckSpec.targetRef;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, ClusterComputeResource.class)) {
            return this.runClusterPreCheck(objRef, preCheckSpec);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, HostSystem.class)) {
            return this.runHostPreCheck(objRef, preCheckSpec);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, ResourcePool.class)) {
            return this.runResourcePoolOrVappPreCheck(objRef, preCheckSpec);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, VirtualApp.class)) {
            return this.runResourcePoolOrVappPreCheck(objRef, preCheckSpec);
        }
        return this.error("compatibilityError.SelectRPOnly");
    }

    private boolean isOneHostConnected(PropertyValue[] hostsProperties) {
        HashMap map = new HashMap();
        for (PropertyValue pv : hostsProperties) {
            List propertyValues = (List)map.get(pv.resourceObject);
            if (propertyValues == null) {
                ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
                values.add(pv);
                map.put((ManagedObjectReference)pv.resourceObject, values);
                continue;
            }
            propertyValues.add(pv);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!this.isHostAvailable(((List)entry.getValue()).toArray(new PropertyValue[0]))) continue;
            return true;
        }
        return false;
    }

    private boolean isHostAvailable(PropertyValue[] hostProperties) {
        boolean isHostConnected = false;
        boolean isHostInMaintenanceMode = false;
        boolean isHostInTransition = false;
        for (PropertyValue pv : hostProperties) {
            if (pv.propertyName.equals("runtime.connectionState")) {
                isHostConnected = pv.value == HostSystem.ConnectionState.connected;
                continue;
            }
            if (pv.propertyName.equals("runtime.inMaintenanceMode")) {
                isHostInMaintenanceMode = (Boolean)pv.value;
                continue;
            }
            if (!pv.propertyName.equals("disabledMethod")) continue;
            String[] disabledMethods = (String[])pv.value;
            List<String> arrayList = Arrays.asList(disabledMethods);
            isHostInTransition = arrayList.contains("EnterMaintenanceMode_Task") && arrayList.contains("ExitMaintenanceMode_Task");
        }
        return isHostConnected && !isHostInMaintenanceMode && !isHostInTransition;
    }

    private VmCloneSpec createVmCloneSpec(ManagedObjectReference objRef, CompatibilityCheck preCheckSpec, ManagedObjectReference host, ManagedObjectReference pool) {
        VmCloneSpec vmCloneSpec = new VmCloneSpec();
        vmCloneSpec.vm = ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualMachine.class) ? objRef : null;
        vmCloneSpec.name = preCheckSpec.vmName;
        vmCloneSpec.cloneSpec = new CloneSpec();
        vmCloneSpec.cloneSpec.template = this.isTemplate(preCheckSpec.vmProvisioningType);
        vmCloneSpec.cloneSpec.location = new RelocateSpec();
        vmCloneSpec.cloneSpec.location.pool = pool;
        vmCloneSpec.cloneSpec.location.host = host;
        vmCloneSpec.testsToRun = this.getVcTestsToRun(preCheckSpec.vmProvisioningType);
        vmCloneSpec.folder = preCheckSpec.folderRef;
        return vmCloneSpec;
    }

    private boolean isTemplate(VmProvisioningType type2) {
        return type2 == VmProvisioningType.cloneTemplateToTemplate || type2 == VmProvisioningType.cloneTemplateToVm;
    }

    private TestType[] getVcTestsToRun(VmProvisioningType type2) {
        if (type2 == VmProvisioningType.cloneTemplateToVm || type2 == VmProvisioningType.cloneVmToVm) {
            return new TestType[]{TestType.sourceTests, TestType.resourcePoolTests, TestType.hostTests, TestType.networkTests};
        }
        if (type2 == VmProvisioningType.cloneTemplateToTemplate || type2 == VmProvisioningType.cloneVmToTemplate) {
            return new TestType[]{TestType.sourceTests, TestType.hostTests, TestType.networkTests};
        }
        return new TestType[0];
    }

    private CompatibilityResult runHostPreCheck(ManagedObjectReference objRef, CompatibilityCheck preCheckSpec) throws Exception {
        ManagedObjectReference targetRef = preCheckSpec.targetRef;
        ManagedObjectReference pool = this.getHostResourcePool(targetRef);
        PropertyValue[] props = this._queryExecutor.getProperties((Object)targetRef, new String[]{"runtime.connectionState", "runtime.inMaintenanceMode", "disabledMethod"});
        if (!this.isHostAvailable(props)) {
            return this.error("compatibilityError.HostNotConnected");
        }
        if (!this.isTemplate(preCheckSpec.vmProvisioningType)) {
            // empty if block
        }
        VmCloneSpec vmCloneSpec = this.createVmCloneSpec(objRef, preCheckSpec, preCheckSpec.targetRef, pool);
        return this.success(vmCloneSpec, PARENT_FOLDER);
    }

    private CompatibilityResult runClusterPreCheck(ManagedObjectReference objRef, CompatibilityCheck preCheckSpec) throws Exception {
        PropertyValue[] properties = this._queryExecutor.getProperties((Object)preCheckSpec.targetRef, new String[]{"resourcePool", "host", "configurationEx"});
        ComputeResourceData crData = this.getComputeResourceDataProperties(properties);
        if (crData.hosts == null || crData.hosts.length == 0) {
            return this.error("compatibilityError.NoHostsFound");
        }
        PropertyValue[] hostsProperties = this._queryExecutor.getProperties((Object[])crData.hosts, new String[]{"runtime.connectionState", "runtime.inMaintenanceMode", "disabledMethod"});
        if (!this.isOneHostConnected(hostsProperties)) {
            return this.error("compatibilityError.NoConnectedHostsFound");
        }
        if (crData.config instanceof ConfigInfoEx && !((ConfigInfoEx)crData.config).drsConfig.enabled.booleanValue()) {
            return this.error("compatibilityError.nonDrsCluster");
        }
        if (!this.isTemplate(preCheckSpec.vmProvisioningType)) {
            // empty if block
        }
        VmCloneSpec vmCloneSpec = this.createVmCloneSpec(objRef, preCheckSpec, null, crData.resourcePool);
        return this.success(vmCloneSpec, PARENT_FOLDER);
    }

    private CompatibilityResult runResourcePoolOrVappPreCheck(ManagedObjectReference objRef, CompatibilityCheck preCheckSpec) throws Exception {
        Constraint constraint = this._querySpecBuilder.createConstraintForRelationship((Object)preCheckSpec.targetRef, "owner", "ComputeResource");
        String[] properties = new String[]{"resourcePool", "host", "configurationEx"};
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(constraint, properties);
        ResultSet data2 = this._queryExecutor.getData(querySpec);
        ComputeResourceData crData = this.getComputeResourceDataProperties(data2.items[0].properties);
        if (crData.hosts == null || crData.hosts.length == 0) {
            return this.error("compatibilityError.NoHostsFound");
        }
        PropertyValue[] hostsProperties = this._queryExecutor.getProperties((Object[])crData.hosts, new String[]{"runtime.connectionState", "runtime.inMaintenanceMode", "disabledMethod"});
        if (!this.isOneHostConnected(hostsProperties)) {
            String key = crData.config != null ? "compatibilityError.ParentClusterNoConnectedHostsFound" : "compatibilityError.ParentHostNotConnected";
            return this.error(key);
        }
        String parentType = PARENT_VAPP;
        if (this.isTemplate(preCheckSpec.vmProvisioningType)) {
            parentType = PARENT_FOLDER;
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)preCheckSpec.targetRef, ResourcePool.class)) {
            boolean isInVapp = (Boolean)this._queryExecutor.getProperty((Object)preCheckSpec.targetRef, PROPERTY_IS_RP_IN_VAPP);
            parentType = isInVapp ? PARENT_VAPP : PARENT_FOLDER;
        }
        VmCloneSpec vmCloneSpec = this.createVmCloneSpec(objRef, preCheckSpec, null, crData.resourcePool);
        return this.success(vmCloneSpec, parentType);
    }

    private ManagedObjectReference getHostResourcePool(ManagedObjectReference targetRef) throws Exception {
        Constraint constraint = this._querySpecBuilder.createConstraintForRelationship((Object)targetRef, "parent", "ComputeResource");
        String[] properties = new String[]{"resourcePool"};
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(constraint, properties);
        ResultSet data2 = this._queryExecutor.getData(querySpec);
        for (ResultItem item : data2.items) {
            for (PropertyValue pv : item.properties) {
                if (!pv.propertyName.equals("resourcePool")) continue;
                return (ManagedObjectReference)pv.value;
            }
        }
        throw new IllegalStateException("resource pool for host could not be found!");
    }

    private ComputeResourceData getComputeResourceDataProperties(PropertyValue[] properties) {
        ManagedObjectReference rootResourcePool = null;
        ManagedObjectReference[] hosts = null;
        ComputeResource.ConfigInfo config = null;
        for (PropertyValue pv : properties) {
            if (pv.propertyName.equals("resourcePool")) {
                rootResourcePool = (ManagedObjectReference)pv.value;
                continue;
            }
            if (pv.propertyName.equals("host")) {
                hosts = (ManagedObjectReference[])pv.value;
                continue;
            }
            if (!pv.propertyName.equals("configurationEx")) continue;
            config = (ComputeResource.ConfigInfo)pv.value;
        }
        ComputeResourceData result = new ComputeResourceData();
        result.config = config;
        result.hosts = hosts;
        result.resourcePool = rootResourcePool;
        return result;
    }

    private CompatibilityResult error(String message) {
        CompatibilityResult compatibilityResult = new CompatibilityResult();
        compatibilityResult.errors = new String[]{ResourceUtil.getString((String)"vmservice", (String)message, (ClassLoader)this.getClass().getClassLoader())};
        return compatibilityResult;
    }

    public CompatibilityResult error(String key, String[] parameters) {
        CompatibilityResult compatibilityResult = new CompatibilityResult();
        compatibilityResult.errors = new String[]{ResourceUtil.getString((String)"vmservice", (String)key, (String[])parameters, (ClassLoader)this.getClass().getClassLoader())};
        return compatibilityResult;
    }

    private CompatibilityResult success(VmCloneSpec spec, String parentType) {
        CompatibilityResult compatibilityResult = new CompatibilityResult();
        compatibilityResult.vmCloneSpec = spec;
        compatibilityResult.parentType = parentType;
        return compatibilityResult;
    }

    private static final class ComputeResourceData {
        public ComputeResource.ConfigInfo config;
        public ManagedObjectReference resourcePool;
        public ManagedObjectReference[] hosts;

        private ComputeResourceData() {
        }
    }
}

