/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vsphere.client.vm.impl.DatastoreMirrorsInfo;
import com.vmware.vsphere.client.vm.model.VmMigrationHostItem;

public class VmMigrationProvider
implements PropertyProviderBean {
    private static final String VM_DATASTORES_INFO_PROP = "vmDatastoresInfo";
    private static final String NAME_PROP = "name";
    private static final String RP_PROP = "resourcePool";
    private static final String ICON_PROP = "primaryIconId";
    private QueryExecutor queryExecutor;
    private QuerySpecBuilder querySpecBuilder;

    public VmMigrationProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this.queryExecutor = queryExecutor;
        this.querySpecBuilder = querySpecBuilder;
    }

    @type(value="VirtualMachine")
    public VmMigrationHostItem[] getValidHostsToMigrateTo(ManagedObjectReference vmRef) throws Exception {
        DatastoreMirrorsInfo[] dsMirrorsInfo = (DatastoreMirrorsInfo[])this.queryExecutor.getProperty((Object)vmRef, VM_DATASTORES_INFO_PROP);
        CompositeConstraint cc = this.buildConstraintThatAllDatastoresAreVisible(dsMirrorsInfo);
        QuerySpec qs = this.querySpecBuilder.buildQuerySpec((Constraint)cc, new String[]{NAME_PROP, RP_PROP, ICON_PROP});
        ResultSet hostsResult = this.queryExecutor.getData(qs);
        VmMigrationHostItem[] hostItems = new VmMigrationHostItem[hostsResult.totalMatchedObjectCount.intValue()];
        for (int i = 0; i < hostsResult.totalMatchedObjectCount; ++i) {
            VmMigrationHostItem item;
            hostItems[i] = item = this.buildVmMigrationHostItem(hostsResult.items[i]);
        }
        return hostItems;
    }

    public CompositeConstraint buildConstraintThatAllDatastoresAreVisible(DatastoreMirrorsInfo[] dsMirrorsInfo) {
        Constraint[] hostConstraints = new Constraint[dsMirrorsInfo.length];
        for (int i = 0; i < dsMirrorsInfo.length; ++i) {
            ManagedObjectReference dsRef = dsMirrorsInfo[i].ref;
            hostConstraints[i] = QueryUtil.createConstraintForRelationship((Object)dsRef, (String)"hostKey", (String)HostSystem.class.getSimpleName());
        }
        return this.querySpecBuilder.createCompositeConstraint(hostConstraints, Conjoiner.AND);
    }

    public VmMigrationHostItem buildVmMigrationHostItem(ResultItem hostResult) {
        PropertyValue[] properties;
        ManagedObjectReference hostRef = (ManagedObjectReference)hostResult.resourceObject;
        String name = "";
        ManagedObjectReference parentResPoolRef = null;
        String primaryIconId = "";
        for (PropertyValue property : properties = hostResult.properties) {
            if (NAME_PROP.equals(property.propertyName)) {
                name = (String)property.value;
                continue;
            }
            if (RP_PROP.equals(property.propertyName)) {
                parentResPoolRef = (ManagedObjectReference)property.value;
                continue;
            }
            if (!ICON_PROP.equals(property.propertyName)) continue;
            primaryIconId = (String)property.value;
        }
        return new VmMigrationHostItem(name, parentResPoolRef, hostRef, primaryIconId);
    }
}

