/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.issue.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.QuestionInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;
import com.vmware.vsphere.client.vm.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="Issue,VmQuestionIssue")
public class VmQuestionIssueAdapter
extends IssueAdapterBase {
    private static final String VM_QUESTION_ISSUE_TYPE = "VmQuestionIssue";
    private static final String VM_NAME_PROPERTY = "name";
    private static final String VM_QUESTION_PROPERTY = "runtime.question";
    private static final Log _logger = LogFactory.getLog(VmQuestionIssueAdapter.class);
    private DataService _dataService;

    public VmQuestionIssueAdapter(DataService dataService) {
        super(VM_QUESTION_ISSUE_TYPE);
        this._dataService = dataService;
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        Object entity = this.extractEntityFromQuerySpec(querySpec);
        if (!(entity instanceof ManagedObjectReference) || !ManagedObjectUtil.isOfType((ManagedObjectReference)((ManagedObjectReference)entity), (String)VirtualMachine.class.getSimpleName())) {
            return new IssueAdapterBase.IssueData[0];
        }
        String vmName = null;
        QuestionInfo questionInfo = null;
        try {
            PropertyValue[] propertyValues;
            for (PropertyValue propertyValue : propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object)entity, (String[])new String[]{VM_NAME_PROPERTY, VM_QUESTION_PROPERTY})) {
                if (VM_NAME_PROPERTY.equals(propertyValue.propertyName)) {
                    vmName = (String)propertyValue.value;
                    continue;
                }
                if (!VM_QUESTION_PROPERTY.equals(propertyValue.propertyName)) continue;
                questionInfo = (QuestionInfo)propertyValue.value;
            }
            if (vmName == null) {
                _logger.warn((Object)String.format("Cound not retrieve VM name for %s", entity.toString()));
            }
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error retrieving VM question for %s", entity.toString()), (Throwable)e);
            throw new RuntimeException(e);
        }
        IssueAdapterBase.IssueData[] vmQuestionInfos = this.convertToIssue(entity, vmName, questionInfo);
        return vmQuestionInfos;
    }

    private IssueAdapterBase.IssueData[] convertToIssue(Object entity, String vmName, QuestionInfo questionInfo) {
        if (questionInfo == null) {
            return new IssueAdapterBase.IssueData[0];
        }
        IssueInfo issueInfo = new IssueInfo();
        issueInfo.typeDisplayName = Util.getLocalizedString("vmQuestionIssue.displayName");
        issueInfo.description = questionInfo.text;
        issueInfo.entity = entity;
        issueInfo.entityName = vmName;
        issueInfo.details = questionInfo;
        issueInfo.status = IssueStatus.QUESTION;
        IssueAdapterBase.IssueData issueData = new IssueAdapterBase.IssueData();
        issueData.key = questionInfo.id;
        issueData.issueInfo = issueInfo;
        return new IssueAdapterBase.IssueData[]{issueData};
    }
}

