/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.pmem.impl;

import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vim.vm.device.VirtualNVDIMM;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vsphere.client.vm.pmem.VmPmemData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VmPMemUtil {
    private static final String VM_NAME = "name";
    private static final String VM_DEVICES_PROPERTY = "config.hardware.device";
    private static final String DATASTORE_TYPE_PROPERTY = "summary.type";
    private static final String PMEM_DS_TYPE = "PMEM";

    public static VmPmemData[] filterPMemVMs(Constraint vmConstraint, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) throws Exception {
        HashSet<ManagedObjectReference> pMemVms = new HashSet<ManagedObjectReference>();
        HashMap<ManagedObjectReference, String> vmNames = new HashMap<ManagedObjectReference, String>();
        HashMap<ManagedObjectReference, VirtualDevice[]> vmDevices = new HashMap<ManagedObjectReference, VirtualDevice[]>();
        VmPMemUtil.retrieveVmNamesAndDevices(vmConstraint, queryExecutor, querySpecBuilder, vmNames, vmDevices);
        HashMap datastoresToVmsMap = new HashMap();
        for (ManagedObjectReference vmRef : vmDevices.keySet()) {
            if (VmPMemUtil.containNvDimmDevice(vmDevices.get(vmRef))) {
                pMemVms.add(vmRef);
                continue;
            }
            Set<ManagedObjectReference> vmDisksDatastores = VmPMemUtil.getDatastoresForVmDisks(vmDevices.get(vmRef));
            for (ManagedObjectReference dsRef : vmDisksDatastores) {
                if (!datastoresToVmsMap.containsKey(dsRef)) {
                    datastoresToVmsMap.put(dsRef, new ArrayList());
                }
                ((List)datastoresToVmsMap.get(dsRef)).add(vmRef);
            }
        }
        List<ManagedObjectReference> pmemDatastores = VmPMemUtil.filterPMemDatastores(datastoresToVmsMap.keySet().toArray(), queryExecutor);
        for (ManagedObjectReference pmemDatastoreRef : pmemDatastores) {
            for (ManagedObjectReference pmemVmRef : (List)datastoresToVmsMap.get(pmemDatastoreRef)) {
                pMemVms.add(pmemVmRef);
            }
        }
        return VmPMemUtil.buildVmPmemData(pMemVms, vmNames);
    }

    private static VmPmemData[] buildVmPmemData(Set<ManagedObjectReference> pmemVms, Map<ManagedObjectReference, String> vmNames) {
        VmPmemData[] result = new VmPmemData[pmemVms.size()];
        int i = 0;
        for (ManagedObjectReference vmRef : pmemVms) {
            result[i] = new VmPmemData();
            result[i].vmRef = vmRef;
            result[i].name = vmNames.get(vmRef);
            ++i;
        }
        return result;
    }

    private static void retrieveVmNamesAndDevices(Constraint vmConstraint, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, Map<ManagedObjectReference, String> vmNames, Map<ManagedObjectReference, VirtualDevice[]> vmDevices) throws Exception {
        QuerySpec vmDataSpec = querySpecBuilder.buildQuerySpec(vmConstraint, new String[]{VM_NAME, VM_DEVICES_PROPERTY});
        ResultSet vmDataResultSet = queryExecutor.getData(vmDataSpec);
        if (vmDataResultSet == null || vmDataResultSet.items == null) {
            return;
        }
        for (ResultItem resultItem : vmDataResultSet.items) {
            ManagedObjectReference vmRef = (ManagedObjectReference)resultItem.resourceObject;
            if (resultItem.properties == null) continue;
            for (PropertyValue propValue : resultItem.properties) {
                if (VM_NAME.equals(propValue.propertyName)) {
                    vmNames.put(vmRef, (String)propValue.value);
                    continue;
                }
                if (!VM_DEVICES_PROPERTY.equals(propValue.propertyName)) continue;
                vmDevices.put(vmRef, (VirtualDevice[])propValue.value);
            }
        }
    }

    private static boolean containNvDimmDevice(VirtualDevice[] vmDevices) {
        if (vmDevices == null) {
            return false;
        }
        for (VirtualDevice device : vmDevices) {
            if (!(device instanceof VirtualNVDIMM)) continue;
            return true;
        }
        return false;
    }

    private static Set<ManagedObjectReference> getDatastoresForVmDisks(VirtualDevice[] vmDevices) {
        HashSet<ManagedObjectReference> result = new HashSet<ManagedObjectReference>();
        if (vmDevices == null) {
            return result;
        }
        for (VirtualDevice device : vmDevices) {
            if (!(device instanceof VirtualDisk)) continue;
            VirtualDisk virtualDisk = (VirtualDisk)device;
            if (virtualDisk.backing == null || !(virtualDisk.backing instanceof VirtualDevice.FileBackingInfo)) continue;
            VirtualDevice.FileBackingInfo diskBackingInfo = (VirtualDevice.FileBackingInfo)virtualDisk.backing;
            if (diskBackingInfo.datastore == null) continue;
            result.add(diskBackingInfo.datastore);
        }
        return result;
    }

    private static List<ManagedObjectReference> filterPMemDatastores(Object[] datastoreRefs, QueryExecutor queryExecutor) throws Exception {
        ArrayList<ManagedObjectReference> pmemDatastores = new ArrayList<ManagedObjectReference>();
        if (datastoreRefs == null || datastoreRefs.length == 0) {
            return pmemDatastores;
        }
        PropertyValue[] datastoreProperties = queryExecutor.getProperty(datastoreRefs, DATASTORE_TYPE_PROPERTY);
        if (datastoreProperties == null) {
            return pmemDatastores;
        }
        for (PropertyValue propValue : datastoreProperties) {
            if (!DATASTORE_TYPE_PROPERTY.equals(propValue.propertyName) || !PMEM_DS_TYPE.equalsIgnoreCase((String)propValue.value)) continue;
            pmemDatastores.add((ManagedObjectReference)propValue.resourceObject);
        }
        return pmemDatastores;
    }
}

