/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.storageDrs.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.vm.RelocateSpec;
import com.vmware.vim.binding.vim.vm.check.Result;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.vm.migration.impl.DiskLocationInfo;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.ArrayList;

public class StorageValidationUtil {
    private static int VMX_DISK_ID = -1;

    public static Result checkForDisabledStoragePods(RelocateSpec spec, DiskLocationInfo newDiskLocation) {
        ArrayList<ManagedObjectReference> podsToDisableDrs = StorageValidationUtil.collectPodToDisableDrs(spec, newDiskLocation);
        if (podsToDisableDrs.isEmpty()) {
            return null;
        }
        ArrayList<MethodFault> faults = new ArrayList<MethodFault>();
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.datastore, StoragePod.class) && podsToDisableDrs.contains(spec.datastore)) {
            faults.add(StorageValidationUtil.newMethodFault(Util.getLocalizedString("error.vmStorageShouldBeDatastore")));
        }
        if (spec.disk != null) {
            for (RelocateSpec.DiskLocator disk : spec.disk) {
                if (!ManagedObjectUtil.isOfType((ManagedObjectReference)disk.datastore, StoragePod.class) || !podsToDisableDrs.contains(disk.datastore)) continue;
                String diskName = newDiskLocation.diskNameByDiskId.get(disk.diskId);
                faults.add(StorageValidationUtil.newMethodFault(String.format(Util.getLocalizedString("error.diskStorageShouldBeDatastore"), diskName)));
            }
        }
        Result retVal = StorageValidationUtil.newResult(faults, newDiskLocation.vm, spec.host);
        return retVal;
    }

    private static ArrayList<ManagedObjectReference> collectPodToDisableDrs(RelocateSpec spec, DiskLocationInfo newDiskLocation) {
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        ManagedObjectReference storagePod = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.datastore, Datastore.class)) {
            boolean drsEnabled;
            Boolean value = newDiskLocation.drsEnabledByDiskId.get(VMX_DISK_ID);
            boolean bl = drsEnabled = value == true;
            if (drsEnabled) {
                storagePod = newDiskLocation.storagePodByDiskId.get(VMX_DISK_ID);
                result.add(storagePod);
            }
        }
        if (spec.disk == null) {
            return result;
        }
        for (RelocateSpec.DiskLocator disk : spec.disk) {
            boolean drsEnabled;
            if (!ManagedObjectUtil.isOfType((ManagedObjectReference)disk.datastore, Datastore.class)) continue;
            Boolean value = newDiskLocation.drsEnabledByDiskId.get(disk.diskId);
            boolean bl = drsEnabled = value == true;
            if (!drsEnabled) continue;
            storagePod = newDiskLocation.storagePodByDiskId.get(disk.diskId);
            result.add(storagePod);
        }
        return result;
    }

    public static Result checkStorageIsDifferent(RelocateSpec spec, DiskLocationInfo currentLocation, boolean podsOnly) {
        ArrayList<MethodFault> faults = new ArrayList<MethodFault>();
        StorageValidationUtil.checkStorageIsDifferent(spec, currentLocation, faults, podsOnly);
        Result retVal = StorageValidationUtil.newResult(faults, currentLocation.vm, spec.host);
        return retVal;
    }

    private static void checkStorageIsDifferent(RelocateSpec destinationSpec, DiskLocationInfo currentLocation, ArrayList<MethodFault> faults, boolean podsOnly) {
        ManagedObjectReference newStorage = null;
        boolean isStoragePod = false;
        newStorage = destinationSpec.datastore;
        if (!StorageValidationUtil.isDiskLocationChanged(VMX_DISK_ID, newStorage, currentLocation).booleanValue()) {
            String key;
            isStoragePod = ManagedObjectUtil.isOfType((ManagedObjectReference)newStorage, StoragePod.class);
            String string = key = isStoragePod ? "error.vmStoragePodNotChanged" : "error.vmStorageNotChanged";
            if (!podsOnly || podsOnly && isStoragePod) {
                faults.add(StorageValidationUtil.newMethodFault(Util.getLocalizedString(key)));
            }
        }
        if (destinationSpec.disk == null) {
            return;
        }
        for (RelocateSpec.DiskLocator disk : destinationSpec.disk) {
            String key;
            newStorage = disk.datastore;
            if (StorageValidationUtil.isDiskLocationChanged(disk.diskId, newStorage, currentLocation).booleanValue()) continue;
            String diskName = currentLocation.diskNameByDiskId.get(disk.diskId);
            isStoragePod = ManagedObjectUtil.isOfType((ManagedObjectReference)newStorage, StoragePod.class);
            String string = key = isStoragePod ? "error.diskStoragePodNotChanged" : "error.diskStorageNotChanged";
            if (podsOnly && (!podsOnly || !isStoragePod)) continue;
            faults.add(StorageValidationUtil.newMethodFault(String.format(Util.getLocalizedString(key), diskName)));
        }
    }

    private static MethodFault newMethodFault(String message) {
        MethodFault methodFault = new MethodFault();
        methodFault.setMessage(message);
        return methodFault;
    }

    private static Result newResult(ArrayList<MethodFault> faults, ManagedObjectReference vm, ManagedObjectReference host) {
        if (faults == null || faults.isEmpty()) {
            return null;
        }
        MethodFault[] faultsArray = (MethodFault[])ArrayUtil.toArray(faults, MethodFault.class);
        Result retVal = new Result();
        retVal.vm = vm;
        retVal.host = host;
        retVal.error = faultsArray;
        return retVal;
    }

    public static Boolean isStorageSpecified(RelocateSpec spec) {
        if (spec.datastore != null) {
            return true;
        }
        if (spec.disk != null) {
            for (RelocateSpec.DiskLocator disk : spec.disk) {
                if (disk.datastore == null) continue;
                return true;
            }
        }
        return false;
    }

    public static Boolean isDiskLocationChanged(int diskId, ManagedObjectReference newStorage, DiskLocationInfo currentLocation) {
        ManagedObjectReference oldStorage = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)newStorage, Datastore.class)) {
            oldStorage = currentLocation.datastoreByDiskId.get(diskId);
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)newStorage, StoragePod.class)) {
            oldStorage = currentLocation.storagePodByDiskId.get(diskId);
        }
        Boolean unchaged = ManagedObjectUtil.areEqual((ManagedObjectReference)newStorage, (ManagedObjectReference)oldStorage);
        return unchaged == false;
    }
}

