/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.srs.impl;

import com.vmware.opsmgmt.client.srs.impl.SrsPingTask;
import com.vmware.opsmgmt.client.srs.impl.SrsServiceDescriptor;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SrsConnectionManager
implements UserSessionListener {
    private static final Log _logger = LogFactory.getLog(SrsConnectionManager.class);
    private static final String KEEP_ALIVE_PERIOD_KEY = "performance.charts.keep.alive.period";
    private static final int KEEP_ALIVE_PERIOD_MIN = 180;
    private final ComponentManagerService _cmService;
    private final ScheduledExecutorService _scheduler;
    private final KeystoreService _keystoreService;
    private final ConfigurationService _configService;
    private final SSLConfigurationProvider _sslConfigProvider;
    private final int _pingTimeout;
    private final long _keepAlivePeriod;
    private final Collection<SrsPingTask> _tasks;

    public SrsConnectionManager(ComponentManagerService componentManagerService, KeystoreService keystoreService, ConfigurationService configurationService, SSLConfigurationProvider sSLConfigurationProvider, ScheduledExecutorService scheduledExecutorService, int n) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{componentManagerService, scheduledExecutorService, keystoreService, sSLConfigurationProvider});
        this._cmService = componentManagerService;
        this._keystoreService = keystoreService;
        this._configService = configurationService;
        this._sslConfigProvider = sSLConfigurationProvider;
        this._scheduler = scheduledExecutorService;
        this._pingTimeout = n;
        this._keepAlivePeriod = this.getKeepAlivePeriod();
        this._tasks = new HashSet<SrsPingTask>();
        SrsConnectionManager.debugLog("Initialized; keepAlivePeriod=%ss; pingTimeout=%sms.", this._keepAlivePeriod, this._pingTimeout);
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        if (!this.keepAliveEnabled()) {
            _logger.info((Object)"Invalid keep alive period; keep alive is disabled.");
            return;
        }
        HttpSession httpSession = httpSessionEvent.getSession();
        this.login(httpSession, this.lookupServices());
        SrsConnectionManager.debugLog("Session started; sessionId=%s.", SessionUtil.getHashedSessionId((HttpSession)httpSession));
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        HttpSession httpSession = httpSessionEvent.getSession();
        this.logout(httpSession);
        SrsConnectionManager.debugLog("Session ended; hashedSessionId=%s.", SessionUtil.getHashedSessionId((HttpSession)httpSession));
    }

    public void destroy() throws Exception {
        this._scheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SrsServiceDescriptor> lookupServices() {
        ServiceInfo[] serviceInfoArray = null;
        long l = System.currentTimeMillis();
        try {
            serviceInfoArray = this._cmService.search((SearchCriteria)new SearchCriteriaImpl((ServiceType)new ServiceTypeImpl("com.vmware.cis", "cs.perfcharts"), null, (ServiceEndPointType)new ServiceEndPointTypeImpl("http", "com.vmware.perfcharts.entry.url"), null, null));
        }
        catch (ComponentManagerFault componentManagerFault) {
            try {
                _logger.error((Object)"CM search failed.", (Throwable)componentManagerFault);
            }
            catch (Throwable throwable) {
                SrsConnectionManager.debugLog("CM search complete in %sms.", System.currentTimeMillis() - l);
                throw throwable;
            }
            SrsConnectionManager.debugLog("CM search complete in %sms.", System.currentTimeMillis() - l);
        }
        SrsConnectionManager.debugLog("CM search complete in %sms.", System.currentTimeMillis() - l);
        if (serviceInfoArray == null) {
            SrsConnectionManager.debugLog("CM search did not return a result.", new Object[0]);
            return Collections.emptyList();
        }
        ArrayList<SrsServiceDescriptor> arrayList = new ArrayList<SrsServiceDescriptor>();
        for (ServiceInfo serviceInfo : serviceInfoArray) {
            if (!"1.1".equals(serviceInfo.getServiceVersion())) continue;
            String string = serviceInfo.getServiceId();
            for (ServiceEndPoint serviceEndPoint : serviceInfo.getServiceEndPoints()) {
                String string2 = serviceEndPoint.getEndPointType().getTypeId();
                if (!"com.vmware.perfcharts.entry.url".equals(string2)) continue;
                arrayList.add(SrsServiceDescriptor.newInstance(string, serviceEndPoint));
                SrsConnectionManager.debugLog("Service found; id=%s.", string);
            }
        }
        SrsConnectionManager.debugLog("%s services total.", arrayList.size());
        return Collections.unmodifiableCollection(arrayList);
    }

    private synchronized void login(HttpSession httpSession, Collection<SrsServiceDescriptor> collection) {
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        for (SrsServiceDescriptor srsServiceDescriptor : collection) {
            this.scheduleTask(string, srsServiceDescriptor);
        }
        SrsConnectionManager.debugLog("Login; %s running tasks.", this._tasks.size());
    }

    private synchronized void logout(HttpSession httpSession) {
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        ArrayList<SrsPingTask> arrayList = new ArrayList<SrsPingTask>();
        for (SrsPingTask srsPingTask : this._tasks) {
            if (!string.equals(srsPingTask.getClientId())) continue;
            arrayList.add(srsPingTask);
        }
        for (SrsPingTask srsPingTask : arrayList) {
            this.cancelTask(srsPingTask);
        }
        SrsConnectionManager.debugLog("Logout; %s running tasks.", this._tasks.size());
    }

    private void scheduleTask(String string, SrsServiceDescriptor srsServiceDescriptor) {
        try {
            SrsPingTask srsPingTask = SrsPingTask.newInstance(srsServiceDescriptor, string, this._pingTimeout, this._keystoreService, this._sslConfigProvider);
            srsPingTask.setHandle(this._scheduler.scheduleAtFixedRate(srsPingTask, 0L, this._keepAlivePeriod, TimeUnit.SECONDS));
            this._tasks.add(srsPingTask);
        }
        catch (Exception exception) {
            _logger.error((Object)"Task creation failed.", (Throwable)exception);
        }
    }

    private void cancelTask(SrsPingTask srsPingTask) {
        boolean bl = srsPingTask.cancel();
        this._tasks.remove(srsPingTask);
        SrsConnectionManager.debugLog("Task cancelled; hashedClientId=%s; serviceId=%s; success=%s.", SessionUtil.getHashedClientId((String)srsPingTask.getClientId()), srsPingTask.getServiceId(), bl);
    }

    private long getKeepAlivePeriod() {
        try {
            return Long.parseLong(this._configService.getProperty(KEEP_ALIVE_PERIOD_KEY));
        }
        catch (NumberFormatException numberFormatException) {
            _logger.warn((Object)String.format("Unable to parse '%s' property; keep alive is disabled.", KEEP_ALIVE_PERIOD_KEY));
            return 0L;
        }
    }

    private boolean keepAliveEnabled() {
        return this._keepAlivePeriod >= 180L;
    }

    private static void debugLog(String string, Object ... objectArray) {
        if (!_logger.isDebugEnabled()) {
            return;
        }
        _logger.debug((Object)String.format(string, objectArray));
    }
}

