/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons;

import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.I18nUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.util.VmodlUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedObjectUtil {
    @Deprecated
    public static final String MOREF_UID_PREFIX = "urn:vmomi";
    public static final ManagedObjectReference[] EMPTY_MANAGED_OBJECT_ARR = new ManagedObjectReference[0];
    private static volatile String _defaultNamespace = null;
    private static final Log _logger = LogFactory.getLog(ManagedObjectUtil.class);
    private static final String VM_FOLDER_VALUE = "group-v";
    private static final String NETWORK_FOLDER_VALUE = "group-n";
    private static final String HOST_FOLDER_VALUE = "group-h";
    private static final String DATASTORE_FOLDER_VALUE = "group-s";
    private static final String DATACENTER_FOLDER_VALUE = "group-d";
    private static final String VC_CLIENT_FOLDER_ROOT_NAME = "group-d1";

    public static synchronized void setDefaultNamespace(String string) {
        if (_defaultNamespace != null) {
            throw new IllegalStateException("Default Namespace has already been set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Param defaultNamespace cannot be null.");
        }
        _defaultNamespace = string;
    }

    public static boolean isDefaultNamespace(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(_defaultNamespace);
    }

    public static <Type extends ManagedObject> Type getManagedObject(ManagedObjectReference managedObjectReference) throws Exception {
        return ManagedObjectUtil.getManagedObject(managedObjectReference, null);
    }

    public static <Type extends ManagedObject> Type getManagedObject(ManagedObjectReference managedObjectReference, HttpSession httpSession) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{managedObjectReference});
        if (httpSession == null && (httpSession = SessionUtil.getHttpSession((boolean)false)) == null) {
            throw new IllegalStateException("Session is null");
        }
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        if (string == null) {
            throw new IllegalStateException("ClientId is null");
        }
        return ManagedObjectUtil.getManagedObjectByClientId(managedObjectReference, string);
    }

    public static <Type extends ManagedObject> Type getManagedObjectByClientId(ManagedObjectReference managedObjectReference, String string) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{managedObjectReference});
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistryByClientId(string);
        if (linkedVcGroupRegistry == null) {
            throw new IllegalStateException("null registry");
        }
        LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(managedObjectReference.getServerGuid());
        if (linkedVcGroup == null) {
            throw new IllegalStateException(String.format(I18nUtil.getLocalizedString("error.invalidLinkedGroup", new String[0]), ManagedObjectUtil.morefToString(managedObjectReference)));
        }
        ManagedObject managedObject = linkedVcGroup.getManagedObject(managedObjectReference);
        if (managedObject == null) {
            throw new IllegalStateException(String.format(I18nUtil.getLocalizedString("error.invalidEntity", new String[0]), ManagedObjectUtil.morefToString(managedObjectReference)));
        }
        return (Type)managedObject;
    }

    public static String morefToString(ManagedObjectReference managedObjectReference) {
        if (managedObjectReference == null) {
            return "";
        }
        return VmodlUtil.morefToString((String)managedObjectReference.getType(), (String)managedObjectReference.getValue(), (String)managedObjectReference.getServerGuid());
    }

    public static ManagedObjectReference stringToMoref(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("urn:vmomi:")) {
            return null;
        }
        String string2 = string.substring(MOREF_UID_PREFIX.length() + 1);
        Pair pair = StringUtil.removeLastWord((String)string2, (char)':');
        if (pair == null) {
            return null;
        }
        String string3 = (String)pair.second;
        if (string3 != null && string3.isEmpty()) {
            string3 = null;
        }
        if ((pair = StringUtil.removeLastWord((String)(string2 = (String)pair.first), (char)':')) == null) {
            return null;
        }
        String string4 = (String)pair.second;
        if (string4 != null && string4.isEmpty()) {
            string4 = null;
        }
        String string5 = (String)pair.first;
        ManagedObjectReference managedObjectReference = new ManagedObjectReference(string5, string4, string3);
        return managedObjectReference;
    }

    public static ManagedObjectReference deepCopy(ManagedObjectReference managedObjectReference) {
        if (managedObjectReference == null) {
            return null;
        }
        return new ManagedObjectReference(managedObjectReference.getType(), managedObjectReference.getValue(), managedObjectReference.getServerGuid());
    }

    public static ManagedObjectNotFound newObjectNotFoundFault(Object[] objectArray) {
        for (Object object : objectArray) {
            _logger.error((Object)String.format("The following object cannot be found: %s", object.toString()));
        }
        Object object = objectArray[0];
        ManagedObjectNotFound managedObjectNotFound = null;
        managedObjectNotFound = object instanceof ManagedObjectReference ? new ManagedObjectNotFound((ManagedObjectReference)object) : new ManagedObjectNotFound();
        managedObjectNotFound.setMessage(I18nUtil.getLocalizedString("error.objectNotFound", object.toString()));
        return managedObjectNotFound;
    }

    public static Class<?> getType(ManagedObjectReference managedObjectReference) {
        return VmodlUtil.getType((ManagedObjectReference)managedObjectReference);
    }

    public static Class<?> getType(String string) {
        return VmodlUtil.getType((String)string);
    }

    public static boolean isOfType(ManagedObjectReference managedObjectReference, String string) {
        if (managedObjectReference == null || StringUtil.isNullOrEmpty((String)string)) {
            return false;
        }
        String string2 = managedObjectReference.getType();
        return string.equalsIgnoreCase(string2);
    }

    public static boolean isOfType(ManagedObjectReference managedObjectReference, Class<?> clazz) {
        if (managedObjectReference == null || clazz == null) {
            return false;
        }
        String string = clazz.getSimpleName();
        return string.equalsIgnoreCase(managedObjectReference.getType());
    }

    public static boolean isRootFolder(ManagedObjectReference managedObjectReference) {
        return ManagedObjectUtil.isOfType(managedObjectReference, Folder.class.getAnnotation(wsdlName.class).value()) && managedObjectReference.getValue().equals(VC_CLIENT_FOLDER_ROOT_NAME);
    }

    public static ManagedObjectReference getRootFolder(String string) {
        ManagedObjectReference managedObjectReference = new ManagedObjectReference(Folder.class.getAnnotation(wsdlName.class).value(), VC_CLIENT_FOLDER_ROOT_NAME, string);
        return managedObjectReference;
    }

    public static boolean isNetworkFolder(ManagedObjectReference managedObjectReference) {
        return ManagedObjectUtil.isOfType(managedObjectReference, Folder.class.getAnnotation(wsdlName.class).value()) && managedObjectReference.getValue().contains(NETWORK_FOLDER_VALUE);
    }

    public static boolean isHostFolder(ManagedObjectReference managedObjectReference) {
        return ManagedObjectUtil.isOfType(managedObjectReference, Folder.class.getAnnotation(wsdlName.class).value()) && managedObjectReference.getValue().contains(HOST_FOLDER_VALUE);
    }

    public static boolean isStorageFolder(ManagedObjectReference managedObjectReference) {
        return ManagedObjectUtil.isOfType(managedObjectReference, Folder.class.getAnnotation(wsdlName.class).value()) && managedObjectReference.getValue().contains(DATASTORE_FOLDER_VALUE);
    }

    public static boolean isDatacenterFolder(ManagedObjectReference managedObjectReference) {
        return ManagedObjectUtil.isOfType(managedObjectReference, Folder.class.getAnnotation(wsdlName.class).value()) && managedObjectReference.getValue().contains(DATACENTER_FOLDER_VALUE);
    }

    public static boolean isVmFolder(ManagedObjectReference managedObjectReference) {
        return ManagedObjectUtil.isOfType(managedObjectReference, Folder.class.getAnnotation(wsdlName.class).value()) && managedObjectReference.getValue().contains(VM_FOLDER_VALUE);
    }

    public static Boolean areEqual(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) {
        if (managedObjectReference == null || managedObjectReference2 == null) {
            return false;
        }
        return ManagedObjectUtil.isMorPropertyEqual(managedObjectReference.getValue(), managedObjectReference2.getValue()) != false && ManagedObjectUtil.isMorPropertyEqual(managedObjectReference.getType(), managedObjectReference2.getType()) != false && ManagedObjectUtil.isMorPropertyEqual(managedObjectReference.getServerGuid(), managedObjectReference2.getServerGuid()) != false;
    }

    private static Boolean isMorPropertyEqual(String string, String string2) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return StringUtil.isNullOrEmpty((String)string2);
        }
        return string.equals(string2);
    }

    public static String getLocalizedEntityType(String string) {
        String string2 = string;
        string2 = string.equals("ClusterComputeResource") ? I18nUtil.getLocalizedString("Cluster.text", new String[0]) : (string.equals("ComputeResource") ? I18nUtil.getLocalizedString("Host.text", new String[0]) : I18nUtil.getLocalizedString(String.format("%s.text", string), new String[0]));
        return string2;
    }
}

