/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.mks.tomcat;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.io.StreamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.WsOutbound;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteConsoleMessageInbound
extends MessageInbound {
    private static final Log _logger = LogFactory.getLog(RemoteConsoleMessageInbound.class);
    private static final long END_OF_FILE_WAIT_INTERVAL_MILLIS = 100L;
    private final AtomicBoolean _wasOpened = new AtomicBoolean(false);
    private volatile WsOutbound _clientOutboundRef;
    private final Socket _socket;
    private final Executor _executor;
    private final int _bufferSize;

    public RemoteConsoleMessageInbound(Socket socket, Executor executor, int n) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{socket});
        this._socket = socket;
        this._executor = executor;
        this._bufferSize = n;
    }

    public void onOpen(WsOutbound wsOutbound) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{wsOutbound});
        boolean bl = this._wasOpened.getAndSet(true);
        if (bl) {
            throw new IllegalStateException("This instance was already opened.");
        }
        _logger.info((Object)"Opened Remote Console Client.");
        this._clientOutboundRef = wsOutbound;
        this._executor.execute(new Relay());
    }

    public void onClose(int n) {
        _logger.info((Object)String.format("WebSocket session is being closed (%d)", n));
        try {
            _logger.info((Object)"Closing the socket");
            this._socket.close();
        }
        catch (IOException iOException) {
            _logger.error((Object)"An error occurred while closing the socket ", (Throwable)iOException);
        }
        if (!this._socket.isClosed()) {
            _logger.error((Object)"An issue occurred while trying to close the socket, the socket has not been closed.");
        }
    }

    public void onTextMessage(CharBuffer charBuffer) throws IOException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{charBuffer});
        String string = charBuffer.toString();
        this._socket.getOutputStream().write(string.getBytes());
        this._socket.getOutputStream().flush();
    }

    public void onBinaryMessage(ByteBuffer byteBuffer) throws IOException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{byteBuffer});
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        try {
            this._socket.getOutputStream().write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            _logger.error((Object)"Error writing to the socket", (Throwable)iOException);
            WsOutbound wsOutbound = this._clientOutboundRef;
            this._clientOutboundRef = null;
            RemoteConsoleMessageInbound.closeClientOutBound(wsOutbound);
        }
    }

    private static void closeClientOutBound(WsOutbound wsOutbound) {
        if (wsOutbound == null) {
            return;
        }
        try {
            wsOutbound.close(0, null);
            _logger.info((Object)"connection has been closed. ");
        }
        catch (IOException iOException) {
            _logger.error((Object)"Error closing connection. ", (Throwable)iOException);
        }
    }

    private class Relay
    implements Runnable {
        private Relay() {
        }

        @Override
        public void run() {
            this.runSocket();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runSocket() {
            InputStream inputStream;
            try {
                inputStream = RemoteConsoleMessageInbound.this._socket.getInputStream();
            }
            catch (IOException iOException) {
                _logger.error((Object)"Error getting an input stream from the socket: ", (Throwable)iOException);
                return;
            }
            try {
                byte[] byArray = new byte[RemoteConsoleMessageInbound.this._bufferSize];
                this.runLoop(byArray, inputStream);
            }
            catch (SocketException socketException) {
                _logger.info((Object)("The socket was closed. Stopping the remote console thread.SocketException code (expected, not an error): " + socketException));
            }
            catch (IOException iOException) {
                _logger.error((Object)"An error occurred while reading from the socket to the outbound", (Throwable)iOException);
            }
            finally {
                StreamUtil.close((Closeable)inputStream);
            }
        }

        private void runLoop(byte[] byArray, InputStream inputStream) throws IOException {
            int n = 0;
            WsOutbound wsOutbound = RemoteConsoleMessageInbound.this._clientOutboundRef;
            while (wsOutbound != null) {
                while ((n = inputStream.read(byArray)) > 0) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n);
                    try {
                        wsOutbound.writeBinaryMessage(byteBuffer);
                    }
                    catch (IOException iOException) {
                        RemoteConsoleMessageInbound.closeClientOutBound(wsOutbound);
                        throw iOException;
                    }
                }
                _logger.info((Object)"Encountered EOF character, sleeping for 100 ms.");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                wsOutbound = RemoteConsoleMessageInbound.this._clientOutboundRef;
            }
        }
    }
}

