/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.mks.util;

import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SslThumbprintVerifier
implements ThumbprintVerifier {
    private static final Log _logger = LogFactory.getLog(SslThumbprintVerifier.class);
    private String[] _thumbprints;

    public String getThumbprint() {
        if (this._thumbprints == null || this._thumbprints.length != 1) {
            return null;
        }
        return this._thumbprints[0];
    }

    public void setThumbprint(String string) {
        this._thumbprints = new String[]{string};
    }

    public String[] getThumbprints() {
        return this._thumbprints;
    }

    public void setThumbprints(String[] stringArray) {
        this._thumbprints = stringArray;
    }

    public ThumbprintVerifier.Result verify(String string) {
        _logger.debug((Object)("Verifying the ssl certificate: " + string));
        if (this._thumbprints != null) {
            for (String string2 : this._thumbprints) {
                if (!string2.equals(string)) continue;
                return ThumbprintVerifier.Result.MATCH;
            }
        }
        return ThumbprintVerifier.Result.MISMATCH;
    }

    public void onSuccess(X509Certificate[] x509CertificateArray, String string, ThumbprintVerifier.Result result, boolean bl, boolean bl2) throws SSLException {
        if (string == null || string.equals("")) {
            return;
        }
        _logger.debug((Object)("Ssl certificate is verified successfully: " + string));
    }
}

