/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vcservice;

import com.google.common.base.Preconditions;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.I18nUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityResult;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class LinkedVcGroupCompatibilityResult {
    protected final LinkedVcGroup _linkedVcGroup;

    private LinkedVcGroupCompatibilityResult(@Nonnull LinkedVcGroup linkedVcGroup) {
        Preconditions.checkArgument((linkedVcGroup != null ? 1 : 0) != 0, (Object)"linkedVcGroup is null");
        this._linkedVcGroup = linkedVcGroup;
    }

    public static LinkedVcGroupCompatibilityResult createCompatibleResult(@Nonnull LinkedVcGroup linkedVcGroup) {
        return new Compatible(linkedVcGroup);
    }

    public static LinkedVcGroupCompatibilityResult createIncompatibleResult(@Nonnull LinkedVcGroup linkedVcGroup, @Nonnull LinkedVcGroupCompatibilityFailure linkedVcGroupCompatibilityFailure, @Nonnull Collection<VcServiceCompatibilityResult> collection, @Nullable String string) {
        Preconditions.checkArgument((linkedVcGroupCompatibilityFailure != null ? 1 : 0) != 0, (Object)"compatibilityFailure is null");
        Preconditions.checkArgument((collection != null ? 1 : 0) != 0, (Object)"incompatibles is null");
        return new Incompatible(linkedVcGroup, linkedVcGroupCompatibilityFailure, collection, string);
    }

    public LinkedVcGroup getLinkedVcGroup() {
        return this._linkedVcGroup;
    }

    public abstract boolean isCompatible();

    @Nullable
    public abstract LinkedVcGroupCompatibilityFailure getFailure();

    @Nonnull
    public abstract Collection<VcServiceCompatibilityResult> getIncompatibles();

    @Nullable
    public abstract String getLocalizedErrorMessage();

    /*
     * WARNING - void declaration
     */
    @Nullable
    static String getLocalizedErrorMessage(@Nonnull LinkedVcGroup linkedVcGroup, @Nullable Collection<VcServiceCompatibilityResult> collection, @Nullable String string) {
        void var5_8;
        ServiceEndpointEx[] serviceEndpointExArray;
        Preconditions.checkArgument((linkedVcGroup != null ? 1 : 0) != 0, (Object)"linkedVcGroup is null");
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        int n = 0;
        for (ServiceEndpointEx serviceEndpointEx : serviceEndpointExArray = linkedVcGroup.getServiceEndPoints()) {
            if (serviceEndpointEx == null || serviceEndpointEx.getServiceEndpointType() != ServiceEndpointType.VC) continue;
            ++n;
        }
        if (n - collection.size() > 0) {
            LinkedVcGroupCompatibilityFailure linkedVcGroupCompatibilityFailure = LinkedVcGroupCompatibilityFailure.SOME_UNSUPPORTED_VCS;
        } else {
            LinkedVcGroupCompatibilityFailure linkedVcGroupCompatibilityFailure = LinkedVcGroupCompatibilityFailure.ALL_VCS_UNSUPPORTED;
        }
        return LinkedVcGroupCompatibilityResult.getLocalizedErrorMessage((LinkedVcGroupCompatibilityFailure)var5_8, collection, string);
    }

    @Nullable
    static String getLocalizedErrorMessage(@Nullable LinkedVcGroupCompatibilityFailure linkedVcGroupCompatibilityFailure, @Nullable Collection<VcServiceCompatibilityResult> collection, @Nullable String string) {
        Object object;
        if (linkedVcGroupCompatibilityFailure == null || collection == null) {
            return null;
        }
        int n = collection.size();
        if (n == 0) {
            return null;
        }
        Iterator<VcServiceCompatibilityResult> iterator = collection.iterator();
        if (n == 1) {
            VcServiceCompatibilityResult vcServiceCompatibilityResult = iterator.next();
            String string2 = vcServiceCompatibilityResult.getLocalizedErrorMessage();
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(300);
        while (iterator.hasNext()) {
            object = iterator.next();
            String string3 = ((VcServiceCompatibilityResult)object).getLocalizedErrorMessage();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string3);
        }
        if (StringUtil.isNullOrWhitespace((String)string)) {
            string = "";
        }
        object = linkedVcGroupCompatibilityFailure == LinkedVcGroupCompatibilityFailure.ALL_VCS_UNSUPPORTED ? I18nUtil.getLocalizedString("linkedVcGroup.allVcsInLinkedVcGroupAreIncompatible", new String[0]) : I18nUtil.getLocalizedString("linkedVcGroup.linkedVcGroupContainsIncompatibleVCs", new String[0]);
        object = String.format((String)object, MixedUtil.CLIENT_NAME, string, stringBuilder.toString());
        return object;
    }

    private static class Incompatible
    extends LinkedVcGroupCompatibilityResult {
        private final LinkedVcGroupCompatibilityFailure _compatibilityFailure;
        private final List<VcServiceCompatibilityResult> _incompatibles;
        private final String _vSphereClientVersion;

        private Incompatible(@Nonnull LinkedVcGroup linkedVcGroup, @Nonnull LinkedVcGroupCompatibilityFailure linkedVcGroupCompatibilityFailure, @Nonnull Collection<VcServiceCompatibilityResult> collection, @Nullable String string) {
            super(linkedVcGroup);
            Preconditions.checkArgument((linkedVcGroupCompatibilityFailure != null ? 1 : 0) != 0, (Object)"compatibilityFailure is null");
            Preconditions.checkArgument((collection != null ? 1 : 0) != 0, (Object)"incompatibles is null");
            Preconditions.checkArgument((collection.size() > 0 ? 1 : 0) != 0, (Object)"incompatibles is empty");
            this._compatibilityFailure = linkedVcGroupCompatibilityFailure;
            this._incompatibles = Collections.emptyList();
            this._vSphereClientVersion = string;
        }

        @Override
        public boolean isCompatible() {
            return false;
        }

        @Override
        @Nullable
        public LinkedVcGroupCompatibilityFailure getFailure() {
            return this._compatibilityFailure;
        }

        @Override
        @Nonnull
        public Collection<VcServiceCompatibilityResult> getIncompatibles() {
            return this._incompatibles;
        }

        @Override
        @Nullable
        public String getLocalizedErrorMessage() {
            return Incompatible.getLocalizedErrorMessage(this._compatibilityFailure, this._incompatibles, this._vSphereClientVersion);
        }
    }

    private static class Compatible
    extends LinkedVcGroupCompatibilityResult {
        public Compatible(@Nonnull LinkedVcGroup linkedVcGroup) {
            super(linkedVcGroup);
        }

        @Override
        public boolean isCompatible() {
            return true;
        }

        @Override
        @Nullable
        public LinkedVcGroupCompatibilityFailure getFailure() {
            return null;
        }

        @Override
        @Nonnull
        public Collection<VcServiceCompatibilityResult> getIncompatibles() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public String getLocalizedErrorMessage() {
            return null;
        }
    }

    public static enum LinkedVcGroupCompatibilityFailure {
        SOME_UNSUPPORTED_VCS,
        ALL_VCS_UNSUPPORTED;

    }
}

