/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vmomi.request;

import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vmomi.request.ManagedObjectContextHandler;

public class SessionManagerContextHandler
implements ManagedObjectContextHandler {
    private final LoginSpec _loginSpec;
    private static final String SESSION_MANAGER_MO_TYPE = "SessionManager";
    private static final String LOGIN_BY_TOKEN_METHOD_NAME = "loginByToken";

    public SessionManagerContextHandler(LoginSpec loginSpec) {
        this._loginSpec = loginSpec;
    }

    @Override
    public void handle(RequestContextImpl requestContextImpl, InvocationContext invocationContext) {
        String string = invocationContext.getMoRef().getType();
        if (!SESSION_MANAGER_MO_TYPE.equals(string)) {
            return;
        }
        String string2 = invocationContext.getMethod().getName();
        if (!LOGIN_BY_TOKEN_METHOD_NAME.equals(string2)) {
            return;
        }
        SamlToken samlToken = AuthSessionUtil.getSsoToken();
        if (samlToken == null) {
            samlToken = this._loginSpec.token;
        }
        requestContextImpl.setSignInfo((SignInfo)new SignInfoImpl(this._loginSpec.privateKey, samlToken));
    }
}

