/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vmomi.response;

import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.OpIdUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.reflection.ReflectionUtil;
import com.vmware.vise.vim.commons.vsphere.internal.Config;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;

public class ResultInterceptorImpl
implements ResultInterceptor {
    private static final Log _opIdLogger = LogUtil.getOpIdLogger();
    @Nullable
    private final AtomicReference<String> _serviceDetails;

    public ResultInterceptorImpl() {
        this(null);
    }

    public ResultInterceptorImpl(AtomicReference<String> atomicReference) {
        this._serviceDetails = atomicReference;
    }

    public Object handleReturnVal(Object object, InvocationContext invocationContext) {
        this.logInvocationCompletion(invocationContext, null);
        return object;
    }

    public Exception handleSoapFault(Exception exception, InvocationContext invocationContext) {
        this.logInvocationCompletion(invocationContext, exception);
        return exception;
    }

    public Exception handleException(Exception exception, InvocationContext invocationContext) {
        this.logInvocationCompletion(invocationContext, exception);
        return exception;
    }

    private static Object getOpId(InvocationContext invocationContext) {
        Object object = invocationContext.getInvocationContextObject("operationID");
        return object;
    }

    private void logInvocationCompletion(InvocationContext invocationContext, Throwable throwable) {
        boolean bl;
        Long l = (Long)invocationContext.getInvocationContextObject("#invocation.start#");
        long l2 = l != null ? TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l) : -1L;
        String string = l2 >= 0L ? String.valueOf(l2) : "?";
        Method method = invocationContext.getMethod().getMethod();
        boolean bl2 = false;
        boolean bl3 = bl = throwable != null;
        if (!bl) {
            bl2 = Config.VMOMI_VC_INVOCATION_TIME_THRESHOLD_IN_MILLIS >= 0L && l2 > Config.VMOMI_VC_INVOCATION_TIME_THRESHOLD_IN_MILLIS && OpIdUtil.shouldSlowInvocationBeLogged((Method)method);
            boolean bl4 = bl = bl2 || _opIdLogger.isDebugEnabled();
        }
        if (!bl) {
            return;
        }
        Object object = ResultInterceptorImpl.getOpId(invocationContext);
        String string2 = ReflectionUtil.getBasicSignatureInfo((Method)method);
        StringBuilder stringBuilder = new StringBuilder().append("Invocation of '").append(string2).append('\'');
        this.appendServiceDetails(stringBuilder, invocationContext);
        stringBuilder.append(" for opId '").append(object);
        if (throwable != null) {
            stringBuilder.append("' failed in ").append(string).append(" ms: ");
            if (_opIdLogger.isTraceEnabled()) {
                _opIdLogger.error((Object)stringBuilder.toString(), throwable);
            } else {
                LogUtil.LogLevel logLevel = OpIdUtil.determineLogLevelFor((Log)_opIdLogger, (Method)method);
                if (logLevel != LogUtil.LogLevel.OFF && logLevel != LogUtil.LogLevel.TRACE) {
                    throwable = ExceptionUtil.unwrap((Throwable)throwable);
                    stringBuilder.append(throwable.getClass().getName());
                    String string3 = throwable.getMessage();
                    if (string3 != null) {
                        stringBuilder.append(' ').append(string3);
                    }
                    _opIdLogger.error((Object)stringBuilder.toString());
                }
            }
        } else if (bl2) {
            stringBuilder.append("' took too long: ").append(string).append(" ms");
            _opIdLogger.warn((Object)stringBuilder);
        } else {
            LogUtil.LogLevel logLevel = OpIdUtil.determineLogLevelFor((Log)_opIdLogger, (Method)method);
            if (logLevel == LogUtil.LogLevel.OFF) {
                return;
            }
            stringBuilder.append("' completed in ").append(string).append(" ms");
            if (logLevel == LogUtil.LogLevel.TRACE) {
                _opIdLogger.trace((Object)stringBuilder);
            } else {
                _opIdLogger.debug((Object)stringBuilder);
            }
        }
    }

    private void appendServiceDetails(StringBuilder stringBuilder, InvocationContext invocationContext) {
        String string;
        if (this._serviceDetails != null && (string = this._serviceDetails.get()) != null) {
            stringBuilder.append(" for ").append(this._serviceDetails.get());
            return;
        }
        if (invocationContext == null) {
            return;
        }
        string = invocationContext.getBinding();
        if (string == null) {
            return;
        }
        URI uRI = string.getEndpointUri();
        if (uRI == null) {
            return;
        }
        stringBuilder.append(" to ").append(uRI.toString());
    }
}

