/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.compositecommand;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vsphere.client.common.compositecommand.BaseCommand;
import com.vmware.vsphere.client.common.compositecommand.CommandDebugUtil;
import com.vmware.vsphere.client.common.compositecommand.CommandState;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FutureCommand
extends BaseCommand {
    private static final Log _logger = LogFactory.getLog(FutureCommand.class);
    public ClientFutureImpl<?> _future;

    @Override
    public final void run() throws Exception {
        if (_logger.isDebugEnabled()) {
            String className = this.getClass().getCanonicalName();
            String specDump = CommandDebugUtil.dumpCommandSpec(this.getCommandSpec(), false);
            _logger.debug((Object)String.format("Running future command %s for spec:\n%s", className, specDump));
        }
        this._future = this.launch();
    }

    protected abstract ClientFutureImpl<?> launch() throws Exception;

    public void updateRuntimeInfo() {
        if (this._future == null) {
            return;
        }
        if (this._future.isDone()) {
            this.runtimeInfo.progress = 100;
            this.runtimeInfo.state = CommandState.SUCCEEDED;
            try {
                this.runtimeInfo.result = this._future.get();
                if (this.runtimeInfo.result != null && this.runtimeInfo.result instanceof ManagedObjectReference) {
                    this.runtimeInfo.createdMor = (ManagedObjectReference)this.runtimeInfo.result;
                }
            }
            catch (ExecutionException ex) {
                this.runtimeInfo.error = ex;
                this.runtimeInfo.state = CommandState.FAILED;
            }
            catch (InterruptedException ex) {
                this.runtimeInfo.error = ex;
                this.runtimeInfo.state = CommandState.FAILED;
            }
        } else {
            this.runtimeInfo.state = CommandState.IN_PROGRESS;
            this.runtimeInfo.progress = 0;
        }
    }
}

