/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storagedrs.rules;

import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.storagedrs.rules.RulesUtil;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleInfo;
import com.vmware.vsphere.client.storagedrs.rules.VirtualDiskAffinityRuleSpec;
import com.vmware.vsphere.client.util.ServerModulesCommonUtil;
import java.util.ArrayList;
import java.util.List;

public class SdrsRulesBuilder {
    public static List<SdrsRuleInfo> buildVmAntiAffinityRules(ManagedObjectReference dsClusterRef, RuleInfo[] podConfigRule) {
        ArrayList<SdrsRuleInfo> result = new ArrayList<SdrsRuleInfo>();
        for (RuleInfo ruleInfo : podConfigRule) {
            SdrsRuleInfo vmAntiAffinity = RulesUtil.createSdrsRuleInfo(ruleInfo);
            vmAntiAffinity.datastoreCluster = dsClusterRef;
            result.add(vmAntiAffinity);
        }
        return result;
    }

    public static List<SdrsRuleInfo> buildIntraVmAntiAffinityRules(ManagedObjectReference dsClusterRef, VmConfigInfo[] dsClusterVmConfig) {
        ArrayList<SdrsRuleInfo> result = new ArrayList<SdrsRuleInfo>();
        for (VmConfigInfo vmConfigInfo : dsClusterVmConfig) {
            if (vmConfigInfo.intraVmAntiAffinity == null) continue;
            SdrsRuleInfo intraVmAntiAffinity = RulesUtil.createSdrsRuleInfo((RuleInfo)vmConfigInfo.intraVmAntiAffinity);
            intraVmAntiAffinity.vm = vmConfigInfo.vm;
            intraVmAntiAffinity.datastoreCluster = dsClusterRef;
            result.add(intraVmAntiAffinity);
        }
        return result;
    }

    public static List<SdrsRuleInfo> buildIntraVmAffinityRules(ManagedObjectReference dsClusterRef, VmConfigInfo[] dsClusterVmConfig) {
        ArrayList<SdrsRuleInfo> result = new ArrayList<SdrsRuleInfo>();
        for (VmConfigInfo vmConfig : dsClusterVmConfig) {
            if (vmConfig.intraVmAffinity == null) continue;
            VirtualDiskAffinityRuleSpec ruleInfo = SdrsRulesBuilder.createVirtualDiskAffinityRuleSpec();
            ruleInfo.keepVmdksTogether = vmConfig.intraVmAffinity;
            SdrsRuleInfo sdrsRule = RulesUtil.createSdrsRuleInfo(ruleInfo);
            sdrsRule.vm = vmConfig.vm;
            sdrsRule.datastoreCluster = dsClusterRef;
            result.add(sdrsRule);
        }
        return result;
    }

    private static VirtualDiskAffinityRuleSpec createVirtualDiskAffinityRuleSpec() {
        VirtualDiskAffinityRuleSpec ruleInfo = new VirtualDiskAffinityRuleSpec();
        ruleInfo.enabled = true;
        ruleInfo.name = ServerModulesCommonUtil.text("rules.intraVmAffinityRuleName", new String[0]);
        return ruleInfo;
    }
}

