/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vapi.impl;

import com.vmware.vapi.bindings.client.AsyncCallbackFuture;
import com.vmware.vapi.std.errors.Error;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.TaskFilterSpec;
import com.vmware.vim.binding.vim.TaskHistoryCollector;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.TaskManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VapiTaskMonitorImpl
implements VapiTaskMonitor {
    private static final Log _logger = LogFactory.getLog(VapiTaskMonitorImpl.class);

    public VapiTaskMonitorImpl() {
        _logger.debug((Object)"Instantiated");
    }

    @Override
    public <T> ManagedObjectReference waitForActivationTask(String activationId, AsyncCallbackFuture<T> asyncCallback) throws InterruptedException, ExecutionException {
        return this.waitForActivationTask(activationId, null, asyncCallback);
    }

    @Override
    public <T> ManagedObjectReference waitForActivationTask(String activationId, String serverGuid, AsyncCallbackFuture<T> asyncCallback) throws InterruptedException, ExecutionException {
        if (activationId == null || activationId.length() == 0) {
            return null;
        }
        TaskAndCollectorsData result = this.getTaskAndCollectors(activationId, serverGuid);
        if (result.task != null) {
            this.removeCollectors(result.collectors);
            return result.task;
        }
        if (ArrayUtil.isNullOrEmpty(result.collectors)) {
            _logger.warn((Object)String.format("Returning null task reference for activationId = %s due to no task collectors", activationId));
            return null;
        }
        try {
            for (int retryCount = 5; retryCount > 0; --retryCount) {
                BlockingUtil.sleep((long)500L);
                ManagedObjectReference task = this.getTask(result.collectors);
                if (task == null) continue;
                this.removeCollectors(result.collectors);
                ManagedObjectReference managedObjectReference = task;
                return managedObjectReference;
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
        finally {
            this.removeCollectors(result.collectors);
        }
        _logger.warn((Object)("Returning null task reference for activationId = " + activationId));
        return null;
    }

    private TaskAndCollectorsData getTaskAndCollectors(String activationId, String serverGuid) {
        LinkedVcGroup[] groups;
        TaskAndCollectorsData result = new TaskAndCollectorsData();
        result.collectors = new ArrayList<TaskHistoryCollector>();
        LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (registry == null) {
            _logger.warn((Object)"Cannot retrieve linked VC group registry");
            return result;
        }
        for (LinkedVcGroup vcGroup : groups = registry.getUtils().getStartupLinkedVcGroups()) {
            for (VcService svc : vcGroup.getVcServices()) {
                if (serverGuid != null && !serverGuid.equals(svc.getServiceGuid())) continue;
                try {
                    ServiceInstanceContent content = svc.getServiceInstanceContent();
                    TaskManager taskManager = (TaskManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.taskManager);
                    TaskFilterSpec filterSpec = new TaskFilterSpec();
                    filterSpec.activationId = new String[]{activationId};
                    ManagedObjectReference mor = taskManager.createCollector(filterSpec);
                    TaskHistoryCollector collector = (TaskHistoryCollector)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
                    result.collectors.add(collector);
                    Object[] infos = collector.getLatestPage();
                    if (ArrayUtil.isNullOrEmpty((Object[])infos)) continue;
                    result.task = ((TaskInfo)infos[0]).task;
                    return result;
                }
                catch (Exception e) {
                    _logger.warn((Object)("Ignoring the following exception in getTaskAndCollectors: " + e.getMessage()));
                }
            }
        }
        return result;
    }

    private void removeCollectors(List<TaskHistoryCollector> collectors) {
        for (TaskHistoryCollector collector : collectors) {
            collector.remove((Future)new ClientFutureImpl());
        }
    }

    private ManagedObjectReference getTask(List<TaskHistoryCollector> collectors) {
        for (TaskHistoryCollector collector : collectors) {
            Object[] infos = collector.getLatestPage();
            if (ArrayUtil.isNullOrEmpty((Object[])infos)) continue;
            return ((TaskInfo)infos[0]).task;
        }
        return null;
    }

    static class TaskAndCollectorsData {
        public ManagedObjectReference task;
        public List<TaskHistoryCollector> collectors;

        TaskAndCollectorsData() {
        }
    }
}

