/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.authn;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;
import org.apache.commons.lang.Validate;

public final class SamlAuthenticationData {
    private final SamlToken token;
    private final PrivateKey key;

    private SamlAuthenticationData(SamlToken token, PrivateKey key) {
        assert (token != null);
        this.token = token;
        this.key = key;
    }

    public SamlToken getSamlToken() {
        return this.token;
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public static final SamlAuthenticationData createInstance(ExecutionContext.SecurityContext ctx) {
        Validate.notNull((Object)ctx);
        Validate.isTrue((ctx.getProperty("authn_scheme_id").equals("com.vmware.vapi.std.security.saml_hok_token") || ctx.getProperty("authn_scheme_id").equals("com.vmware.vapi.std.security.saml_bearer_token") ? 1 : 0) != 0);
        Object tokenObject = ctx.getProperty("samlToken");
        Object privateKeyObject = ctx.getProperty("privateKey");
        if (tokenObject == null || !(tokenObject instanceof SamlToken)) {
            throw new IllegalStateException("Incorrectly constructed security context");
        }
        if (privateKeyObject != null && !(privateKeyObject instanceof PrivateKey)) {
            throw new IllegalStateException("Unknown object under the private key id");
        }
        return new SamlAuthenticationData((SamlToken)tokenObject, (PrivateKey)privateKeyObject);
    }
}

