/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.marshall;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.messaging.amf.vim.ManagedObjectReferenceProxy;
import com.vmware.vise.messaging.amf.vim.ThrowableProxy;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.messaging.marshall.Marshaller;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.io.MessageSerializer;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class AMF3Marshaller
implements Marshaller {
    private static final Log _logger = LogFactory.getLog(AMF3Marshaller.class);
    private final LinkedVcGroupRegistry linkedVcGroupRegistry;
    private Locale _locale;

    public AMF3Marshaller(LinkedVcGroupRegistry linkedVcGroupRegistry) {
        this.linkedVcGroupRegistry = linkedVcGroupRegistry;
    }

    public void init() {
        this._locale = (Locale)SessionUtil.getData((String)"Locale");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer marshall(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PropertyProxyRegistry propertyProxyRegistry = PropertyProxyRegistry.getRegistry();
        PropertyProxy propertyProxy = propertyProxyRegistry.getProxy(ManagedObjectReference.class, false, false);
        PropertyProxy propertyProxy2 = propertyProxyRegistry.getProxy(Throwable.class, false, false);
        boolean bl = propertyProxy instanceof ManagedObjectReferenceProxy;
        boolean bl2 = propertyProxy2 instanceof ThrowableProxy;
        if (bl && bl2) {
            Object object2;
            ManagedObjectReferenceProxy managedObjectReferenceProxy = (ManagedObjectReferenceProxy)propertyProxy;
            managedObjectReferenceProxy.setLinkedVcGroupRegistry(this.linkedVcGroupRegistry);
            ThrowableProxy throwableProxy = (ThrowableProxy)propertyProxy2;
            if (throwableProxy.locale != null) {
                throwableProxy.locale.set(this._locale);
            }
            if (throwableProxy.canInvokeRequests != null) {
                throwableProxy.canInvokeRequests.set(false);
            }
            try {
                object2 = ((AbstractEndpoint)MessageBroker.getMessageBroker((String)"_messageBroker").getEndpoint("secure-amf")).getSerializationContext();
                MessageSerializer messageSerializer = object2.newMessageSerializer();
                messageSerializer.setVersion(3);
                messageSerializer.initialize(object2, (OutputStream)byteArrayOutputStream, null);
                messageSerializer.writeObject(object);
            }
            finally {
                if (managedObjectReferenceProxy != null) {
                    managedObjectReferenceProxy.removeLinkedVcGroupRegistry();
                }
                if (throwableProxy != null) {
                    if (throwableProxy.locale != null) {
                        throwableProxy.locale.remove();
                    }
                    if (throwableProxy.canInvokeRequests != null) {
                        throwableProxy.canInvokeRequests.remove();
                    }
                }
            }
            object2 = new String(Base64.encodeBase64((byte[])byteArrayOutputStream.toByteArray()));
            return CharBuffer.wrap((CharSequence)object2);
        }
        if (!bl) {
            this.writeProxyErrorMessage(propertyProxy, ManagedObjectReference.class);
        }
        if (!bl2) {
            this.writeProxyErrorMessage(propertyProxy2, Throwable.class);
        }
        String string = "Flex messaging context is invalid - no suitable PropertyProxy registered for the following instances: ";
        if (!bl) {
            string = string + "ManagedObjectReference,";
        }
        if (!bl2) {
            string = string + "Throwable";
        }
        throw new IllegalStateException(string);
    }

    private void writeProxyErrorMessage(PropertyProxy propertyProxy, Class<?> clazz) {
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        _logger.error((Object)("The bundle who loaded [" + clazz + "] class is " + bundle.getSymbolicName() + "-" + bundle.getVersion()));
        if (propertyProxy != null) {
            Bundle bundle2 = FrameworkUtil.getBundle(propertyProxy.getClass());
            _logger.error((Object)("The PropertyProxy registered for " + clazz.getSimpleName() + " instances is of type [" + propertyProxy.getClass() + "] loaded from a bundle " + bundle2.getSymbolicName() + "-" + bundle2.getVersion()));
        }
    }
}

