/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.adapter;

import com.vmware.license.client.cis.adapter.BaseDataProviderAdapterImpl;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.ServicePropertyProviderAdapter;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseLicensingObjectsDataProviderAdapterImpl<T>
extends BaseDataProviderAdapterImpl {
    @Override
    protected ResultSet getResultSet(QuerySpec querySpec) {
        Object[] objectArray = this.getObjectsByQuerySpec(querySpec);
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return ResultUtil.newEmptyResultSet();
        }
        ResultSet resultSet = this.getResultSet(querySpec, objectArray);
        resultSet.totalMatchedObjectCount = objectArray.length;
        return resultSet;
    }

    protected abstract BasePropertyProviderBean<T> getPropertyProvider();

    protected abstract String getProvidedType();

    protected abstract URI getUri(T var1);

    protected T[] getObjectsByUris(URI[] uRIArray) {
        return null;
    }

    protected T[] getRelatedObjects(Object[] objectArray, String string) {
        return null;
    }

    protected T[] getObjectsByPropertyConstraint(PropertyConstraint propertyConstraint) {
        return null;
    }

    protected T[] getObjectsByCompositeConstraint(CompositeConstraint compositeConstraint) {
        return null;
    }

    protected T[] getAllObjects() {
        return null;
    }

    protected T[] getObjectsByRelationalConstraint(RelationalConstraint relationalConstraint) {
        String string = relationalConstraint.relation;
        Object[] objectArray = Utils.getEnumeratedObjects((RelationalConstraint)relationalConstraint);
        return this.getRelatedObjects(objectArray, string);
    }

    protected final ResultSet getResultSet(QuerySpec querySpec, T[] TArray) {
        Map<URI, T> map = this.groupObjectsByUri(TArray);
        PropertyRequestSpec propertyRequestSpec = new PropertyRequestSpec();
        propertyRequestSpec.objects = map.keySet().toArray();
        propertyRequestSpec.properties = this.filterPropertySpecsByType(querySpec.resourceSpec.propertySpecs, this.getProvidedType());
        BasePropertyProviderBean<T> basePropertyProviderBean = this.getPropertyProvider();
        basePropertyProviderBean.setUriToObjectMap(map);
        ServicePropertyProviderAdapter servicePropertyProviderAdapter = new ServicePropertyProviderAdapter(basePropertyProviderBean);
        ResultSet resultSet = servicePropertyProviderAdapter.getProperties(propertyRequestSpec);
        if (resultSet == null) {
            resultSet = ResultUtil.newEmptyResultSet();
        }
        return resultSet;
    }

    private T[] getObjectsByQuerySpec(QuerySpec querySpec) {
        T[] TArray = null;
        Object[] objectArray = Utils.getEnumeratedObjects((QuerySpec)querySpec);
        if (!ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            TArray = this.getObjectsByRefs(objectArray);
            return TArray;
        }
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (constraint instanceof PropertyConstraint) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            TArray = this.getObjectsByPropertyConstraint(propertyConstraint);
        } else if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            TArray = this.getObjectsByRelationalConstraint(relationalConstraint);
        } else if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            TArray = this.getObjectsByCompositeConstraint(compositeConstraint);
        } else {
            TArray = this.getAllObjects();
        }
        return TArray;
    }

    private T[] getObjectsByRefs(Object[] objectArray) {
        URI[] uRIArray = this.filterLicensingObjectsUris(objectArray);
        return this.getObjectsByUris(uRIArray);
    }

    private URI[] filterLicensingObjectsUris(Object[] objectArray) {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (Object object : objectArray) {
            if (!(object instanceof URI) || !UriUtil.isUriOfType((URI)object, this.getProvidedType())) continue;
            arrayList.add((URI)object);
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    private Map<URI, T> groupObjectsByUri(T[] TArray) {
        LinkedHashMap<URI, T> linkedHashMap = new LinkedHashMap<URI, T>();
        if (ArrayUtil.isNullOrEmpty((Object[])TArray)) {
            return linkedHashMap;
        }
        for (T t : TArray) {
            URI uRI = this.getUri(t);
            linkedHashMap.put(uRI, t);
        }
        return linkedHashMap;
    }

    private PropertySpec[] filterPropertySpecsByType(PropertySpec[] propertySpecArray, String string) {
        if (string == null) {
            return new PropertySpec[0];
        }
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        for (PropertySpec propertySpec : propertySpecArray) {
            if (propertySpec.type != null && !string.equals(propertySpec.type)) continue;
            arrayList.add(propertySpec);
        }
        return arrayList.toArray(new PropertySpec[arrayList.size()]);
    }
}

