/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.license.client.cis.ls.AuthorizationManager;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.SsoUtil;
import java.util.List;

public class AuthorizationManagerImpl
implements AuthorizationManager {
    private static final String LS_ADMIN_SSO_GROUP = "LicenseService.Administrators";
    private static final String ADMINISTRATOR_SSO_GROUP = "Administrators";

    private static boolean isGroupInToken(String string, String string2, SamlToken samlToken) {
        if (samlToken == null || samlToken.getGroupList() == null) {
            return false;
        }
        boolean bl = false;
        List list = samlToken.getGroupList();
        for (PrincipalId principalId : list) {
            if (!string.equals(principalId.getName()) || !string2.equals(principalId.getDomain())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean isLicensingAdminPrivilegeGranted(LicenseScope licenseScope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseScope});
        boolean bl = this.isCurrentLoggedInUserLicenseAdmin();
        return bl;
    }

    private boolean isCurrentLoggedInUserLicenseAdmin() {
        SamlToken samlToken = AuthSessionUtil.getSsoToken();
        String string = this.getSystemDomainName();
        boolean bl = AuthorizationManagerImpl.isGroupInToken(LS_ADMIN_SSO_GROUP, string, samlToken);
        if (!bl) {
            bl = AuthorizationManagerImpl.isGroupInToken(ADMINISTRATOR_SSO_GROUP, string, samlToken);
        }
        return bl;
    }

    private String getSystemDomainName() {
        SsoSolutionUser ssoSolutionUser = SsoUtil.getSolutionUser();
        SamlToken samlToken = ssoSolutionUser.getLoggedInToken();
        return SsoUtil.getDomainName((String)samlToken.getSubjectNameId().getValue());
    }
}

