/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.impl.LruCacheImpl;
import com.vmware.license.client.cis.ls.ComponentManagerClient;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.cis.cm.site.Folder;
import com.vmware.vise.util.ValidationUtil;

public class CacheComponentManagerClientWrapperImpl
implements ComponentManagerClient {
    private static final int CACHE_CAPACITY = 100;
    private static final String SERVICE_TYPE_IDENTIFIER_DELIM = "~";
    private final ComponentManagerClient _cmClient;
    private final Cache<String, ServiceInfo[]> _serviceTypeIdentifierToServiceInfosCache;

    public CacheComponentManagerClientWrapperImpl(ComponentManagerClient componentManagerClient) {
        this._cmClient = componentManagerClient;
        this._serviceTypeIdentifierToServiceInfosCache = new LruCacheImpl(100);
    }

    private static String buildServiceTypeIdentifier(ServiceType serviceType, Folder folder) {
        String string;
        ValidationUtil.paramsNotNull((Object[])new Object[]{serviceType});
        String string2 = string = serviceType.getProductId() + serviceType.getTypeId();
        if (folder != null) {
            string2 = string2 + SERVICE_TYPE_IDENTIFIER_DELIM;
            string2 = string2 + folder.getId();
            string2 = string2 + SERVICE_TYPE_IDENTIFIER_DELIM;
            string2 = string2 + folder.getParentId();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInfo[] searchServiceInfos(ServiceType serviceType, Folder folder) throws ComponentManagerFault {
        String string = CacheComponentManagerClientWrapperImpl.buildServiceTypeIdentifier(serviceType, folder);
        ServiceInfo[] serviceInfoArray = (ServiceInfo[])this._serviceTypeIdentifierToServiceInfosCache.get((Object)string);
        if (serviceInfoArray == null) {
            Cache<String, ServiceInfo[]> cache = this._serviceTypeIdentifierToServiceInfosCache;
            synchronized (cache) {
                serviceInfoArray = (ServiceInfo[])this._serviceTypeIdentifierToServiceInfosCache.get((Object)string);
                if (serviceInfoArray == null) {
                    serviceInfoArray = this._cmClient.searchServiceInfos(serviceType, folder);
                    if (serviceInfoArray == null) {
                        serviceInfoArray = new ServiceInfo[]{};
                    }
                    this._serviceTypeIdentifierToServiceInfosCache.put((Object)string, (Object)serviceInfoArray);
                }
            }
        }
        return serviceInfoArray;
    }
}

