/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.license.client.cis.ls.AuthorizationException;
import com.vmware.license.client.cis.ls.AuthorizationManager;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.ScopeResolver;
import com.vmware.license.client.util.ManagementUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.debug.TimeMonitor;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import java.util.concurrent.TimeUnit;

public class VpxAuthorizationManagerImpl
implements AuthorizationManager {
    private static final String VPX_LICENSE_ADMIN_PRIVILEGE_NAME = "Global.Licenses";
    private static final long AUTHZ_CALL_LOG_THRESHOLD_IN_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private final ScopeResolver _scopeResolver;
    private final LegacyAuthorizationService _authorizationService;

    public VpxAuthorizationManagerImpl(ScopeResolver scopeResolver, LegacyAuthorizationService legacyAuthorizationService) {
        this._scopeResolver = scopeResolver;
        this._authorizationService = legacyAuthorizationService;
    }

    @Override
    public boolean isLicensingAdminPrivilegeGranted(LicenseScope licenseScope) throws AuthorizationException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseScope});
        try {
            boolean bl = this.isVpxLicenseAdminPrivilegeGranted(licenseScope);
            return bl;
        }
        catch (Exception exception) {
            throw new AuthorizationException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVpxLicenseAdminPrivilegeGranted(LicenseScope licenseScope) throws Exception {
        String string = this._scopeResolver.getVcId(licenseScope);
        ManagedObjectReference managedObjectReference = ManagementUtil.buildVcMoRef(string);
        TimeMonitor timeMonitor = new TimeMonitor();
        try {
            timeMonitor.init();
            boolean bl = this._authorizationService.checkPrivileges(new ManagedObjectReference[]{managedObjectReference}, new String[]{VPX_LICENSE_ADMIN_PRIVILEGE_NAME});
            return bl;
        }
        finally {
            timeMonitor.logTimeIfExceeding(AUTHZ_CALL_LOG_THRESHOLD_IN_NANOS, "NGC authorization service check privileges", LegacyAuthorizationService.class, (Object)this._authorizationService);
        }
    }
}

