/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.ls.AuthorizationException;
import com.vmware.license.client.cis.ls.AuthorizationManager;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetUpdateLicenseSpec;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementObjectsFormatter;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.AssignLicenseAggregatedUsages;
import com.vmware.license.client.cis.management.ds.AssignLicenseUnsupportedFeatures;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.LicenseAssignInfo;
import com.vmware.license.client.cis.management.ds.LicenseAssignRestriction;
import com.vmware.license.client.cis.management.ds.LicenseType;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.ds.results.AssetAssignLicenseValidationResult;
import com.vmware.license.client.cis.management.ds.results.AssetAssignSubscriptionLicenseValidationResult;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignLicenseConnectInfoValidateSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignLicenseValidateSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignSubscriptionLicenseValidateSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetRemoveSpec;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.AssignLicenseUnsupportedFeaturesUtil;
import com.vmware.license.client.cis.management.util.AssignLicenseUsageCalculationUtil;
import com.vmware.license.client.cis.management.util.HostConnectionUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.cis.util.MutationUtil;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssetMutationProvider
implements MutationProvider {
    private static final String SOURCE_ID_KEY = "sourceId";
    private static final String SOURCE_ID_VC_VALUE = "vc";
    private final Log _logger = LogFactory.getLog(AssetMutationProvider.class);
    private final VpxManagementEditor _vpxManagementEditor;
    private final ManagementObjectsFormatter _managementObjectsFormatter;
    private final AuthorizationManager _authorizationManager;

    public AssetMutationProvider(VpxManagementEditor vpxManagementEditor, ManagementObjectsFormatter managementObjectsFormatter, AuthorizationManager authorizationManager) {
        this._vpxManagementEditor = vpxManagementEditor;
        this._managementObjectsFormatter = managementObjectsFormatter;
        this._authorizationManager = authorizationManager;
    }

    public OperationResult[] applyOnMultiEntity(URI[] uRIArray, AssetAssignLicenseSpec assetAssignLicenseSpec) {
        try {
            URI uRI = assetAssignLicenseSpec.licenseRef;
            UriUtil.validateLicenseUri(uRI);
            boolean bl = LicenseUtil.EVALUATION_LICENSE_URI.equals(uRI);
            AssetUpdateLicenseSpec[] assetUpdateLicenseSpecArray = this.createAssetUpdateLicenseSpecs(uRIArray, uRI, bl);
            this._vpxManagementEditor.updateAssetsLicense(assetUpdateLicenseSpecArray);
            return MutationUtil.createOperationResults(uRIArray);
        }
        catch (Throwable throwable) {
            this.logError(throwable);
            return MutationUtil.createOperationResults(throwable);
        }
    }

    public OperationResult[] removeOnMultiEntity(URI[] uRIArray, AssetRemoveSpec assetRemoveSpec) {
        try {
            this._vpxManagementEditor.unregisterAssets(uRIArray);
            return MutationUtil.createOperationResults(uRIArray);
        }
        catch (Throwable throwable) {
            this.logError(throwable);
            return MutationUtil.createOperationResults(throwable);
        }
    }

    public ValidationResult[] validateOnMultiEntity(URI[] uRIArray, AssetAssignSubscriptionLicenseValidateSpec assetAssignSubscriptionLicenseValidateSpec) {
        try {
            if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
                throw new IllegalArgumentException("The asset URIs array should not be empty");
            }
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRIArray[0]);
            Asset[] assetArray = this._vpxManagementEditor.getAssets(uRIArray, licenseScope);
            LicenseSearchProperties licenseSearchProperties = new LicenseSearchProperties();
            licenseSearchProperties.setLicenseType(LicenseType.SUBSCRIPTION);
            License[] licenseArray = this._vpxManagementEditor.getLicenses(licenseScope, licenseSearchProperties);
            this._managementObjectsFormatter.formatAssets(assetArray);
            this._managementObjectsFormatter.formatLicenses(licenseArray);
            AssetAssignSubscriptionLicenseValidationResult assetAssignSubscriptionLicenseValidationResult = new AssetAssignSubscriptionLicenseValidationResult();
            assetAssignSubscriptionLicenseValidationResult.assets = assetArray;
            assetAssignSubscriptionLicenseValidationResult.licenses = licenseArray;
            return MutationUtil.createValidationResults(new Object[]{assetAssignSubscriptionLicenseValidationResult});
        }
        catch (Throwable throwable) {
            this.logError(throwable);
            return MutationUtil.createValidationResults(throwable);
        }
    }

    public ValidationResult[] validateOnMultiEntity(Object[] objectArray, AssetAssignLicenseValidateSpec assetAssignLicenseValidateSpec) {
        try {
            Object[] objectArray2;
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                throw new IllegalArgumentException("The entities array should not be empty");
            }
            Asset[] assetArray = null;
            LicenseScope licenseScope = null;
            if (objectArray instanceof URI[]) {
                objectArray2 = (URI[])objectArray;
                licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(objectArray2[0]);
                assetArray = this._vpxManagementEditor.getAssets((URI[])objectArray2, licenseScope);
            } else if (objectArray instanceof ManagedObjectReference[]) {
                objectArray2 = (ManagedObjectReference[])objectArray;
                if (!this.doAssetsHaveSameScope((ManagedObjectReference[])objectArray2)) {
                    throw new IllegalArgumentException("The entities array should have the same license scope");
                }
                licenseScope = LicenseScopeUtil.getLicenseScopeByMoRef((ManagedObjectReference)objectArray2[0]);
                assetArray = this._vpxManagementEditor.getAssetsByMoRefs((ManagedObjectReference[])objectArray2, licenseScope);
            } else {
                throw new IllegalArgumentException("The entities array should be either a URI array or an array with a single ManagedObjectReference");
            }
            objectArray2 = this.getSkLicenses(licenseScope);
            return this.validateMultiAssetsAssignments(assetArray, (License[])objectArray2);
        }
        catch (Throwable throwable) {
            this.logError(throwable);
            return MutationUtil.createValidationResults(throwable);
        }
    }

    public ValidationResult validate(AssetAssignLicenseConnectInfoValidateSpec assetAssignLicenseConnectInfoValidateSpec) {
        try {
            if (assetAssignLicenseConnectInfoValidateSpec.scope == null || assetAssignLicenseConnectInfoValidateSpec.connectInfo == null) {
                throw new IllegalArgumentException("Scope and connectInfo should not be empty");
            }
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(assetAssignLicenseConnectInfoValidateSpec.scope);
            boolean bl = false;
            try {
                bl = this._authorizationManager.isLicensingAdminPrivilegeGranted(licenseScope);
            }
            catch (AuthorizationException authorizationException) {
                this._logger.warn((Object)"Cannot retrieve privileges data: ", (Throwable)authorizationException);
            }
            License[] licenseArray = bl ? this.getSkLicenses(licenseScope) : new License[]{};
            Asset asset = HostConnectionUtil.previewHostAsset(assetAssignLicenseConnectInfoValidateSpec.connectInfo, licenseArray);
            return this.validateAddHostAssignment(asset, licenseArray);
        }
        catch (Throwable throwable) {
            this.logError(throwable);
            return MutationUtil.createValidationResult(throwable);
        }
    }

    private void logError(Throwable throwable) {
        if (this._logger.isErrorEnabled()) {
            this._logger.error((Object)"Unable to execute asset mutation operation: ", throwable);
        }
    }

    private AssetUpdateLicenseSpec[] createAssetUpdateLicenseSpecs(URI[] uRIArray, URI uRI, boolean bl) {
        if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
            return new AssetUpdateLicenseSpec[0];
        }
        AssetUpdateLicenseSpec[] assetUpdateLicenseSpecArray = new AssetUpdateLicenseSpec[uRIArray.length];
        for (int i = 0; i < uRIArray.length; ++i) {
            assetUpdateLicenseSpecArray[i] = new AssetUpdateLicenseSpec(uRIArray[i], uRI, bl);
        }
        return assetUpdateLicenseSpecArray;
    }

    private boolean doAssetsHaveSameScope(ManagedObjectReference[] managedObjectReferenceArray) {
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByMoRef(managedObjectReferenceArray[0]);
        for (int i = 1; i < managedObjectReferenceArray.length; ++i) {
            LicenseScope licenseScope2 = LicenseScopeUtil.getLicenseScopeByMoRef(managedObjectReferenceArray[i]);
            if (licenseScope.equals(licenseScope2)) continue;
            return false;
        }
        return true;
    }

    private License[] getSkLicenses(LicenseScope licenseScope) {
        LicenseSearchProperties licenseSearchProperties = new LicenseSearchProperties();
        licenseSearchProperties.setLicenseType(LicenseType.SERIAL_KEY);
        License[] licenseArray = this._vpxManagementEditor.getLicenses(licenseScope, licenseSearchProperties);
        return licenseArray;
    }

    private ValidationResult[] validateMultiAssetsAssignments(Asset[] assetArray, License[] licenseArray) {
        ValidationResult validationResult = this.createAssignLicenseValidationResult(assetArray, licenseArray, true, null);
        return new ValidationResult[]{validationResult};
    }

    private ValidationResult createAssignLicenseValidationResult(Asset[] assetArray, License[] licenseArray, boolean bl, URI uRI) {
        LicenseAssignInfo[] licenseAssignInfoArray = this.getApplicableLicensesAssignInfos(assetArray, licenseArray, bl);
        License[] licenseArray2 = this.getLicensesFromLicenseAssignInfos(licenseAssignInfoArray);
        AssignLicenseAggregatedUsages assignLicenseAggregatedUsages = AssignLicenseUsageCalculationUtil.createAssignLicenseAggregatedUsages(assetArray, licenseArray2);
        AssignLicenseUnsupportedFeatures assignLicenseUnsupportedFeatures = AssignLicenseUnsupportedFeaturesUtil.createAssignLicenseUnsupportedFeatures(assetArray, licenseArray2);
        this._managementObjectsFormatter.formatLicenses(licenseArray2);
        this._managementObjectsFormatter.formatAssets(assetArray);
        AssetAssignLicenseValidationResult assetAssignLicenseValidationResult = this.createAssetAssignLicenseValidationResult(assetArray, licenseAssignInfoArray, assignLicenseAggregatedUsages, assignLicenseUnsupportedFeatures, bl, uRI);
        return MutationUtil.createValidationResult((Object)assetAssignLicenseValidationResult);
    }

    private LicenseAssignInfo[] getApplicableLicensesAssignInfos(Asset[] assetArray, License[] licenseArray, boolean bl) {
        ArrayList<LicenseAssignInfo> arrayList = new ArrayList<LicenseAssignInfo>();
        LicenseAssignInfo licenseAssignInfo = this.createEvaluationLicenseAssignInfo(assetArray);
        if (licenseAssignInfo != null) {
            arrayList.add(licenseAssignInfo);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])licenseArray)) {
            for (License license : licenseArray) {
                if (!AssetUtil.isLicenseApplicableForAssets(license, assetArray, bl)) continue;
                Set<LicenseAssignRestriction> set = AssetUtil.getLicenseAssignRestrictionsForAssets(license, assetArray);
                LicenseAssignInfo licenseAssignInfo2 = this.createLicenseAssignInfo(license, set, false);
                arrayList.add(licenseAssignInfo2);
            }
        }
        return arrayList.toArray(new LicenseAssignInfo[arrayList.size()]);
    }

    private LicenseAssignInfo createEvaluationLicenseAssignInfo(Asset[] assetArray) {
        HashSet<LicenseAssignRestriction> hashSet = new HashSet<LicenseAssignRestriction>();
        boolean bl = true;
        boolean bl2 = false;
        Long l = assetArray[0].getEvaluationLicense() == null ? null : assetArray[0].getEvaluationLicense().getExpirationTime();
        for (Asset asset : assetArray) {
            License license = asset.getEvaluationLicense();
            if (license == null) {
                bl = false;
                break;
            }
            Set<LicenseAssignRestriction> set = AssetUtil.getLicenseAssignRestrictionsForAsset(license, asset);
            hashSet.addAll(set);
            Long l2 = license.getExpirationTime();
            if (bl2 || ObjectUtil.compare((Comparable)l, (Comparable)l2) == 0) continue;
            bl2 = true;
            l = null;
        }
        if (!bl) {
            return null;
        }
        License license = LicenseUtil.createEvaluationLicense(l);
        return this.createLicenseAssignInfo(license, hashSet, bl2);
    }

    private LicenseAssignInfo createLicenseAssignInfo(License license, Set<LicenseAssignRestriction> set, boolean bl) {
        LicenseAssignInfo licenseAssignInfo = new LicenseAssignInfo();
        licenseAssignInfo.setLicense(license);
        licenseAssignInfo.setExpirationTimeMixed(bl);
        licenseAssignInfo.setAssignRestrictions(set.toArray(new LicenseAssignRestriction[set.size()]));
        return licenseAssignInfo;
    }

    private License[] getLicensesFromLicenseAssignInfos(LicenseAssignInfo[] licenseAssignInfoArray) {
        License[] licenseArray = new License[licenseAssignInfoArray.length];
        for (int i = 0; i < licenseAssignInfoArray.length; ++i) {
            licenseArray[i] = licenseAssignInfoArray[i].getLicense();
        }
        return licenseArray;
    }

    private AssetAssignLicenseValidationResult createAssetAssignLicenseValidationResult(Asset[] assetArray, LicenseAssignInfo[] licenseAssignInfoArray, AssignLicenseAggregatedUsages assignLicenseAggregatedUsages, AssignLicenseUnsupportedFeatures assignLicenseUnsupportedFeatures, boolean bl, URI uRI) {
        AssetAssignLicenseValidationResult assetAssignLicenseValidationResult = new AssetAssignLicenseValidationResult();
        assetAssignLicenseValidationResult.assets = assetArray;
        assetAssignLicenseValidationResult.licensesAssignInfos = licenseAssignInfoArray;
        assetAssignLicenseValidationResult.aggregatedUsages = assignLicenseAggregatedUsages;
        assetAssignLicenseValidationResult.unsupportedFeatures = assignLicenseUnsupportedFeatures;
        assetAssignLicenseValidationResult.isAssetDlfVersionSupported = bl;
        assetAssignLicenseValidationResult.licenseFromAnotherVcRef = uRI;
        return assetAssignLicenseValidationResult;
    }

    private ValidationResult validateAddHostAssignment(Asset asset, License[] licenseArray) {
        License license;
        boolean bl = this.isHostDlfVersionSupported(asset, licenseArray);
        URI uRI = null;
        if (AssetLicenseState.LICENSED.equals((Object)asset.getLicenseState()) && !this.isHostLicensePresent(license = asset.getLicense(), licenseArray)) {
            licenseArray = (License[])ArrayUtil.append((Object[])licenseArray, (Object)((Object)license));
            uRI = this.isHostAssetLicensedInAnotherVc(asset) ? license.getUri() : null;
        }
        return this.createAssignLicenseValidationResult(new Asset[]{asset}, licenseArray, bl, uRI);
    }

    private boolean isHostDlfVersionSupported(Asset asset, License[] licenseArray) {
        for (License license : licenseArray) {
            if (!AssetUtil.isLicenseApplicableForAsset(license, asset, true)) continue;
            return true;
        }
        return false;
    }

    private boolean isHostLicensePresent(License license, License[] licenseArray) {
        String string = license.getSerialKeys()[0];
        for (License license2 : licenseArray) {
            if (!LicenseUtil.hasSerialKey(string, license2)) continue;
            return true;
        }
        return false;
    }

    private boolean isHostAssetLicensedInAnotherVc(Asset asset) {
        ProductCapability productCapability = AssetUtil.getAssetProductCapability(asset);
        if (productCapability == null) {
            throw new IllegalArgumentException("No capability found for host: " + asset.getName());
        }
        KeyAnyValue[] keyAnyValueArray = productCapability.getProperties();
        String string = (String)ManagementUtil.getKeyAnyValuePropertyValue(SOURCE_ID_KEY, keyAnyValueArray);
        return SOURCE_ID_VC_VALUE.equals(string);
    }
}

