/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.ManagementObjectsFormatter;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.results.AddSubscriptionLicensePreviewResult;
import com.vmware.license.client.cis.management.ds.results.AssignLicensePreviewResult;
import com.vmware.license.client.cis.management.ds.results.LicensePreviewResult;
import com.vmware.license.client.cis.management.ds.specs.AddLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.AssignLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseCreateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseUpdateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensesRemoveSpec;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.util.ErrorMessageBuilder;
import com.vmware.license.client.cis.util.Formatter;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.cis.util.MutationUtil;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseMutationProvider
implements MutationProvider {
    private final Log _logger = LogFactory.getLog(LicenseMutationProvider.class);
    private final ManagementEditor _managementEditor;
    private final ManagementObjectsFormatter _managementObjectsFormatter;

    public LicenseMutationProvider(ManagementEditor managementEditor, ManagementObjectsFormatter managementObjectsFormatter) {
        this._managementEditor = managementEditor;
        this._managementObjectsFormatter = managementObjectsFormatter;
    }

    public OperationResult[] addMulti(LicenseCreateSpec[] licenseCreateSpecArray) {
        try {
            Object[] objectArray = this._managementEditor.addLicenses(licenseCreateSpecArray);
            return MutationUtil.createOperationResults(objectArray);
        }
        catch (Throwable throwable) {
            this.logError(throwable);
            return MutationUtil.createOperationResults(throwable);
        }
    }

    public OperationResult add(AddSubscriptionLicenseSpec addSubscriptionLicenseSpec) {
        try {
            URI uRI = this._managementEditor.addSubscriptionLicense(addSubscriptionLicenseSpec);
            return MutationUtil.createOperationResult(uRI);
        }
        catch (Throwable throwable) {
            this.logError(throwable);
            return MutationUtil.createOperationResult(throwable);
        }
    }

    public OperationResult apply(URI uRI, LicenseUpdateSpec licenseUpdateSpec) {
        try {
            this._managementEditor.updateLicenses(new LicenseUpdateSpec[]{licenseUpdateSpec});
            return MutationUtil.createOperationResult(uRI);
        }
        catch (Throwable throwable) {
            this.logError(throwable);
            return MutationUtil.createOperationResult(throwable);
        }
    }

    public OperationResult[] removeOnMultiEntity(URI[] uRIArray, LicensesRemoveSpec licensesRemoveSpec) {
        try {
            this._managementEditor.removeLicenses(uRIArray);
            return MutationUtil.createOperationResults(uRIArray);
        }
        catch (Throwable throwable) {
            this.logError(throwable);
            return MutationUtil.createOperationResults(throwable);
        }
    }

    public ValidationResult[] validateMultiSpec(AddLicensePreviewSpec[] addLicensePreviewSpecArray) {
        try {
            ValidationResult[] validationResultArray;
            LicenseUiScope licenseUiScope = addLicensePreviewSpecArray[0].scope;
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
            License[] licenseArray = this._managementEditor.getLicenses(licenseScope, null);
            String[] stringArray = LicenseUtil.getNewLicensesNames(addLicensePreviewSpecArray.length, licenseArray.length);
            LicensePreviewSpec[] licensePreviewSpecArray = this.buildLicensePreviewSpecs(addLicensePreviewSpecArray, stringArray);
            License[] licenseArray2 = LicenseUtil.getSerialKeyLicenses(licenseArray);
            License[] licenseArray3 = this._managementEditor.previewLicenses(licensePreviewSpecArray);
            this.validateSkLicenses(licenseArray3, licenseArray2);
            this._managementObjectsFormatter.formatLicenses(licenseArray3);
            if (addLicensePreviewSpecArray instanceof AssignLicensePreviewSpec[]) {
                AssignLicensePreviewSpec[] assignLicensePreviewSpecArray = (AssignLicensePreviewSpec[])addLicensePreviewSpecArray;
                validationResultArray = this.createAssignLicensePreviewResults(licenseArray3, assignLicensePreviewSpecArray[0].assets, assignLicensePreviewSpecArray[0].areAssetsDlfVersionsSupported);
            } else {
                validationResultArray = this.createLicensePreviewResults(licenseArray3);
            }
            return validationResultArray;
        }
        catch (Throwable throwable) {
            this.logError(throwable);
            return MutationUtil.createValidationResults(throwable);
        }
    }

    public ValidationResult validate(AddSubscriptionLicensePreviewSpec addSubscriptionLicensePreviewSpec) {
        try {
            AddSubscriptionLicensePreviewResult addSubscriptionLicensePreviewResult = this._managementEditor.previewSubscriptionLicense(addSubscriptionLicensePreviewSpec);
            this._managementObjectsFormatter.formatSubscriptionInfos(addSubscriptionLicensePreviewResult.subscriptions);
            return MutationUtil.createValidationResult((Object)addSubscriptionLicensePreviewResult);
        }
        catch (Throwable throwable) {
            this.logError(throwable);
            return MutationUtil.createValidationResult(throwable);
        }
    }

    private void logError(Throwable throwable) {
        if (this._logger.isErrorEnabled()) {
            this._logger.error((Object)"Unable to execute license mutation operation: ", throwable);
        }
    }

    private LicensePreviewSpec[] buildLicensePreviewSpecs(AddLicensePreviewSpec[] addLicensePreviewSpecArray, String[] stringArray) {
        LicensePreviewSpec[] licensePreviewSpecArray = new LicensePreviewSpec[addLicensePreviewSpecArray.length];
        for (int i = 0; i < addLicensePreviewSpecArray.length; ++i) {
            LicensePreviewSpec licensePreviewSpec = new LicensePreviewSpec();
            licensePreviewSpec.name = stringArray[i];
            licensePreviewSpec.scope = addLicensePreviewSpecArray[i].scope;
            licensePreviewSpec.serialKeys = addLicensePreviewSpecArray[i].serialKeys;
            licensePreviewSpecArray[i] = licensePreviewSpec;
        }
        return licensePreviewSpecArray;
    }

    private void validateSkLicenses(License[] licenseArray, License[] licenseArray2) {
        ErrorMessageBuilder errorMessageBuilder = new ErrorMessageBuilder();
        SerialKeyFormatter serialKeyFormatter = new SerialKeyFormatter();
        Collection<String> collection = this.getExistingSerialKeys(licenseArray, licenseArray2);
        errorMessageBuilder.buildErrorGroup("previewLicenseError.existingGroupFormat", collection, serialKeyFormatter);
        Collection<String> collection2 = this.getExpiredSerialKeys(licenseArray);
        errorMessageBuilder.buildErrorGroup("previewLicenseError.expiredGroupFormat", collection2, serialKeyFormatter);
        String string = errorMessageBuilder.getErrorMessage("previewLicenseError.format");
        if (string != null) {
            throw new ManagementException(string);
        }
    }

    private Collection<String> getExistingSerialKeys(License[] licenseArray, License[] licenseArray2) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = this.getSerialKeys(licenseArray);
        for (License license : licenseArray2) {
            String[] stringArray;
            for (String string : stringArray = license.getSerialKeys()) {
                if (!hashSet2.contains(string)) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private HashSet<String> getSerialKeys(License[] licenseArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (License license : licenseArray) {
            String[] stringArray;
            for (String string : stringArray = license.getSerialKeys()) {
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private Collection<String> getExpiredSerialKeys(License[] licenseArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (License license : licenseArray) {
            String[] stringArray;
            if (!LicenseUtil.isExpiredLicense(license)) continue;
            for (String string : stringArray = license.getSerialKeys()) {
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private ValidationResult[] createAssignLicensePreviewResults(License[] licenseArray, Asset[] assetArray, boolean bl) {
        ValidationResult[] validationResultArray = new ValidationResult[licenseArray.length];
        for (int i = 0; i < validationResultArray.length; ++i) {
            AssignLicensePreviewResult assignLicensePreviewResult = new AssignLicensePreviewResult();
            assignLicensePreviewResult.license = licenseArray[i];
            assignLicensePreviewResult.isApplicableForAllAssets = AssetUtil.isLicenseApplicableForAssets(licenseArray[i], assetArray, bl);
            validationResultArray[i] = MutationUtil.createValidationResult((Object)assignLicensePreviewResult);
        }
        return validationResultArray;
    }

    private ValidationResult[] createLicensePreviewResults(License[] licenseArray) {
        ValidationResult[] validationResultArray = new ValidationResult[licenseArray.length];
        for (int i = 0; i < validationResultArray.length; ++i) {
            LicensePreviewResult licensePreviewResult = new LicensePreviewResult();
            licensePreviewResult.license = licenseArray[i];
            validationResultArray[i] = MutationUtil.createValidationResult((Object)licensePreviewResult);
        }
        return validationResultArray;
    }

    private static class SerialKeyFormatter
    implements Formatter<String> {
        private SerialKeyFormatter() {
        }

        @Override
        public String format(String string) {
            return ManagementUtil.getLocalizedString("previewLicenseError.licenseFormat", string);
        }
    }
}

