/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.adapter.BaseManagementDataProviderAdapterImpl;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.adapter.ProductPropertyProviderBean;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vise.data.query.type;
import java.net.URI;

@type(value="Product")
public class ProductDataProviderAdapterImpl
extends BaseManagementDataProviderAdapterImpl<ProductAggregation> {
    private static final String RELATION_PRODUCTS = "products";
    private final ManagementEditor _managementEditor;

    private static boolean canHandleRelation(Object[] objectArray, String string) {
        return RELATION_PRODUCTS.equals(string) && UriUtil.containsSingleUriWithType(objectArray, "License");
    }

    private static URI getLicenseUri(Object[] objectArray) {
        return (URI)objectArray[0];
    }

    public ProductDataProviderAdapterImpl(ManagementEditor managementEditor) {
        this._managementEditor = managementEditor;
    }

    @Override
    protected BasePropertyProviderBean<ProductAggregation> getPropertyProvider() {
        return new ProductPropertyProviderBean();
    }

    @Override
    protected String getProvidedType() {
        return "Product";
    }

    @Override
    protected URI getUri(ProductAggregation productAggregation) {
        return productAggregation.getProduct().getUri();
    }

    protected ProductAggregation[] getObjectsByScope(LicenseScope licenseScope) {
        return this._managementEditor.getProductAggregations(null, licenseScope);
    }

    protected ProductAggregation[] getObjectsByUrisAndScope(URI[] uRIArray, LicenseScope licenseScope) {
        return this._managementEditor.getProductAggregations(uRIArray, licenseScope);
    }

    protected ProductAggregation[] getRelatedObjects(Object[] objectArray, String string) {
        if (!ProductDataProviderAdapterImpl.canHandleRelation(objectArray, string)) {
            return (ProductAggregation[])super.getRelatedObjects(objectArray, string);
        }
        URI uRI = ProductDataProviderAdapterImpl.getLicenseUri(objectArray);
        return this._managementEditor.getProductAggregationsForLicense(uRI);
    }
}

