/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.vise.data.query.type;
import java.net.URI;

public class ProductPropertyProviderBean
extends BasePropertyProviderBean<ProductAggregation> {
    @type(value="Product")
    public ProductAggregation getProductAggregation(URI uRI) {
        ProductAggregation productAggregation = (ProductAggregation)((Object)this.getDataObject(uRI));
        return productAggregation;
    }

    @type(value="Product")
    public String getName(URI uRI) {
        Product product = this.getProduct(uRI);
        return product.getFormattedName();
    }

    @type(value="Product")
    public boolean getIsForVcs(URI uRI) {
        return this.isForAssetsOfType(uRI, AssetType.VC);
    }

    @type(value="Product")
    public boolean getIsForHosts(URI uRI) {
        return this.isForAssetsOfType(uRI, AssetType.HOST);
    }

    @type(value="Product")
    public boolean getIsForClusters(URI uRI) {
        return this.isForAssetsOfType(uRI, AssetType.CLUSTER);
    }

    @type(value="Product")
    public boolean getIsForSolutions(URI uRI) {
        return this.isForAssetsOfType(uRI, AssetType.SOLUTION);
    }

    private Product getProduct(URI uRI) {
        ProductAggregation productAggregation = (ProductAggregation)((Object)this.getDataObject(uRI));
        return productAggregation.getProduct();
    }

    private boolean isForAssetsOfType(URI uRI, AssetType assetType) {
        Product product = this.getProduct(uRI);
        return assetType.equals((Object)product.getAssetsType());
    }
}

