/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetUpdateLicenseSpec;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementObjectsFormatter;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.ds.results.AddSubscriptionLicensePreviewResult;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseCreateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseUpdateSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.net.URI;

public class FormattingVpxManagementEditorWrapperImpl
implements VpxManagementEditor {
    private final VpxManagementEditor _vpxManagementEditor;
    private final ManagementObjectsFormatter _formatter;

    public FormattingVpxManagementEditorWrapperImpl(VpxManagementEditor vpxManagementEditor, ManagementObjectsFormatter managementObjectsFormatter) {
        this._vpxManagementEditor = vpxManagementEditor;
        this._formatter = managementObjectsFormatter;
    }

    @Override
    public License[] getLicenses(URI[] uRIArray, LicenseScope licenseScope) {
        License[] licenseArray = this._vpxManagementEditor.getLicenses(uRIArray, licenseScope);
        this._formatter.formatLicenses(licenseArray);
        return licenseArray;
    }

    @Override
    public License[] getLicenses(LicenseScope licenseScope, LicenseSearchProperties licenseSearchProperties) {
        License[] licenseArray = this._vpxManagementEditor.getLicenses(licenseScope, licenseSearchProperties);
        this._formatter.formatLicenses(licenseArray);
        return licenseArray;
    }

    @Override
    public License[] getLicensesForProduct(URI uRI, LicenseSearchProperties licenseSearchProperties) {
        License[] licenseArray = this._vpxManagementEditor.getLicensesForProduct(uRI, licenseSearchProperties);
        this._formatter.formatLicenses(licenseArray);
        return licenseArray;
    }

    @Override
    public ProductAggregation[] getProductAggregations(URI[] uRIArray, LicenseScope licenseScope) {
        ProductAggregation[] productAggregationArray = this._vpxManagementEditor.getProductAggregations(uRIArray, licenseScope);
        this._formatter.formatProductAggregations(productAggregationArray);
        return productAggregationArray;
    }

    @Override
    public ProductAggregation[] getProductAggregationsForLicense(URI uRI) {
        ProductAggregation[] productAggregationArray = this._vpxManagementEditor.getProductAggregationsForLicense(uRI);
        this._formatter.formatProductAggregations(productAggregationArray);
        return productAggregationArray;
    }

    @Override
    public Asset[] getAssets(URI[] uRIArray, LicenseScope licenseScope) {
        Asset[] assetArray = this._vpxManagementEditor.getAssets(uRIArray, licenseScope);
        this._formatter.formatAssets(assetArray);
        return assetArray;
    }

    @Override
    public Asset[] getAssetsByMoRefs(ManagedObjectReference[] managedObjectReferenceArray, LicenseScope licenseScope) {
        Asset[] assetArray = this._vpxManagementEditor.getAssetsByMoRefs(managedObjectReferenceArray, licenseScope);
        this._formatter.formatAssets(assetArray);
        return assetArray;
    }

    @Override
    public Asset[] getAssets(LicenseScope licenseScope, AssetSearchProperties assetSearchProperties) {
        Asset[] assetArray = this._vpxManagementEditor.getAssets(licenseScope, assetSearchProperties);
        this._formatter.formatAssets(assetArray);
        return assetArray;
    }

    @Override
    public Asset[] getAssetsForProduct(URI uRI, AssetSearchProperties assetSearchProperties) {
        Asset[] assetArray = this._vpxManagementEditor.getAssetsForProduct(uRI, assetSearchProperties);
        this._formatter.formatAssets(assetArray);
        return assetArray;
    }

    @Override
    public Asset[] getAssetsForLicense(URI uRI, AssetSearchProperties assetSearchProperties) {
        Asset[] assetArray = this._vpxManagementEditor.getAssetsForLicense(uRI, assetSearchProperties);
        this._formatter.formatAssets(assetArray);
        return assetArray;
    }

    @Override
    public URI[] addLicenses(LicenseCreateSpec[] licenseCreateSpecArray) {
        return this._vpxManagementEditor.addLicenses(licenseCreateSpecArray);
    }

    @Override
    public URI addSubscriptionLicense(AddSubscriptionLicenseSpec addSubscriptionLicenseSpec) {
        return this._vpxManagementEditor.addSubscriptionLicense(addSubscriptionLicenseSpec);
    }

    @Override
    public void updateLicenses(LicenseUpdateSpec[] licenseUpdateSpecArray) {
        this._vpxManagementEditor.updateLicenses(licenseUpdateSpecArray);
    }

    @Override
    public void removeLicenses(URI[] uRIArray) {
        this._vpxManagementEditor.removeLicenses(uRIArray);
    }

    @Override
    public License[] previewLicenses(LicensePreviewSpec[] licensePreviewSpecArray) {
        License[] licenseArray = this._vpxManagementEditor.previewLicenses(licensePreviewSpecArray);
        this._formatter.formatLicenses(licenseArray);
        return licenseArray;
    }

    @Override
    public AddSubscriptionLicensePreviewResult previewSubscriptionLicense(AddSubscriptionLicensePreviewSpec addSubscriptionLicensePreviewSpec) {
        AddSubscriptionLicensePreviewResult addSubscriptionLicensePreviewResult = this._vpxManagementEditor.previewSubscriptionLicense(addSubscriptionLicensePreviewSpec);
        this._formatter.formatSubscriptionInfos(addSubscriptionLicensePreviewResult.subscriptions);
        return addSubscriptionLicensePreviewResult;
    }

    @Override
    public void updateAssetsLicense(AssetUpdateLicenseSpec[] assetUpdateLicenseSpecArray) {
        this._vpxManagementEditor.updateAssetsLicense(assetUpdateLicenseSpecArray);
    }

    @Override
    public void unregisterAssets(URI[] uRIArray) {
        this._vpxManagementEditor.unregisterAssets(uRIArray);
    }
}

