/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetUpdateLicenseSpec;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.ds.LicenseType;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.ds.results.AddSubscriptionLicensePreviewResult;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.BaseLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseCreateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseUpdateSpec;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.management.util.SubscriptionLicensingUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.LicenseUtilization;
import com.vmware.vim.binding.cis.license.ProductUtilization;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpec;
import com.vmware.vim.binding.cis.license.management.LicenseAddSpec;
import com.vmware.vim.binding.cis.license.management.LicenseSearchSpec;
import com.vmware.vim.binding.cis.license.management.ProductSearchSpec;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByIdsImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByLicenseIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByProductFamilyNamesImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByProductIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetUpdateLicenseSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.LicenseSearchSpecByIdsImpl;
import com.vmware.vim.binding.impl.cis.license.management.LicenseSearchSpecByProductIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.ProductSearchSpecByIdsImpl;
import com.vmware.vim.binding.impl.cis.license.management.ProductSearchSpecByLicenseIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.SerialKeyLicenseAddSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.SerialKeyLicenseUpdateSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.SubscriptionLicenseAddSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.SubscriptionLicensePreviewSpecImpl;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManagementEditorImpl
implements ManagementEditor {
    private final LicenseClientProvider _licenseClientProvider;

    private static LicenseUtilization[] filterLicenseUtilizationsBySearchProperties(LicenseUtilization[] licenseUtilizationArray, LicenseSearchProperties licenseSearchProperties) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseUtilizationArray) || licenseSearchProperties == null) {
            return licenseUtilizationArray;
        }
        LicenseType licenseType = licenseSearchProperties.getLicenseType();
        Boolean bl = licenseSearchProperties.isLicenseAssigned();
        if (licenseType == null && bl == null) {
            return licenseUtilizationArray;
        }
        ArrayList<LicenseUtilization> arrayList = new ArrayList<LicenseUtilization>();
        for (LicenseUtilization licenseUtilization : licenseUtilizationArray) {
            boolean bl2;
            LicenseType licenseType2;
            if (licenseType != null && !licenseType.equals((Object)(licenseType2 = ManagementEditorImpl.getLicenseType(licenseUtilization))) || bl != null && !bl.equals(bl2 = licenseUtilization.isIsLicenseAssigned())) continue;
            arrayList.add(licenseUtilization);
        }
        return arrayList.toArray(new LicenseUtilization[arrayList.size()]);
    }

    private static LicenseType getLicenseType(LicenseUtilization licenseUtilization) {
        LicenseType licenseType = null;
        licenseType = SubscriptionLicensingUtil.isSubscriptionLicenseUtilization(licenseUtilization) ? LicenseType.SUBSCRIPTION : LicenseType.SERIAL_KEY;
        return licenseType;
    }

    private static AssetSearchSpec createAssetSearchSpecByProductFamilyNames(AssetSearchProperties assetSearchProperties) {
        AssetSearchSpecByProductFamilyNamesImpl assetSearchSpecByProductFamilyNamesImpl = new AssetSearchSpecByProductFamilyNamesImpl();
        ManagementEditorImpl.updateAssetSearchSpecByProperties((AssetSearchSpec)assetSearchSpecByProductFamilyNamesImpl, assetSearchProperties);
        String string = ProductUtil.getProductFamilyName(assetSearchProperties.getType());
        if (string != null) {
            String[] stringArray = new String[]{string};
            assetSearchSpecByProductFamilyNamesImpl.setProductFamilyNames(stringArray);
        } else {
            String[] stringArray = new String[]{"VMware ESX Server", "VMware VirtualCenter Server", "VMware VSAN"};
            assetSearchSpecByProductFamilyNamesImpl.setProductFamilyNames(stringArray);
            assetSearchSpecByProductFamilyNamesImpl.setInverseSearch(Boolean.valueOf(true));
        }
        return assetSearchSpecByProductFamilyNamesImpl;
    }

    private static void updateAssetSearchSpecByProperties(AssetSearchSpec assetSearchSpec, AssetSearchProperties assetSearchProperties) {
        String string = assetSearchProperties.getScopeId();
        Integer n = assetSearchProperties.getMaxResultObjects();
        assetSearchSpec.setScopeId(string);
        assetSearchSpec.setMaxResults(n);
    }

    private static AssetSearchSpec createAssetSearchSpecByProductId(String string, AssetSearchProperties assetSearchProperties) {
        AssetSearchSpecByProductIdImpl assetSearchSpecByProductIdImpl = new AssetSearchSpecByProductIdImpl();
        ManagementEditorImpl.updateAssetSearchSpecByProperties((AssetSearchSpec)assetSearchSpecByProductIdImpl, assetSearchProperties);
        assetSearchSpecByProductIdImpl.setProductId(string);
        return assetSearchSpecByProductIdImpl;
    }

    private static AssetSearchSpec createAssetSearchSpecByLicenseId(URI uRI, String string, AssetSearchProperties assetSearchProperties) {
        AssetSearchSpecByLicenseIdImpl assetSearchSpecByLicenseIdImpl = new AssetSearchSpecByLicenseIdImpl();
        ManagementEditorImpl.updateAssetSearchSpecByProperties((AssetSearchSpec)assetSearchSpecByLicenseIdImpl, assetSearchProperties);
        assetSearchSpecByLicenseIdImpl.setLicenseId(uRI);
        assetSearchSpecByLicenseIdImpl.setProductFamilyName(string);
        return assetSearchSpecByLicenseIdImpl;
    }

    private static Asset[] filterAssetsByLicenseId(Asset[] assetArray, URI uRI) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetArray)) {
            return new Asset[0];
        }
        ArrayList<Asset> arrayList = new ArrayList<Asset>();
        for (Asset asset : assetArray) {
            URI uRI2;
            License license = asset.getInfo().getLicense();
            if (license == null || !(uRI2 = license.getId()).equals(uRI)) continue;
            arrayList.add(asset);
        }
        return arrayList.toArray(new Asset[arrayList.size()]);
    }

    private static com.vmware.license.client.cis.management.ds.License[] createLicenses(LicenseUtilization[] licenseUtilizationArray, LicenseScope licenseScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseUtilizationArray)) {
            return new com.vmware.license.client.cis.management.ds.License[0];
        }
        ArrayList<com.vmware.license.client.cis.management.ds.License> arrayList = new ArrayList<com.vmware.license.client.cis.management.ds.License>();
        for (int i = 0; i < licenseUtilizationArray.length; ++i) {
            com.vmware.license.client.cis.management.ds.License license = LicenseUtil.createLicense(licenseUtilizationArray[i], licenseScope);
            if (license == null) continue;
            arrayList.add(license);
        }
        return arrayList.toArray(new com.vmware.license.client.cis.management.ds.License[arrayList.size()]);
    }

    private static ProductAggregation[] createProductAggregations(ProductUtilization[] productUtilizationArray, LicenseUtilization[] licenseUtilizationArray, LicenseScope licenseScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])productUtilizationArray)) {
            return new ProductAggregation[0];
        }
        com.vmware.license.client.cis.management.ds.License[] licenseArray = ManagementEditorImpl.createLicenses(licenseUtilizationArray, licenseScope);
        Map<URI, List<com.vmware.license.client.cis.management.ds.License>> map = ManagementEditorImpl.getLicensesByProductUri(licenseArray);
        ArrayList<ProductAggregation> arrayList = new ArrayList<ProductAggregation>();
        for (int i = 0; i < productUtilizationArray.length; ++i) {
            ProductUtilization productUtilization = productUtilizationArray[i];
            com.vmware.vim.binding.cis.license.Product product = productUtilization.getProduct();
            Product product2 = ProductUtil.createProduct(product, productUtilization.getCostUnitsUsage(), productUtilization.getCostUnitsLimit(), licenseScope);
            if (product2 == null) continue;
            ProductAggregation productAggregation = new ProductAggregation();
            productAggregation.setProduct(product2);
            List<com.vmware.license.client.cis.management.ds.License> list = map.get(product2.getUri());
            productAggregation.setLicenses(list.toArray(new com.vmware.license.client.cis.management.ds.License[list.size()]));
            arrayList.add(productAggregation);
        }
        return arrayList.toArray(new ProductAggregation[arrayList.size()]);
    }

    private static Map<URI, List<com.vmware.license.client.cis.management.ds.License>> getLicensesByProductUri(com.vmware.license.client.cis.management.ds.License[] licenseArray) {
        HashMap<URI, List<com.vmware.license.client.cis.management.ds.License>> hashMap = new HashMap<URI, List<com.vmware.license.client.cis.management.ds.License>>();
        for (com.vmware.license.client.cis.management.ds.License license : licenseArray) {
            for (ProductRestriction productRestriction : license.getProductRestrictions()) {
                URI uRI = productRestriction.getProduct().getUri();
                ArrayList<com.vmware.license.client.cis.management.ds.License> arrayList = (ArrayList<com.vmware.license.client.cis.management.ds.License>)hashMap.get(uRI);
                if (arrayList == null) {
                    arrayList = new ArrayList<com.vmware.license.client.cis.management.ds.License>();
                    hashMap.put(uRI, arrayList);
                }
                arrayList.add(license);
            }
        }
        return hashMap;
    }

    private static LicenseAddSpec[] createLicenseAddSpecs(BaseLicenseSpec[] baseLicenseSpecArray) {
        LicenseAddSpec[] licenseAddSpecArray = new LicenseAddSpec[baseLicenseSpecArray.length];
        for (int i = 0; i < licenseAddSpecArray.length; ++i) {
            licenseAddSpecArray[i] = new SerialKeyLicenseAddSpecImpl(baseLicenseSpecArray[i].name, baseLicenseSpecArray[i].serialKeys);
        }
        return licenseAddSpecArray;
    }

    private static LicenseAddSpec buildSubscriptionLicenseAddSpec(AddSubscriptionLicenseSpec addSubscriptionLicenseSpec) {
        SubscriptionLicenseAddSpecImpl subscriptionLicenseAddSpecImpl = new SubscriptionLicenseAddSpecImpl();
        subscriptionLicenseAddSpecImpl.setUsername(addSubscriptionLicenseSpec.userName);
        subscriptionLicenseAddSpecImpl.setPassword(addSubscriptionLicenseSpec.password);
        subscriptionLicenseAddSpecImpl.setEntitlementAccountNumber(addSubscriptionLicenseSpec.entitlementAccount);
        subscriptionLicenseAddSpecImpl.setSubscriptionServiceId(addSubscriptionLicenseSpec.serviceId);
        subscriptionLicenseAddSpecImpl.setName(addSubscriptionLicenseSpec.licenseName);
        return subscriptionLicenseAddSpecImpl;
    }

    private static LicenseAddSpec buildSubscriptionLicensePreviewSpec(AddSubscriptionLicensePreviewSpec addSubscriptionLicensePreviewSpec) {
        SubscriptionLicensePreviewSpecImpl subscriptionLicensePreviewSpecImpl = new SubscriptionLicensePreviewSpecImpl();
        subscriptionLicensePreviewSpecImpl.setUsername(addSubscriptionLicensePreviewSpec.userName);
        subscriptionLicensePreviewSpecImpl.setPassword(addSubscriptionLicensePreviewSpec.password);
        subscriptionLicensePreviewSpecImpl.setName(addSubscriptionLicensePreviewSpec.licenseName);
        return subscriptionLicensePreviewSpecImpl;
    }

    private static com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[] createServiceLicenseUpdateSpecs(LicenseUpdateSpec[] licenseUpdateSpecArray) {
        com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[] licenseUpdateSpecArray2 = new com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[licenseUpdateSpecArray.length];
        for (int i = 0; i < licenseUpdateSpecArray2.length; ++i) {
            licenseUpdateSpecArray2[i] = new SerialKeyLicenseUpdateSpecImpl(UriUtil.extractObjectIdAsUri(licenseUpdateSpecArray[i].uri), licenseUpdateSpecArray[i].name, licenseUpdateSpecArray[i].serialKeys);
        }
        return licenseUpdateSpecArray2;
    }

    private static com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] createAssetUpdateLicenseSpecs(AssetUpdateLicenseSpec[] assetUpdateLicenseSpecArray) {
        com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] assetUpdateLicenseSpecArray2 = new com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[assetUpdateLicenseSpecArray.length];
        for (int i = 0; i < assetUpdateLicenseSpecArray.length; ++i) {
            UriUtil.validateAssetUri(assetUpdateLicenseSpecArray[i].getAssetRef());
            URI uRI = null;
            if (assetUpdateLicenseSpecArray[i].getLicenseRef() != null && !assetUpdateLicenseSpecArray[i].isPlaceInEvaluation()) {
                UriUtil.validateLicenseUri(assetUpdateLicenseSpecArray[i].getLicenseRef());
                uRI = UriUtil.extractObjectIdAsUri(assetUpdateLicenseSpecArray[i].getLicenseRef());
            }
            URI uRI2 = UriUtil.extractObjectIdAsUri(assetUpdateLicenseSpecArray[i].getAssetRef());
            assetUpdateLicenseSpecArray2[i] = new AssetUpdateLicenseSpecImpl(uRI2, uRI, null, assetUpdateLicenseSpecArray[i].isPlaceInEvaluation());
        }
        return assetUpdateLicenseSpecArray2;
    }

    public ManagementEditorImpl(LicenseClientProvider licenseClientProvider) {
        this._licenseClientProvider = licenseClientProvider;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] getLicenses(URI[] uRIArray, LicenseScope licenseScope) {
        UriUtil.validateLicenseUris(uRIArray);
        Object[] objectArray = UriUtil.extractObjectIdsAsUris(uRIArray);
        LicenseSearchSpecByIdsImpl licenseSearchSpecByIdsImpl = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            licenseSearchSpecByIdsImpl = new LicenseSearchSpecByIdsImpl((URI[])objectArray);
        }
        LicenseUtilization[] licenseUtilizationArray = this.searchLicenseUtilizations((LicenseSearchSpec)licenseSearchSpecByIdsImpl, licenseScope);
        return ManagementEditorImpl.createLicenses(licenseUtilizationArray, licenseScope);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] getLicenses(LicenseScope licenseScope, LicenseSearchProperties licenseSearchProperties) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseScope});
        LicenseUtilization[] licenseUtilizationArray = this.searchLicenseUtilizations(null, licenseScope);
        licenseUtilizationArray = ManagementEditorImpl.filterLicenseUtilizationsBySearchProperties(licenseUtilizationArray, licenseSearchProperties);
        com.vmware.license.client.cis.management.ds.License[] licenseArray = ManagementEditorImpl.createLicenses(licenseUtilizationArray, licenseScope);
        return licenseArray;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] getLicensesForProduct(URI uRI, LicenseSearchProperties licenseSearchProperties) {
        UriUtil.validateProductUri(uRI);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        String string = UriUtil.extractObjectIdAsString(uRI);
        LicenseSearchSpecByProductIdImpl licenseSearchSpecByProductIdImpl = new LicenseSearchSpecByProductIdImpl(string);
        LicenseUtilization[] licenseUtilizationArray = this.searchLicenseUtilizations((LicenseSearchSpec)licenseSearchSpecByProductIdImpl, licenseScope);
        licenseUtilizationArray = ManagementEditorImpl.filterLicenseUtilizationsBySearchProperties(licenseUtilizationArray, licenseSearchProperties);
        return ManagementEditorImpl.createLicenses(licenseUtilizationArray, licenseScope);
    }

    @Override
    public ProductAggregation[] getProductAggregations(URI[] uRIArray, LicenseScope licenseScope) {
        String[] stringArray;
        UriUtil.validateProductUris(uRIArray);
        ProductSearchSpecByIdsImpl productSearchSpecByIdsImpl = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
            stringArray = UriUtil.extractObjectIdsAsStrings(uRIArray);
            productSearchSpecByIdsImpl = new ProductSearchSpecByIdsImpl(stringArray);
        }
        stringArray = this.searchProductUtilizations((ProductSearchSpec)productSearchSpecByIdsImpl, licenseScope);
        LicenseUtilization[] licenseUtilizationArray = this.searchLicenseUtilizations(null, licenseScope);
        return ManagementEditorImpl.createProductAggregations((ProductUtilization[])stringArray, licenseUtilizationArray, licenseScope);
    }

    @Override
    public ProductAggregation[] getProductAggregationsForLicense(URI uRI) {
        UriUtil.validateLicenseUri(uRI);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        URI uRI2 = UriUtil.extractObjectIdAsUri(uRI);
        ProductSearchSpecByLicenseIdImpl productSearchSpecByLicenseIdImpl = new ProductSearchSpecByLicenseIdImpl(uRI2);
        ProductUtilization[] productUtilizationArray = this.searchProductUtilizations((ProductSearchSpec)productSearchSpecByLicenseIdImpl, licenseScope);
        LicenseUtilization[] licenseUtilizationArray = this.searchLicenseUtilizations(null, licenseScope);
        return ManagementEditorImpl.createProductAggregations(productUtilizationArray, licenseUtilizationArray, licenseScope);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssets(URI[] uRIArray, LicenseScope licenseScope) {
        UriUtil.validateAssetUris(uRIArray);
        Object[] objectArray = UriUtil.extractObjectIdsAsUris(uRIArray);
        AssetSearchSpecByIdsImpl assetSearchSpecByIdsImpl = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            assetSearchSpecByIdsImpl = new AssetSearchSpecByIdsImpl();
            assetSearchSpecByIdsImpl.setAssetIds((URI[])objectArray);
        }
        Asset[] assetArray = this.searchAssets((AssetSearchSpec)assetSearchSpecByIdsImpl, licenseScope);
        return this.createAssets(assetArray, licenseScope);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssets(LicenseScope licenseScope, AssetSearchProperties assetSearchProperties) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{assetSearchProperties});
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseScope});
        AssetSearchSpec assetSearchSpec = ManagementEditorImpl.createAssetSearchSpecByProductFamilyNames(assetSearchProperties);
        Asset[] assetArray = this.searchAssets(assetSearchSpec, licenseScope);
        com.vmware.license.client.cis.management.ds.Asset[] assetArray2 = this.createAssets(assetArray, licenseScope);
        return assetArray2;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssetsForProduct(URI uRI, AssetSearchProperties assetSearchProperties) {
        UriUtil.validateProductUri(uRI);
        ValidationUtil.paramsNotNull((Object[])new Object[]{assetSearchProperties});
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        String string = UriUtil.extractObjectIdAsString(uRI);
        AssetSearchSpec assetSearchSpec = ManagementEditorImpl.createAssetSearchSpecByProductId(string, assetSearchProperties);
        Asset[] assetArray = this.searchAssets(assetSearchSpec, licenseScope);
        com.vmware.license.client.cis.management.ds.Asset[] assetArray2 = this.createAssets(assetArray, licenseScope);
        return assetArray2;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssetsForLicense(URI uRI, AssetSearchProperties assetSearchProperties) {
        com.vmware.license.client.cis.management.ds.Asset[] assetArray;
        UriUtil.validateLicenseUri(uRI);
        ValidationUtil.paramsNotNull((Object[])new Object[]{assetSearchProperties});
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        URI uRI2 = UriUtil.extractObjectIdAsUri(uRI);
        Asset[] assetArray2 = null;
        String string = ProductUtil.getProductFamilyName(assetSearchProperties.getType());
        if (string != null) {
            assetArray = ManagementEditorImpl.createAssetSearchSpecByLicenseId(uRI2, string, assetSearchProperties);
            assetArray2 = this.searchAssets((AssetSearchSpec)assetArray, licenseScope);
        } else {
            assetArray = ManagementEditorImpl.createAssetSearchSpecByProductFamilyNames(assetSearchProperties);
            Asset[] assetArray3 = this.searchAssets((AssetSearchSpec)assetArray, licenseScope);
            assetArray2 = ManagementEditorImpl.filterAssetsByLicenseId(assetArray3, uRI2);
        }
        assetArray = this.createAssets(assetArray2, licenseScope);
        return assetArray;
    }

    @Override
    public URI[] addLicenses(LicenseCreateSpec[] licenseCreateSpecArray) {
        ValidationUtil.paramsNotNull((Object[])((Object[])licenseCreateSpecArray));
        LicenseUiScope licenseUiScope = licenseCreateSpecArray[0].scope;
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        LicenseAddSpec[] licenseAddSpecArray = ManagementEditorImpl.createLicenseAddSpecs(licenseCreateSpecArray);
        License[] licenseArray = null;
        try {
            licenseArray = systemManagementService.addLicenses(licenseAddSpecArray);
        }
        catch (MethodFault methodFault) {
            throw new ManagementException(methodFault);
        }
        return LicenseUtil.getLicenseUris(licenseArray, licenseScope);
    }

    @Override
    public URI addSubscriptionLicense(AddSubscriptionLicenseSpec addSubscriptionLicenseSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{addSubscriptionLicenseSpec});
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(addSubscriptionLicenseSpec.scope);
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        LicenseAddSpec licenseAddSpec = ManagementEditorImpl.buildSubscriptionLicenseAddSpec(addSubscriptionLicenseSpec);
        License[] licenseArray = null;
        try {
            licenseArray = systemManagementService.addLicenses(new LicenseAddSpec[]{licenseAddSpec});
        }
        catch (MethodFault methodFault) {
            throw new ManagementException(methodFault);
        }
        return LicenseUtil.getLicenseUris(licenseArray, licenseScope)[0];
    }

    @Override
    public void updateLicenses(LicenseUpdateSpec[] licenseUpdateSpecArray) {
        ValidationUtil.paramsNotNull((Object[])((Object[])licenseUpdateSpecArray));
        for (LicenseUpdateSpec methodFault : licenseUpdateSpecArray) {
            UriUtil.validateLicenseUri(methodFault.uri);
        }
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUpdateSpecArray[0].uri);
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[] licenseUpdateSpecArray2 = ManagementEditorImpl.createServiceLicenseUpdateSpecs(licenseUpdateSpecArray);
        try {
            systemManagementService.updateLicenses(licenseUpdateSpecArray2);
        }
        catch (MethodFault methodFault) {
            throw new ManagementException(methodFault);
        }
    }

    @Override
    public void removeLicenses(URI[] uRIArray) {
        ValidationUtil.paramsNotNull((Object[])uRIArray);
        UriUtil.validateLicenseUris(uRIArray);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRIArray[0]);
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        URI[] uRIArray2 = UriUtil.extractObjectIdsAsUris(uRIArray);
        try {
            systemManagementService.removeLicenses(uRIArray2);
        }
        catch (MethodFault methodFault) {
            throw new ManagementException(methodFault);
        }
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] previewLicenses(LicensePreviewSpec[] licensePreviewSpecArray) {
        ValidationUtil.paramsNotNull((Object[])((Object[])licensePreviewSpecArray));
        LicenseUiScope licenseUiScope = licensePreviewSpecArray[0].scope;
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        LicenseAddSpec[] licenseAddSpecArray = ManagementEditorImpl.createLicenseAddSpecs(licensePreviewSpecArray);
        LicenseInfo[] licenseInfoArray = systemManagementService.previewLicenses(licenseAddSpecArray);
        return LicenseUtil.createLicenses(licenseInfoArray, licenseScope);
    }

    @Override
    public AddSubscriptionLicensePreviewResult previewSubscriptionLicense(AddSubscriptionLicensePreviewSpec addSubscriptionLicensePreviewSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{addSubscriptionLicensePreviewSpec});
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(addSubscriptionLicensePreviewSpec.scope);
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        LicenseAddSpec licenseAddSpec = ManagementEditorImpl.buildSubscriptionLicensePreviewSpec(addSubscriptionLicensePreviewSpec);
        LicenseInfo[] licenseInfoArray = systemManagementService.previewLicenses(new LicenseAddSpec[]{licenseAddSpec});
        AddSubscriptionLicensePreviewResult addSubscriptionLicensePreviewResult = SubscriptionLicensingUtil.buildAddSubscriptionLicensePreviewResult(licenseInfoArray);
        return addSubscriptionLicensePreviewResult;
    }

    @Override
    public void updateAssetsLicense(AssetUpdateLicenseSpec[] assetUpdateLicenseSpecArray) {
        ValidationUtil.paramsNotNull((Object[])assetUpdateLicenseSpecArray);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(assetUpdateLicenseSpecArray[0].getAssetRef());
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] assetUpdateLicenseSpecArray2 = ManagementEditorImpl.createAssetUpdateLicenseSpecs(assetUpdateLicenseSpecArray);
        try {
            systemManagementService.updateAssetsLicense(assetUpdateLicenseSpecArray2);
        }
        catch (MethodFault methodFault) {
            throw new ManagementException(methodFault);
        }
    }

    @Override
    public void unregisterAssets(URI[] uRIArray) {
        ValidationUtil.paramsNotNull((Object[])uRIArray);
        UriUtil.validateAssetUris(uRIArray);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRIArray[0]);
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        URI[] uRIArray2 = UriUtil.extractObjectIdsAsUris(uRIArray);
        try {
            systemManagementService.unregisterAssets(uRIArray2);
        }
        catch (MethodFault methodFault) {
            throw new ManagementException(methodFault);
        }
    }

    protected Asset[] searchAssets(AssetSearchSpec assetSearchSpec, LicenseScope licenseScope) {
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        Asset[] assetArray = null;
        try {
            assetArray = systemManagementService.searchAssets(assetSearchSpec);
        }
        catch (MethodFault methodFault) {
            throw new ManagementException(methodFault);
        }
        return assetArray;
    }

    protected com.vmware.license.client.cis.management.ds.Asset[] createAssets(Asset[] assetArray, LicenseScope licenseScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetArray)) {
            return new com.vmware.license.client.cis.management.ds.Asset[0];
        }
        com.vmware.license.client.cis.management.ds.Asset[] assetArray2 = new com.vmware.license.client.cis.management.ds.Asset[assetArray.length];
        for (int i = 0; i < assetArray2.length; ++i) {
            assetArray2[i] = AssetUtil.createAsset(assetArray[i], licenseScope);
        }
        return assetArray2;
    }

    private LicenseUtilization[] searchLicenseUtilizations(LicenseSearchSpec licenseSearchSpec, LicenseScope licenseScope) {
        LicenseUtilization[] licenseUtilizationArray;
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        try {
            licenseUtilizationArray = systemManagementService.searchLicenseUtilizations(licenseSearchSpec);
        }
        catch (MethodFault methodFault) {
            throw new ManagementException(methodFault);
        }
        return licenseUtilizationArray;
    }

    private SystemManagementService getSystemManagementService(LicenseScope licenseScope) {
        LicenseClient licenseClient = this.getLicenseClient(licenseScope);
        return licenseClient.getSystemManagementService();
    }

    private LicenseClient getLicenseClient(LicenseScope licenseScope) {
        try {
            return this._licenseClientProvider.getLicenseClient(licenseScope);
        }
        catch (Exception exception) {
            throw new ManagementException(exception);
        }
    }

    private ProductUtilization[] searchProductUtilizations(ProductSearchSpec productSearchSpec, LicenseScope licenseScope) {
        ProductUtilization[] productUtilizationArray;
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        try {
            productUtilizationArray = systemManagementService.searchProductUtilizations(productSearchSpec);
        }
        catch (MethodFault methodFault) {
            throw new ManagementException(methodFault);
        }
        return productUtilizationArray;
    }
}

