/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.MyVMwareClientProvider;
import com.vmware.license.client.cis.ls.MyVMwareClientProviderException;
import com.vmware.license.client.cis.ls.MyVMwareClientProviderResult;
import com.vmware.license.client.cis.management.MyVMwareOnlineSyncEditor;
import com.vmware.license.client.cis.management.MyVMwareOnlineSyncException;
import com.vmware.license.client.cis.management.MyVMwareOnlineSyncObjectsFormatter;
import com.vmware.license.client.cis.management.MyVMwareSyncEditor;
import com.vmware.license.client.cis.management.ds.MyVMwareAuthenticationInfo;
import com.vmware.license.client.cis.management.ds.MyVMwareAuthenticationToken;
import com.vmware.license.client.cis.management.ds.MyVMwareEntitlementAccount;
import com.vmware.license.client.cis.management.ds.MyVMwareFolder;
import com.vmware.license.client.cis.management.ds.results.MyVMwareOnlineSyncCheckReportGenerationStatusResult;
import com.vmware.license.client.cis.management.ds.results.MyVMwareOnlineSyncCredentialsResult;
import com.vmware.license.client.cis.management.ds.results.MyVMwareOnlineSyncFoldersResult;
import com.vmware.license.client.cis.management.ds.results.MyVMwareOnlineSyncInitiateReportGenerationResult;
import com.vmware.license.client.cis.management.ds.results.MyVMwareOnlineSyncPreviewResult;
import com.vmware.license.client.cis.management.ds.results.MyVMwareSyncPreviewResult;
import com.vmware.license.client.cis.management.ds.specs.MyVMwareOnlineSyncCheckReportGenerationStatusSpec;
import com.vmware.license.client.cis.management.ds.specs.MyVMwareOnlineSyncCredentialsSpec;
import com.vmware.license.client.cis.management.ds.specs.MyVMwareOnlineSyncFoldersSpec;
import com.vmware.license.client.cis.management.ds.specs.MyVMwareOnlineSyncInitiateReportGenerationSpec;
import com.vmware.license.client.cis.management.ds.specs.MyVMwareOnlineSyncPreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.MyVMwareOnlineSyncSpec;
import com.vmware.license.client.cis.management.ds.specs.MyVMwareSyncPreviewSpec;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.myvmware.client.authn.AuthenticationToken;
import com.vmware.license.myvmware.client.entitlementreport.EntitlementAccount;
import com.vmware.license.myvmware.client.entitlementreport.EntitlementReport;
import com.vmware.license.myvmware.client.entitlementreport.EntitlementReportGenerationSpec;
import com.vmware.license.myvmware.client.entitlementreport.Folder;
import com.vmware.license.myvmware.client.entitlementreport.MyVMwareEntitlementReportClient;
import com.vmware.license.myvmware.client.entitlementreport.RootFolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyVMwareOnlineSyncEditorImpl
implements MyVMwareOnlineSyncEditor {
    private final Log _logger = LogFactory.getLog(MyVMwareOnlineSyncEditorImpl.class);
    private MyVMwareOnlineSyncObjectsFormatter _myVMwareOnlineSyncObjectsFormatter = null;
    private MyVMwareClientProvider _myVMwareClientProvider = null;
    private MyVMwareSyncEditor _myVMwareSyncEditor = null;

    public MyVMwareOnlineSyncEditorImpl(MyVMwareClientProvider myVMwareClientProvider, MyVMwareSyncEditor myVMwareSyncEditor) {
        this._myVMwareClientProvider = myVMwareClientProvider;
        this._myVMwareSyncEditor = myVMwareSyncEditor;
    }

    public void setMyVMwareOnlineSyncObjectsFormatter(MyVMwareOnlineSyncObjectsFormatter myVMwareOnlineSyncObjectsFormatter) {
        this._myVMwareOnlineSyncObjectsFormatter = myVMwareOnlineSyncObjectsFormatter;
    }

    @Override
    public MyVMwareOnlineSyncCredentialsResult getUserEntitlementAccounts(MyVMwareOnlineSyncCredentialsSpec myVMwareOnlineSyncCredentialsSpec) throws MyVMwareOnlineSyncException {
        this.validateOnlineSyncSpecSanity(myVMwareOnlineSyncCredentialsSpec);
        try {
            MyVMwareClientProviderResult myVMwareClientProviderResult = this.getMyVMwareClient(myVMwareOnlineSyncCredentialsSpec.authenticationInfo);
            MyVMwareEntitlementReportClient myVMwareEntitlementReportClient = myVMwareClientProviderResult.getClient();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(Before call): Get the entitlement accounts of the current user.");
            }
            EntitlementAccount[] entitlementAccountArray = myVMwareEntitlementReportClient.getEntitlementAccounts();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(After call): Get the entitlement accounts of the current user.");
            }
            MyVMwareEntitlementAccount[] myVMwareEntitlementAccountArray = this.buildUiEntitlementAccounts(entitlementAccountArray);
            MyVMwareAuthenticationInfo myVMwareAuthenticationInfo = this.buildUiAuthenticationInfo(myVMwareClientProviderResult);
            MyVMwareOnlineSyncCredentialsResult myVMwareOnlineSyncCredentialsResult = this.buildCredentialsResult(myVMwareEntitlementAccountArray, myVMwareAuthenticationInfo);
            return myVMwareOnlineSyncCredentialsResult;
        }
        catch (Exception exception) {
            throw new MyVMwareOnlineSyncException(exception);
        }
    }

    @Override
    public MyVMwareOnlineSyncFoldersResult getEntitlementAccountFolders(MyVMwareOnlineSyncFoldersSpec myVMwareOnlineSyncFoldersSpec) throws MyVMwareOnlineSyncException {
        this.validateOnlineSyncSpecSanity(myVMwareOnlineSyncFoldersSpec);
        if (myVMwareOnlineSyncFoldersSpec.eaNumber == null) {
            throw new IllegalArgumentException("An entitlement account id must be specified in the spec parameter.");
        }
        try {
            MyVMwareClientProviderResult myVMwareClientProviderResult = this.getMyVMwareClient(myVMwareOnlineSyncFoldersSpec.authenticationInfo);
            MyVMwareEntitlementReportClient myVMwareEntitlementReportClient = myVMwareClientProviderResult.getClient();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(Before call): Get the folders of a specific entitlement account.");
            }
            RootFolder rootFolder = myVMwareEntitlementReportClient.getEntitlementAccountFolders(myVMwareOnlineSyncFoldersSpec.eaNumber);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(After call): Get the folders of a specific entitlement account.");
            }
            MyVMwareFolder[] myVMwareFolderArray = this.buildUiEntitlementAccountFolders(myVMwareOnlineSyncFoldersSpec.eaNumber, rootFolder);
            MyVMwareAuthenticationInfo myVMwareAuthenticationInfo = this.buildUiAuthenticationInfo(myVMwareClientProviderResult);
            MyVMwareOnlineSyncFoldersResult myVMwareOnlineSyncFoldersResult = this.buildValidateMyVMwareFoldersResult(myVMwareFolderArray, myVMwareAuthenticationInfo);
            return myVMwareOnlineSyncFoldersResult;
        }
        catch (Exception exception) {
            throw new MyVMwareOnlineSyncException(exception);
        }
    }

    @Override
    public MyVMwareOnlineSyncInitiateReportGenerationResult initiateReportGeneration(MyVMwareOnlineSyncInitiateReportGenerationSpec myVMwareOnlineSyncInitiateReportGenerationSpec) throws MyVMwareOnlineSyncException {
        this.validateOnlineSyncSpecSanity(myVMwareOnlineSyncInitiateReportGenerationSpec);
        if (myVMwareOnlineSyncInitiateReportGenerationSpec.accountsToFolderIds == null) {
            throw new IllegalArgumentException("The entitlement accounts to folder ids array cannot be null in the input spec parameter.");
        }
        try {
            MyVMwareClientProviderResult myVMwareClientProviderResult = this.getMyVMwareClient(myVMwareOnlineSyncInitiateReportGenerationSpec.authenticationInfo);
            MyVMwareEntitlementReportClient myVMwareEntitlementReportClient = myVMwareClientProviderResult.getClient();
            EntitlementReportGenerationSpec entitlementReportGenerationSpec = this.buildEntitlementReportGenerationSpec(myVMwareOnlineSyncInitiateReportGenerationSpec);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(Before call): Initiate the My VMware report generation for the selected entitlement accounts/folders.");
            }
            String string = myVMwareEntitlementReportClient.initiateEntitlementReportGeneration(entitlementReportGenerationSpec);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(After call): Initiate the My VMware report generation for the selected entitlement accounts/folders.");
            }
            MyVMwareAuthenticationInfo myVMwareAuthenticationInfo = this.buildUiAuthenticationInfo(myVMwareClientProviderResult);
            MyVMwareOnlineSyncInitiateReportGenerationResult myVMwareOnlineSyncInitiateReportGenerationResult = this.buildValidateInitiateReportGenerationResult(string, myVMwareAuthenticationInfo);
            return myVMwareOnlineSyncInitiateReportGenerationResult;
        }
        catch (Exception exception) {
            throw new MyVMwareOnlineSyncException(exception);
        }
    }

    @Override
    public MyVMwareOnlineSyncCheckReportGenerationStatusResult checkReportGenerationStatus(MyVMwareOnlineSyncCheckReportGenerationStatusSpec myVMwareOnlineSyncCheckReportGenerationStatusSpec) throws MyVMwareOnlineSyncException {
        this.validateOnlineSyncSpecSanity(myVMwareOnlineSyncCheckReportGenerationStatusSpec);
        if (myVMwareOnlineSyncCheckReportGenerationStatusSpec.reportGenerationTaskId == null) {
            throw new IllegalArgumentException("The id of the report generation task must not be null in the input spec parameter.");
        }
        try {
            MyVMwareClientProviderResult myVMwareClientProviderResult = this.getMyVMwareClient(myVMwareOnlineSyncCheckReportGenerationStatusSpec.authenticationInfo);
            MyVMwareEntitlementReportClient myVMwareEntitlementReportClient = myVMwareClientProviderResult.getClient();
            boolean bl = myVMwareEntitlementReportClient.isEntitlementReportGenerationComplete(myVMwareOnlineSyncCheckReportGenerationStatusSpec.reportGenerationTaskId);
            MyVMwareAuthenticationInfo myVMwareAuthenticationInfo = this.buildUiAuthenticationInfo(myVMwareClientProviderResult);
            MyVMwareOnlineSyncCheckReportGenerationStatusResult myVMwareOnlineSyncCheckReportGenerationStatusResult = this.buildValidateCheckReportGenerationStatusResult(bl, myVMwareAuthenticationInfo);
            return myVMwareOnlineSyncCheckReportGenerationStatusResult;
        }
        catch (Exception exception) {
            throw new MyVMwareOnlineSyncException(exception);
        }
    }

    @Override
    public MyVMwareOnlineSyncPreviewResult previewOnlineSync(MyVMwareOnlineSyncPreviewSpec myVMwareOnlineSyncPreviewSpec) throws MyVMwareOnlineSyncException {
        this.validateOnlineSyncSpecSanity(myVMwareOnlineSyncPreviewSpec);
        if (myVMwareOnlineSyncPreviewSpec.reportGenerationTaskId == null) {
            throw new IllegalArgumentException("The id of the report to download must not be null in the input spec parameter.");
        }
        if (myVMwareOnlineSyncPreviewSpec.scope == null) {
            throw new IllegalArgumentException("The scope of the license for the report to download must not be null in the input spec parameter.");
        }
        try {
            MyVMwareClientProviderResult myVMwareClientProviderResult = this.getMyVMwareClient(myVMwareOnlineSyncPreviewSpec.authenticationInfo);
            MyVMwareEntitlementReportClient myVMwareEntitlementReportClient = myVMwareClientProviderResult.getClient();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(Before call): Get the generated My VMware report.");
            }
            EntitlementReport entitlementReport = myVMwareEntitlementReportClient.getEntitlementReport(myVMwareOnlineSyncPreviewSpec.reportGenerationTaskId);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(After call): Get the generated My VMware report.");
            }
            MyVMwareSyncPreviewSpec myVMwareSyncPreviewSpec = this.buildMyVMwareSyncPreviewSpec(myVMwareOnlineSyncPreviewSpec.scope, entitlementReport.getData());
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(myVMwareOnlineSyncPreviewSpec.scope);
            MyVMwareSyncPreviewResult myVMwareSyncPreviewResult = this._myVMwareSyncEditor.previewSyncFromMyVMware(myVMwareSyncPreviewSpec, licenseScope);
            MyVMwareAuthenticationInfo myVMwareAuthenticationInfo = this.buildUiAuthenticationInfo(myVMwareClientProviderResult);
            MyVMwareOnlineSyncPreviewResult myVMwareOnlineSyncPreviewResult = this.buildValidateDownloadGeneratedReportResult(myVMwareSyncPreviewResult, myVMwareAuthenticationInfo);
            return myVMwareOnlineSyncPreviewResult;
        }
        catch (Exception exception) {
            throw new MyVMwareOnlineSyncException(exception);
        }
    }

    private MyVMwareSyncPreviewSpec buildMyVMwareSyncPreviewSpec(LicenseUiScope licenseUiScope, byte[] byArray) {
        MyVMwareSyncPreviewSpec myVMwareSyncPreviewSpec = new MyVMwareSyncPreviewSpec();
        myVMwareSyncPreviewSpec.scope = licenseUiScope;
        myVMwareSyncPreviewSpec.myVMwareFileContent = byArray;
        return myVMwareSyncPreviewSpec;
    }

    private void validateOnlineSyncSpecSanity(MyVMwareOnlineSyncSpec myVMwareOnlineSyncSpec) {
        if (myVMwareOnlineSyncSpec == null) {
            throw new IllegalArgumentException("The Online Sync spec parameter should not be null");
        }
        if (myVMwareOnlineSyncSpec.authenticationInfo == null) {
            throw new IllegalArgumentException("The authenticationInfo must not be null in the Online Sync spec parameter.");
        }
    }

    private EntitlementReportGenerationSpec buildEntitlementReportGenerationSpec(MyVMwareOnlineSyncInitiateReportGenerationSpec myVMwareOnlineSyncInitiateReportGenerationSpec) {
        EntitlementReportGenerationSpec.EntitlementReportAccountFolderSpec[] entitlementReportAccountFolderSpecArray = new EntitlementReportGenerationSpec.EntitlementReportAccountFolderSpec[myVMwareOnlineSyncInitiateReportGenerationSpec.accountsToFolderIds.length];
        for (int i = 0; i < myVMwareOnlineSyncInitiateReportGenerationSpec.accountsToFolderIds.length; ++i) {
            String string = myVMwareOnlineSyncInitiateReportGenerationSpec.accountsToFolderIds[i].entitlementAccountId;
            String[] stringArray = myVMwareOnlineSyncInitiateReportGenerationSpec.accountsToFolderIds[i].folderIds;
            entitlementReportAccountFolderSpecArray[i] = new EntitlementReportGenerationSpec.EntitlementReportAccountFolderSpec(string, stringArray);
        }
        EntitlementReportGenerationSpec entitlementReportGenerationSpec = new EntitlementReportGenerationSpec(entitlementReportAccountFolderSpecArray, myVMwareOnlineSyncInitiateReportGenerationSpec.fromDate, myVMwareOnlineSyncInitiateReportGenerationSpec.toDate);
        return entitlementReportGenerationSpec;
    }

    private MyVMwareClientProviderResult getMyVMwareClient(MyVMwareAuthenticationInfo myVMwareAuthenticationInfo) throws MyVMwareClientProviderException {
        MyVMwareClientProviderResult myVMwareClientProviderResult;
        if (myVMwareAuthenticationInfo.getAuthenticationToken() == null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(Before call): Get a My VMware client by username and password.");
            }
            myVMwareClientProviderResult = this._myVMwareClientProvider.newClient(myVMwareAuthenticationInfo.getUsername(), myVMwareAuthenticationInfo.getPassword());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(After call): Get a My VMware client by username and password.");
            }
        } else {
            MyVMwareAuthenticationToken myVMwareAuthenticationToken = myVMwareAuthenticationInfo.getAuthenticationToken();
            AuthenticationToken authenticationToken = new AuthenticationToken(myVMwareAuthenticationToken.getTokenValue(), myVMwareAuthenticationToken.getExpirationTime());
            myVMwareClientProviderResult = this._myVMwareClientProvider.newClient(authenticationToken);
        }
        return myVMwareClientProviderResult;
    }

    private MyVMwareAuthenticationInfo buildUiAuthenticationInfo(MyVMwareClientProviderResult myVMwareClientProviderResult) {
        AuthenticationToken authenticationToken = myVMwareClientProviderResult.getAuthenticationToken();
        MyVMwareAuthenticationToken myVMwareAuthenticationToken = this.buildUiAuthenticationToken(authenticationToken);
        MyVMwareAuthenticationInfo myVMwareAuthenticationInfo = new MyVMwareAuthenticationInfo();
        myVMwareAuthenticationInfo.setAuthenticationToken(myVMwareAuthenticationToken);
        return myVMwareAuthenticationInfo;
    }

    private MyVMwareAuthenticationToken buildUiAuthenticationToken(AuthenticationToken authenticationToken) {
        MyVMwareAuthenticationToken myVMwareAuthenticationToken = new MyVMwareAuthenticationToken();
        myVMwareAuthenticationToken.setTokenValue(authenticationToken.getTokenValue());
        myVMwareAuthenticationToken.setExpirationTime(authenticationToken.getExpirationTime());
        return myVMwareAuthenticationToken;
    }

    private MyVMwareEntitlementAccount[] buildUiEntitlementAccounts(EntitlementAccount[] entitlementAccountArray) {
        if (entitlementAccountArray == null) {
            return new MyVMwareEntitlementAccount[0];
        }
        MyVMwareEntitlementAccount[] myVMwareEntitlementAccountArray = new MyVMwareEntitlementAccount[entitlementAccountArray.length];
        for (int i = 0; i < entitlementAccountArray.length; ++i) {
            EntitlementAccount entitlementAccount = entitlementAccountArray[i];
            MyVMwareEntitlementAccount myVMwareEntitlementAccount = new MyVMwareEntitlementAccount();
            myVMwareEntitlementAccount.setEaNumber(entitlementAccount.getEaNumber());
            if (this._myVMwareOnlineSyncObjectsFormatter != null) {
                this._myVMwareOnlineSyncObjectsFormatter.formatEntitlementAccount(myVMwareEntitlementAccount, entitlementAccount);
            }
            myVMwareEntitlementAccountArray[i] = myVMwareEntitlementAccount;
        }
        return myVMwareEntitlementAccountArray;
    }

    private MyVMwareFolder[] buildUiEntitlementAccountFolders(String string, RootFolder rootFolder) {
        MyVMwareFolder myVMwareFolder;
        if (rootFolder == null) {
            return new MyVMwareFolder[0];
        }
        int n = 0;
        if (rootFolder.getSubFolders() != null) {
            n = rootFolder.getSubFolders().length;
        }
        MyVMwareFolder[] myVMwareFolderArray = new MyVMwareFolder[n + 1];
        myVMwareFolderArray[0] = myVMwareFolder = this.buildUiFolder(string, (Folder)rootFolder);
        if (this._myVMwareOnlineSyncObjectsFormatter != null) {
            this._myVMwareOnlineSyncObjectsFormatter.formatFolder(myVMwareFolder, (Folder)rootFolder);
        }
        if (rootFolder.getSubFolders() == null) {
            return myVMwareFolderArray;
        }
        for (int i = 0; i < rootFolder.getSubFolders().length; ++i) {
            Folder folder = rootFolder.getSubFolders()[i];
            MyVMwareFolder myVMwareFolder2 = this.buildUiFolder(string, folder);
            if (this._myVMwareOnlineSyncObjectsFormatter != null) {
                this._myVMwareOnlineSyncObjectsFormatter.formatFolder(myVMwareFolder2, folder);
            }
            myVMwareFolderArray[i + 1] = myVMwareFolder2;
        }
        return myVMwareFolderArray;
    }

    private MyVMwareFolder buildUiFolder(String string, Folder folder) {
        MyVMwareFolder myVMwareFolder = new MyVMwareFolder();
        myVMwareFolder.setEaNumber(string);
        myVMwareFolder.setFolderId(folder.getFolderId());
        myVMwareFolder.setSubFolderCount(folder.getSubFolderCount());
        myVMwareFolder.setIsRootFolder(folder instanceof RootFolder);
        return myVMwareFolder;
    }

    private MyVMwareOnlineSyncCredentialsResult buildCredentialsResult(MyVMwareEntitlementAccount[] myVMwareEntitlementAccountArray, MyVMwareAuthenticationInfo myVMwareAuthenticationInfo) {
        MyVMwareOnlineSyncCredentialsResult myVMwareOnlineSyncCredentialsResult = new MyVMwareOnlineSyncCredentialsResult();
        myVMwareOnlineSyncCredentialsResult.entitlementAccounts = myVMwareEntitlementAccountArray;
        myVMwareOnlineSyncCredentialsResult.authenticationInfo = myVMwareAuthenticationInfo;
        return myVMwareOnlineSyncCredentialsResult;
    }

    private MyVMwareOnlineSyncFoldersResult buildValidateMyVMwareFoldersResult(MyVMwareFolder[] myVMwareFolderArray, MyVMwareAuthenticationInfo myVMwareAuthenticationInfo) {
        MyVMwareOnlineSyncFoldersResult myVMwareOnlineSyncFoldersResult = new MyVMwareOnlineSyncFoldersResult();
        myVMwareOnlineSyncFoldersResult.folders = myVMwareFolderArray;
        myVMwareOnlineSyncFoldersResult.authenticationInfo = myVMwareAuthenticationInfo;
        return myVMwareOnlineSyncFoldersResult;
    }

    private MyVMwareOnlineSyncInitiateReportGenerationResult buildValidateInitiateReportGenerationResult(String string, MyVMwareAuthenticationInfo myVMwareAuthenticationInfo) {
        MyVMwareOnlineSyncInitiateReportGenerationResult myVMwareOnlineSyncInitiateReportGenerationResult = new MyVMwareOnlineSyncInitiateReportGenerationResult();
        myVMwareOnlineSyncInitiateReportGenerationResult.reportGenerationTaskId = string;
        myVMwareOnlineSyncInitiateReportGenerationResult.authenticationInfo = myVMwareAuthenticationInfo;
        return myVMwareOnlineSyncInitiateReportGenerationResult;
    }

    private MyVMwareOnlineSyncCheckReportGenerationStatusResult buildValidateCheckReportGenerationStatusResult(boolean bl, MyVMwareAuthenticationInfo myVMwareAuthenticationInfo) {
        MyVMwareOnlineSyncCheckReportGenerationStatusResult myVMwareOnlineSyncCheckReportGenerationStatusResult = new MyVMwareOnlineSyncCheckReportGenerationStatusResult();
        myVMwareOnlineSyncCheckReportGenerationStatusResult.isReportGenerated = bl;
        myVMwareOnlineSyncCheckReportGenerationStatusResult.authenticationInfo = myVMwareAuthenticationInfo;
        return myVMwareOnlineSyncCheckReportGenerationStatusResult;
    }

    private MyVMwareOnlineSyncPreviewResult buildValidateDownloadGeneratedReportResult(MyVMwareSyncPreviewResult myVMwareSyncPreviewResult, MyVMwareAuthenticationInfo myVMwareAuthenticationInfo) {
        MyVMwareOnlineSyncPreviewResult myVMwareOnlineSyncPreviewResult = new MyVMwareOnlineSyncPreviewResult();
        myVMwareOnlineSyncPreviewResult.syncPreviewResult = myVMwareSyncPreviewResult;
        myVMwareOnlineSyncPreviewResult.authenticationInfo = myVMwareAuthenticationInfo;
        return myVMwareOnlineSyncPreviewResult;
    }
}

