/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.MyVMwareSyncEditor;
import com.vmware.license.client.cis.management.MyVMwareSyncException;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.MyVMwareLicenseInfo;
import com.vmware.license.client.cis.management.ds.MyVMwareSerialKeyInfo;
import com.vmware.license.client.cis.management.ds.results.MyVMwareSyncPreviewResult;
import com.vmware.license.client.cis.management.ds.specs.MyVMwareLicenseCreateSpec;
import com.vmware.license.client.cis.management.ds.specs.MyVMwareLicenseUpdateSpec;
import com.vmware.license.client.cis.management.ds.specs.MyVMwareSyncCommitSpec;
import com.vmware.license.client.cis.management.ds.specs.MyVMwareSyncPreviewSpec;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.MyVMwareSyncUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.myvmware.client.sync.MyVMwareUtil;
import com.vmware.vim.binding.cis.license.MyVMwareLicenseDetails;
import com.vmware.vim.binding.cis.license.management.InactiveLicensesReport;
import com.vmware.vim.binding.cis.license.management.LicenseAddSpec;
import com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec;
import com.vmware.vim.binding.cis.license.management.MyVMwareLicenseReport;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareSerialKeyLicenseAddSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareSerialKeyLicenseUpdateSpecImpl;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyVMwareSyncEditorImpl
implements MyVMwareSyncEditor {
    private final LicenseClientProvider _licenseClientProvider;
    private final Log _logger = LogFactory.getLog(MyVMwareSyncEditorImpl.class);

    private static LicenseUpdateSpec[] buildServiceLicenseUpdateSpecs(MyVMwareLicenseUpdateSpec[] myVMwareLicenseUpdateSpecArray) {
        LicenseUpdateSpec[] licenseUpdateSpecArray = new LicenseUpdateSpec[myVMwareLicenseUpdateSpecArray.length];
        for (int i = 0; i < licenseUpdateSpecArray.length; ++i) {
            MyVMwareLicenseUpdateSpec myVMwareLicenseUpdateSpec = myVMwareLicenseUpdateSpecArray[i];
            URI uRI = UriUtil.extractObjectIdAsUri(myVMwareLicenseUpdateSpec.uri);
            MyVMwareLicenseDetails[] myVMwareLicenseDetailsArray = MyVMwareSyncEditorImpl.buildServiceMyVMwareLicenseDetails(myVMwareLicenseUpdateSpec.myVMwareLicenseInfo);
            MyVMwareSerialKeyLicenseUpdateSpecImpl myVMwareSerialKeyLicenseUpdateSpecImpl = new MyVMwareSerialKeyLicenseUpdateSpecImpl();
            myVMwareSerialKeyLicenseUpdateSpecImpl.setLicenseId(uRI);
            myVMwareSerialKeyLicenseUpdateSpecImpl.setSerialKeys(myVMwareLicenseUpdateSpec.serialKeys);
            myVMwareSerialKeyLicenseUpdateSpecImpl.setLicenseDetails(myVMwareLicenseDetailsArray);
            licenseUpdateSpecArray[i] = myVMwareSerialKeyLicenseUpdateSpecImpl;
        }
        return licenseUpdateSpecArray;
    }

    private static LicenseAddSpec[] buildServiceLicenseAddSpecs(MyVMwareLicenseCreateSpec[] myVMwareLicenseCreateSpecArray) {
        LicenseAddSpec[] licenseAddSpecArray = new LicenseAddSpec[myVMwareLicenseCreateSpecArray.length];
        for (int i = 0; i < licenseAddSpecArray.length; ++i) {
            MyVMwareLicenseCreateSpec myVMwareLicenseCreateSpec = myVMwareLicenseCreateSpecArray[i];
            MyVMwareLicenseDetails[] myVMwareLicenseDetailsArray = MyVMwareSyncEditorImpl.buildServiceMyVMwareLicenseDetails(myVMwareLicenseCreateSpec.myVMwareLicenseInfo);
            MyVMwareSerialKeyLicenseAddSpecImpl myVMwareSerialKeyLicenseAddSpecImpl = new MyVMwareSerialKeyLicenseAddSpecImpl();
            myVMwareSerialKeyLicenseAddSpecImpl.setName(myVMwareLicenseCreateSpec.name);
            myVMwareSerialKeyLicenseAddSpecImpl.setSerialKeys(myVMwareLicenseCreateSpec.serialKeys);
            myVMwareSerialKeyLicenseAddSpecImpl.setLicenseDetails(myVMwareLicenseDetailsArray);
            licenseAddSpecArray[i] = myVMwareSerialKeyLicenseAddSpecImpl;
        }
        return licenseAddSpecArray;
    }

    private static MyVMwareLicenseDetails[] buildServiceMyVMwareLicenseDetails(MyVMwareLicenseInfo myVMwareLicenseInfo) {
        if (myVMwareLicenseInfo == null || myVMwareLicenseInfo.getSerialKeysInfo() == null) {
            return new MyVMwareLicenseDetails[0];
        }
        MyVMwareSerialKeyInfo[] myVMwareSerialKeyInfoArray = myVMwareLicenseInfo.getSerialKeysInfo();
        MyVMwareLicenseDetails[] myVMwareLicenseDetailsArray = new MyVMwareLicenseDetails[myVMwareSerialKeyInfoArray.length];
        for (int i = 0; i < myVMwareSerialKeyInfoArray.length; ++i) {
            myVMwareLicenseDetailsArray[i] = MyVMwareSyncUtil.buildServiceMyVMwareLicenseDetails(myVMwareSerialKeyInfoArray[i]);
        }
        return myVMwareLicenseDetailsArray;
    }

    private static void updateDefaultNewLicensesNames(License[] licenseArray, int n) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseArray)) {
            return;
        }
        String[] stringArray = LicenseUtil.getNewLicensesNames(licenseArray.length, n);
        for (int i = 0; i < licenseArray.length; ++i) {
            licenseArray[i].setName(stringArray[i]);
        }
    }

    public MyVMwareSyncEditorImpl(LicenseClientProvider licenseClientProvider) {
        this._licenseClientProvider = licenseClientProvider;
    }

    @Override
    public MyVMwareSyncPreviewResult previewSyncFromMyVMware(MyVMwareSyncPreviewSpec myVMwareSyncPreviewSpec, LicenseScope licenseScope) {
        MyVMwareLicenseReport myVMwareLicenseReport;
        ValidationUtil.paramsNotNull((Object[])new Object[]{myVMwareSyncPreviewSpec, licenseScope});
        ValidationUtil.paramsNotNull((Object[])new Object[]{myVMwareSyncPreviewSpec.myVMwareFileContent});
        try {
            myVMwareLicenseReport = MyVMwareUtil.buildMyVMwareLicenseReport((byte[])myVMwareSyncPreviewSpec.myVMwareFileContent);
        }
        catch (IOException iOException) {
            throw new MyVMwareSyncException(iOException);
        }
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        try {
            com.vmware.vim.binding.cis.license.management.MyVMwareSyncPreviewResult myVMwareSyncPreviewResult = systemManagementService.previewMyVMwareSync(myVMwareLicenseReport);
            MyVMwareSyncPreviewResult myVMwareSyncPreviewResult2 = this.buildUiSyncPreviewResult(myVMwareSyncPreviewResult, licenseScope);
            return myVMwareSyncPreviewResult2;
        }
        catch (MethodFault methodFault) {
            throw new MyVMwareSyncException(methodFault);
        }
    }

    @Override
    public void commitSyncFromMyVMware(MyVMwareSyncCommitSpec myVMwareSyncCommitSpec, LicenseScope licenseScope) {
        LicenseUpdateSpec[] licenseUpdateSpecArray;
        ValidationUtil.paramsNotNull((Object[])new Object[]{myVMwareSyncCommitSpec, licenseScope});
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        boolean bl = false;
        if (!ArrayUtil.isNullOrEmpty((Object[])myVMwareSyncCommitSpec.myVMwareLicenseUpdateSpecs)) {
            licenseUpdateSpecArray = MyVMwareSyncEditorImpl.buildServiceLicenseUpdateSpecs(myVMwareSyncCommitSpec.myVMwareLicenseUpdateSpecs);
            try {
                systemManagementService.updateLicenses(licenseUpdateSpecArray);
                bl = true;
            }
            catch (MethodFault methodFault) {
                throw new MyVMwareSyncException(methodFault);
            }
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])myVMwareSyncCommitSpec.myVMwareLicenseCreateSpecs)) {
            licenseUpdateSpecArray = MyVMwareSyncEditorImpl.buildServiceLicenseAddSpecs(myVMwareSyncCommitSpec.myVMwareLicenseCreateSpecs);
            try {
                systemManagementService.addLicenses((LicenseAddSpec[])licenseUpdateSpecArray);
            }
            catch (MethodFault methodFault) {
                if (bl) {
                    this._logger.warn((Object)"Incomplete sync performed. Some licenses My VMware metadata was updated, but other licenses were not added to the inventory.");
                }
                throw new MyVMwareSyncException(methodFault);
            }
        }
    }

    private SystemManagementService getSystemManagementService(LicenseScope licenseScope) {
        LicenseClient licenseClient = this.getLicenseClient(licenseScope);
        return licenseClient.getSystemManagementService();
    }

    private LicenseClient getLicenseClient(LicenseScope licenseScope) {
        try {
            return this._licenseClientProvider.getLicenseClient(licenseScope);
        }
        catch (Exception exception) {
            throw new MyVMwareSyncException(exception);
        }
    }

    private MyVMwareSyncPreviewResult buildUiSyncPreviewResult(com.vmware.vim.binding.cis.license.management.MyVMwareSyncPreviewResult myVMwareSyncPreviewResult, LicenseScope licenseScope) {
        MyVMwareSyncPreviewResult myVMwareSyncPreviewResult2 = new MyVMwareSyncPreviewResult();
        myVMwareSyncPreviewResult2.licensesForMyVMwareInfoUpdate = LicenseUtil.createLicenses(myVMwareSyncPreviewResult.getMatchedLicenses(), licenseScope);
        License[] licenseArray = LicenseUtil.createLicenses(myVMwareSyncPreviewResult.getNewLicenses(), licenseScope);
        MyVMwareSyncEditorImpl.updateDefaultNewLicensesNames(licenseArray, myVMwareSyncPreviewResult.getInventoryLicensesTotal());
        myVMwareSyncPreviewResult2.licensesForAdd = licenseArray;
        myVMwareSyncPreviewResult2.isMyVMwareFileInCorrectFormat = ArrayUtil.isNullOrEmpty((Object[])myVMwareSyncPreviewResult.getMyVMwareReportErrors());
        myVMwareSyncPreviewResult2.inactiveLicensesReport = this.buildUiInactiveLicensesReport(myVMwareSyncPreviewResult.getInactiveLicensesReport());
        myVMwareSyncPreviewResult2.upgradedLicensesReport = this.buildUiInactiveLicensesReport(myVMwareSyncPreviewResult.getUpgradedLicensesReport());
        return myVMwareSyncPreviewResult2;
    }

    private com.vmware.license.client.cis.management.ds.InactiveLicensesReport buildUiInactiveLicensesReport(InactiveLicensesReport inactiveLicensesReport) {
        if (inactiveLicensesReport == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = MyVMwareUtil.getInactiveLicensesReportContent((InactiveLicensesReport)inactiveLicensesReport);
        }
        catch (IOException iOException) {
            this._logger.warn((Object)"Unable to get inactive licenses report content: ", (Throwable)iOException);
        }
        if (byArray == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.InactiveLicensesReport inactiveLicensesReport2 = new com.vmware.license.client.cis.management.ds.InactiveLicensesReport();
        inactiveLicensesReport2.setContent(byArray);
        inactiveLicensesReport2.setLicensesCount(inactiveLicensesReport.getInactiveLicensesTotal());
        return inactiveLicensesReport2;
    }
}

