/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.TopologyInfoProvider;
import com.vmware.license.client.cis.ls.TopologyInfoRetrievalException;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.impl.ManagementEditorImpl;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.AssetIdentifier;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpec;
import com.vmware.vim.binding.impl.cis.license.AssetIdentifierImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByIdentifiersImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VpxManagementEditorImpl
extends ManagementEditorImpl
implements VpxManagementEditor {
    private static final String HOST_MO_TYPE = "HostSystem";
    private static final String CLUSTER_MO_TYPE = "ClusterComputeResource";
    private static final String VC_MO_VALUE = "group-d1";
    private static final String VC_MO_TYPE = "Folder";
    private final Log _logger = LogFactory.getLog(VpxManagementEditorImpl.class);
    private final TopologyInfoProvider _topologyInfoProvider;

    public VpxManagementEditorImpl(LicenseClientProvider licenseClientProvider, TopologyInfoProvider topologyInfoProvider) {
        super(licenseClientProvider);
        this._topologyInfoProvider = topologyInfoProvider;
    }

    private static String getMoRefInstanceId(ManagedObjectReference managedObjectReference) {
        String string = managedObjectReference.getType();
        if (HOST_MO_TYPE.equals(string) || CLUSTER_MO_TYPE.equals(string)) {
            return managedObjectReference.getValue();
        }
        if (VC_MO_TYPE.equals(string)) {
            return managedObjectReference.getServerGuid();
        }
        throw new ManagementException("MOR with type: " + managedObjectReference.getType() + " passed. " + "The MO types handled by licensing UI are: " + HOST_MO_TYPE + ", " + VC_MO_TYPE + ", " + CLUSTER_MO_TYPE);
    }

    private static List<String> getMoRefsVcIds(ManagedObjectReference[] managedObjectReferenceArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (managedObjectReferenceArray == null) {
            return arrayList;
        }
        for (ManagedObjectReference managedObjectReference : managedObjectReferenceArray) {
            String string = VpxManagementEditorImpl.getMoRefVcId(managedObjectReference);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static String getMoRefVcId(ManagedObjectReference managedObjectReference) {
        if (managedObjectReference == null) {
            throw new IllegalArgumentException("Null moRef passed");
        }
        return managedObjectReference.getServerGuid();
    }

    private static Map<Asset, ManagedObjectReference> getMoRefsByAssets(Asset[] assetArray, Map<String, String> map) {
        HashMap<Asset, ManagedObjectReference> hashMap = new HashMap<Asset, ManagedObjectReference>();
        for (Asset asset : assetArray) {
            String string = asset.getInfo().getScopeId();
            String string2 = map == null ? null : map.get(string);
            ManagedObjectReference managedObjectReference = string2 == null ? null : VpxManagementEditorImpl.buildMoRefForVpxAsset(asset, string2);
            hashMap.put(asset, managedObjectReference);
        }
        return hashMap;
    }

    private static ManagedObjectReference buildMoRefForVpxAsset(Asset asset, String string) {
        if (!VpxManagementEditorImpl.isVpxAsset(asset)) {
            return null;
        }
        AssetType assetType = AssetUtil.getServiceAssetType(asset);
        String string2 = asset.getInfo().getInstanceId();
        ManagedObjectReference managedObjectReference = null;
        if (AssetType.HOST.equals((Object)assetType)) {
            managedObjectReference = new ManagedObjectReference(HOST_MO_TYPE, string2, string);
        } else if (AssetType.CLUSTER.equals((Object)assetType)) {
            managedObjectReference = new ManagedObjectReference(CLUSTER_MO_TYPE, string2, string);
        } else if (AssetType.VC.equals((Object)assetType)) {
            managedObjectReference = new ManagedObjectReference(VC_MO_TYPE, VC_MO_VALUE, string);
        }
        return managedObjectReference;
    }

    private static List<String> getVpxAssetsScopeIds(Asset[] assetArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])assetArray)) {
            return arrayList;
        }
        for (Asset asset : assetArray) {
            String string = asset.getInfo().getScopeId();
            if (string == null || !VpxManagementEditorImpl.isVpxAsset(asset)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static boolean isVpxAsset(Asset asset) {
        AssetType assetType = AssetUtil.getServiceAssetType(asset);
        return AssetType.VC.equals((Object)assetType) || AssetType.HOST.equals((Object)assetType) || AssetType.CLUSTER.equals((Object)assetType);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssetsByMoRefs(ManagedObjectReference[] managedObjectReferenceArray, LicenseScope licenseScope) {
        AssetIdentifier[] assetIdentifierArray;
        ValidationUtil.paramsNotNull((Object[])new Object[]{managedObjectReferenceArray, licenseScope});
        ValidationUtil.paramsNotNull((Object[])managedObjectReferenceArray);
        AssetSearchSpecByIdentifiersImpl assetSearchSpecByIdentifiersImpl = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])managedObjectReferenceArray)) {
            assetIdentifierArray = this.getAssetIdentifiers(managedObjectReferenceArray);
            assetSearchSpecByIdentifiersImpl = new AssetSearchSpecByIdentifiersImpl();
            assetSearchSpecByIdentifiersImpl.setAssetIdentifiers(assetIdentifierArray);
        }
        assetIdentifierArray = this.searchAssets((AssetSearchSpec)assetSearchSpecByIdentifiersImpl, licenseScope);
        return this.createAssets((Asset[])assetIdentifierArray, licenseScope);
    }

    @Override
    protected com.vmware.license.client.cis.management.ds.Asset[] createAssets(Asset[] assetArray, LicenseScope licenseScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetArray)) {
            return new com.vmware.license.client.cis.management.ds.Asset[0];
        }
        Map<Asset, ManagedObjectReference> map = this.getAssetToMoRef(assetArray);
        com.vmware.license.client.cis.management.ds.Asset[] assetArray2 = new com.vmware.license.client.cis.management.ds.Asset[assetArray.length];
        for (int i = 0; i < assetArray2.length; ++i) {
            com.vmware.license.client.cis.management.ds.Asset asset = AssetUtil.createAsset(assetArray[i], licenseScope);
            ManagedObjectReference managedObjectReference = map.get(assetArray[i]);
            asset.setRelatedManagedObjectRef(managedObjectReference);
            assetArray2[i] = asset;
        }
        return assetArray2;
    }

    private AssetIdentifier[] getAssetIdentifiers(ManagedObjectReference[] managedObjectReferenceArray) {
        Map<String, String> map = this.getVcIdToAssetScopeId(managedObjectReferenceArray);
        AssetIdentifierImpl[] assetIdentifierImplArray = new AssetIdentifierImpl[managedObjectReferenceArray.length];
        for (int i = 0; i < managedObjectReferenceArray.length; ++i) {
            String string = VpxManagementEditorImpl.getMoRefInstanceId(managedObjectReferenceArray[i]);
            String string2 = VpxManagementEditorImpl.getMoRefVcId(managedObjectReferenceArray[i]);
            String string3 = map.get(string2);
            assetIdentifierImplArray[i] = new AssetIdentifierImpl(string, string3);
        }
        return assetIdentifierImplArray;
    }

    private Map<String, String> getVcIdToAssetScopeId(ManagedObjectReference[] managedObjectReferenceArray) {
        List<String> list = VpxManagementEditorImpl.getMoRefsVcIds(managedObjectReferenceArray);
        Map<String, String> map = null;
        try {
            map = this._topologyInfoProvider.getVcIdToNodeId(list);
        }
        catch (TopologyInfoRetrievalException topologyInfoRetrievalException) {
            throw new ManagementException(topologyInfoRetrievalException);
        }
        return map;
    }

    private Map<Asset, ManagedObjectReference> getAssetToMoRef(Asset[] assetArray) {
        Map<Asset, ManagedObjectReference> map = new HashMap<Asset, ManagedObjectReference>();
        if (ArrayUtil.isNullOrEmpty((Object[])assetArray)) {
            return map;
        }
        List<String> list = VpxManagementEditorImpl.getVpxAssetsScopeIds(assetArray);
        if (list.isEmpty()) {
            return map;
        }
        Map<String, String> map2 = null;
        try {
            map2 = this._topologyInfoProvider.getNodeIdToVcId(list);
        }
        catch (TopologyInfoRetrievalException topologyInfoRetrievalException) {
            this._logger.warn((Object)("Topology information cannot be retrieved" + topologyInfoRetrievalException));
        }
        map = VpxManagementEditorImpl.getMoRefsByAssets(assetArray, map2);
        return map;
    }
}

