/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ds.LimitEnforcementType;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductFamily;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.CostUnitUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vim.binding.vim.host.ConnectInfo;
import com.vmware.vim.binding.vim.host.Summary;

public class HostConnectionUtil {
    private static final String HOST_LICENSE_DEFAULT_NAME = "License 1";

    public static Asset previewHostAsset(ConnectInfo connectInfo, License[] licenseArray) {
        if (connectInfo == null) {
            return null;
        }
        Asset asset = new Asset();
        asset.setUri(UriUtil.buildExternalAssetUri());
        asset.setType(AssetType.HOST);
        String string = HostConnectionUtil.getHostAssetName(connectInfo);
        asset.setName(string);
        License license = HostConnectionUtil.previewHostEvaluationInfo(connectInfo);
        asset.setEvaluationLicense(license);
        ProductFamily productFamily = HostConnectionUtil.getProductFamily(connectInfo);
        asset.setProductFamily(productFamily);
        String string2 = HostConnectionUtil.getHostVersion(connectInfo);
        asset.setVersion(string2);
        CostUnit[] costUnitArray = HostConnectionUtil.calculateHostCostUnitUsages(connectInfo);
        License license2 = HostConnectionUtil.previewHostLicense(connectInfo, licenseArray, costUnitArray, asset);
        asset.setLicense(license2);
        AssetLicenseState assetLicenseState = AssetUtil.getAssetLicenseState(license2);
        asset.setLicenseState(assetLicenseState);
        if (AssetLicenseState.UNLICENSED.equals((Object)assetLicenseState) || costUnitArray == null) {
            costUnitArray = new CostUnit[]{};
        }
        asset.setCostUnitUsage(costUnitArray);
        return asset;
    }

    private static String getHostAssetName(ConnectInfo connectInfo) {
        return connectInfo.host.config.name;
    }

    private static License previewHostEvaluationInfo(ConnectInfo connectInfo) {
        ConnectInfo.LicenseInfo licenseInfo = connectInfo.license;
        if (licenseInfo == null) {
            return null;
        }
        return LicenseUtil.createEvaluationInfo(licenseInfo.evaluation);
    }

    private static String getHostVersion(ConnectInfo connectInfo) {
        LicenseManager.LicenseInfo licenseInfo = HostConnectionUtil.getLmLicenseInfo(connectInfo);
        if (licenseInfo == null) {
            return null;
        }
        return (String)ManagementUtil.getKeyAnyValuePropertyValue("FileVersion", licenseInfo.properties);
    }

    private static LicenseManager.LicenseInfo getLmLicenseInfo(ConnectInfo connectInfo) {
        ConnectInfo.LicenseInfo licenseInfo = connectInfo.license;
        if (licenseInfo == null) {
            return null;
        }
        return licenseInfo.license;
    }

    private static CostUnit[] calculateHostCostUnitUsages(ConnectInfo connectInfo) {
        Number number;
        String string;
        LicenseManager.LicenseInfo licenseInfo = HostConnectionUtil.getLmLicenseInfo(connectInfo);
        if (licenseInfo == null) {
            return new CostUnit[0];
        }
        if ("00000-00000-00000-00000-00000".equals(licenseInfo.licenseKey)) {
            string = "cpuPackage";
            number = HostConnectionUtil.getHostCpuPackages(connectInfo);
        } else {
            string = licenseInfo.costUnit;
            number = licenseInfo.used;
        }
        return new CostUnit[]{CostUnitFactory.INSTANCE.createCostUnit(string, number, null, null)};
    }

    private static ProductFamily getProductFamily(ConnectInfo connectInfo) {
        AboutInfo aboutInfo = connectInfo.host.config.product;
        if (aboutInfo == null) {
            return null;
        }
        ProductFamily productFamily = ProductUtil.createProductFamily(aboutInfo.licenseProductName, aboutInfo.licenseProductVersion);
        return productFamily;
    }

    private static License previewHostLicense(ConnectInfo connectInfo, License[] licenseArray, CostUnit[] costUnitArray, Asset asset) {
        ConnectInfo.LicenseInfo licenseInfo = connectInfo.license;
        if (licenseInfo == null) {
            return null;
        }
        LicenseManager.LicenseInfo licenseInfo2 = licenseInfo.license;
        if (licenseInfo2 == null) {
            return null;
        }
        License license = null;
        License license2 = LicenseUtil.getLicenseBySerialKey(licenseInfo2.licenseKey, licenseArray);
        if (license2 != null) {
            ProductRestriction productRestriction = AssetUtil.getAssetProductRestrictionFromLicense(asset, license2);
            if (productRestriction != null) {
                CostUnit[] costUnitArray2 = productRestriction.getProduct().getCostUnits();
                CostUnitUtil.addCostUnitUsages(costUnitArray, costUnitArray2);
            }
            license = license2;
        } else {
            license = HostConnectionUtil.previewHostConnectionLicense(connectInfo);
        }
        if (LicenseUtil.isExpiredLicense(license)) {
            license = null;
        }
        return license;
    }

    private static License previewHostConnectionLicense(ConnectInfo connectInfo) {
        ConnectInfo.LicenseInfo licenseInfo = connectInfo.license;
        if (licenseInfo == null) {
            return null;
        }
        License license = LicenseUtil.createLicense(licenseInfo.license);
        if (license == null) {
            return null;
        }
        if (license.getIsEvaluation()) {
            Number number = HostConnectionUtil.getHostCpuPackages(connectInfo);
            CostUnit[] costUnitArray = new CostUnit[]{CostUnitFactory.INSTANCE.createCostUnit("cpuPackage", number, CostUnitUtil.NO_LIMIT_VALUE, LimitEnforcementType.HARD_ENFORCED)};
            Product product = license.getProductRestrictions()[0].getProduct();
            product.setCostUnits(costUnitArray);
        } else {
            license.setName(HOST_LICENSE_DEFAULT_NAME);
        }
        return license;
    }

    private static Number getHostCpuPackages(ConnectInfo connectInfo) {
        Summary.HardwareSummary hardwareSummary = connectInfo.host.hardware;
        return hardwareSummary != null ? Short.valueOf(hardwareSummary.numCpuPkgs) : null;
    }
}

