/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.MyVMwareApiLocalizedException;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.myvmware.client.MyVMwareClientException;
import java.util.concurrent.TimeoutException;

public class MyVMwareApiExceptionUtil {
    public static Exception convertToLocalizedException(Throwable throwable) {
        MyVMwareClientException myVMwareClientException = MyVMwareApiExceptionUtil.getSpecificExceptionFromThrowableExceptionChain(throwable, MyVMwareClientException.class);
        if (myVMwareClientException != null) {
            return MyVMwareApiExceptionUtil.convertToMyVMwareLocalizedException(myVMwareClientException);
        }
        TimeoutException timeoutException = MyVMwareApiExceptionUtil.getSpecificExceptionFromThrowableExceptionChain(throwable, TimeoutException.class);
        if (timeoutException != null) {
            String string = ManagementUtil.getLocalizedString("myVMwareOnlineSync.apiError.timeout");
            return new MyVMwareApiLocalizedException(MyVMwareApiLocalizedException.ApiErrorId.TIMEOUT, string);
        }
        String string = ManagementUtil.getLocalizedString("myVMwareOnlineSync.apiError.other");
        return new MyVMwareApiLocalizedException(MyVMwareApiLocalizedException.ApiErrorId.OTHER, string);
    }

    private static MyVMwareApiLocalizedException convertToMyVMwareLocalizedException(MyVMwareClientException myVMwareClientException) {
        String string;
        MyVMwareApiLocalizedException.ApiErrorId apiErrorId = MyVMwareApiLocalizedException.ApiErrorId.OTHER;
        switch (myVMwareClientException.getReasonType()) {
            case ACCESS_FORBIDDEN: {
                string = ManagementUtil.getLocalizedString("myVMwareOnlineSync.apiError.accessForbidden");
                apiErrorId = MyVMwareApiLocalizedException.ApiErrorId.EXPIRED_AUTHENTICATION_TOKEN;
                break;
            }
            case ACCESS_UNAUTHORIZED: {
                string = ManagementUtil.getLocalizedString("myVMwareOnlineSync.apiError.accessUnauthorized");
                apiErrorId = MyVMwareApiLocalizedException.ApiErrorId.INVALID_CREDENTIALS;
                break;
            }
            case RESOURCE_NOT_FOUND: 
            case OTHER: {
                string = ManagementUtil.getLocalizedString("myVMwareOnlineSync.apiError.other");
                apiErrorId = MyVMwareApiLocalizedException.ApiErrorId.OTHER;
                break;
            }
            default: {
                string = myVMwareClientException.getLocalizedMessage();
            }
        }
        return new MyVMwareApiLocalizedException(apiErrorId, string);
    }

    private static <T> T getSpecificExceptionFromThrowableExceptionChain(Throwable throwable, Class<T> clazz) {
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (clazz.isInstance(throwable2)) {
                return clazz.cast(throwable2);
            }
            if (throwable2.getCause() != throwable2) continue;
            return null;
        }
        return null;
    }
}

