/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.license.client.cis.reports.ReportEditor;
import com.vmware.license.client.cis.reports.ReportException;
import com.vmware.license.client.cis.reports.ds.AssetReport;
import com.vmware.license.client.cis.reports.ds.LicenseReport;
import com.vmware.license.client.cis.reports.ds.LicensingDataDumpReport;
import com.vmware.license.client.cis.reports.ds.ProductReport;
import com.vmware.license.client.cis.reports.impl.ReportUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.util.DateUtil;
import com.vmware.vim.binding.cis.license.report.DumpResult;
import com.vmware.vim.binding.cis.license.report.ReportAssetResult;
import com.vmware.vim.binding.cis.license.report.ReportLicenseResult;
import com.vmware.vim.binding.cis.license.report.ReportProductResult;
import com.vmware.vim.binding.cis.license.report.ReportProductUtilization;
import com.vmware.vim.binding.cis.license.report.ReportService;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;

public class ReportEditorImpl
implements ReportEditor {
    private final LicenseClientProvider _licenseClientProvider;

    public ReportEditorImpl(LicenseClientProvider licenseClientProvider) {
        this._licenseClientProvider = licenseClientProvider;
    }

    @Override
    public ProductReport[] getProductReports(URI[] uRIArray, LicenseReportScope licenseReportScope) {
        UriUtil.validateProductReportUris(uRIArray);
        ReportProductResult reportProductResult = this.queryReportProductsUtilizations(licenseReportScope);
        ReportProductUtilization[] reportProductUtilizationArray = this.filterReportProductUtilizationsById(reportProductResult.getReportProductUtilizations(), uRIArray);
        reportProductResult.setReportProductUtilizations(reportProductUtilizationArray);
        return ReportUtil.createProductReports(reportProductResult.getReportProductUtilizations(), licenseReportScope);
    }

    @Override
    public LicenseReport[] getLicenseReportsForProduct(URI uRI) {
        LicenseReportScope licenseReportScope = LicenseScopeUtil.getLicenseReportScopeByUiObjectUri(uRI);
        String string = UriUtil.extractObjectIdAsString(uRI);
        ReportLicenseResult reportLicenseResult = this.queryReportLicensesUtilizationsByProduct(string, licenseReportScope);
        return ReportUtil.createLicenseReports(reportLicenseResult.getReportLicenseUtilizations(), licenseReportScope);
    }

    @Override
    public AssetReport[] getAssetReports(URI uRI, URI uRI2, String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{uRI, uRI2});
        URI uRI3 = UriUtil.extractObjectIdAsUri(uRI2);
        String string2 = UriUtil.extractObjectIdAsString(uRI);
        LicenseReportScope licenseReportScope = LicenseScopeUtil.getLicenseReportScopeByUiObjectUri(uRI);
        ReportAssetResult reportAssetResult = this.queryReportAssetsUtilizationsByLicense(string2, uRI3, string, licenseReportScope);
        return ReportUtil.createAssetReports(reportAssetResult.getReportAssetUtilizations(), licenseReportScope);
    }

    @Override
    public LicensingDataDumpReport[] getLicensingDataDumpReports(LicenseReportScope licenseReportScope) {
        Calendar calendar = DateUtil.createUTCCalendar(licenseReportScope.getStartDate());
        Calendar calendar2 = DateUtil.createUTCCalendar(licenseReportScope.getEndDate());
        ReportService reportService = this.getReportService(licenseReportScope);
        DumpResult dumpResult = null;
        try {
            dumpResult = reportService.getUsageDump(calendar, calendar2);
        }
        catch (MethodFault methodFault) {
            throw new ReportException(methodFault);
        }
        LicensingDataDumpReport licensingDataDumpReport = ReportUtil.createLicensingDataDumpReport(dumpResult.getDump(), licenseReportScope);
        return new LicensingDataDumpReport[]{licensingDataDumpReport};
    }

    private ReportProductUtilization[] filterReportProductUtilizationsById(ReportProductUtilization[] reportProductUtilizationArray, URI[] uRIArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])reportProductUtilizationArray)) {
            return null;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
            return reportProductUtilizationArray;
        }
        ArrayList<ReportProductUtilization> arrayList = new ArrayList<ReportProductUtilization>();
        for (URI uRI : uRIArray) {
            String string = UriUtil.extractObjectIdAsString(uRI);
            ReportProductUtilization reportProductUtilization = this.getReportProductUtilizationById(reportProductUtilizationArray, string);
            if (reportProductUtilization == null) continue;
            arrayList.add(reportProductUtilization);
        }
        return arrayList.toArray(new ReportProductUtilization[arrayList.size()]);
    }

    private ReportProductUtilization getReportProductUtilizationById(ReportProductUtilization[] reportProductUtilizationArray, String string) {
        for (ReportProductUtilization reportProductUtilization : reportProductUtilizationArray) {
            if (!string.equals(reportProductUtilization.getProduct().getId())) continue;
            return reportProductUtilization;
        }
        return null;
    }

    private ReportProductResult queryReportProductsUtilizations(LicenseReportScope licenseReportScope) {
        Calendar calendar = DateUtil.createUTCCalendar(licenseReportScope.getStartDate());
        Calendar calendar2 = DateUtil.createUTCCalendar(licenseReportScope.getEndDate());
        ReportService reportService = this.getReportService(licenseReportScope);
        try {
            return reportService.queryReportProductsUtilizations(calendar, calendar2);
        }
        catch (MethodFault methodFault) {
            throw new ReportException(methodFault);
        }
    }

    private ReportLicenseResult queryReportLicensesUtilizationsByProduct(String string, LicenseReportScope licenseReportScope) {
        Calendar calendar = DateUtil.createUTCCalendar(licenseReportScope.getStartDate());
        Calendar calendar2 = DateUtil.createUTCCalendar(licenseReportScope.getEndDate());
        ReportService reportService = this.getReportService(licenseReportScope);
        try {
            return reportService.queryReportLicensesUtilizationsByProduct(string, calendar, calendar2);
        }
        catch (MethodFault methodFault) {
            throw new ReportException(methodFault);
        }
    }

    private ReportAssetResult queryReportAssetsUtilizationsByLicense(String string, URI uRI, String string2, LicenseReportScope licenseReportScope) {
        Calendar calendar = DateUtil.createUTCCalendar(licenseReportScope.getStartDate());
        Calendar calendar2 = DateUtil.createUTCCalendar(licenseReportScope.getEndDate());
        ReportService reportService = this.getReportService(licenseReportScope);
        try {
            return reportService.queryReportAssetsUtilizationsByLicense(string, uRI, string2, calendar, calendar2);
        }
        catch (MethodFault methodFault) {
            throw new ReportException(methodFault);
        }
    }

    private ReportService getReportService(LicenseReportScope licenseReportScope) {
        LicenseScope licenseScope = licenseReportScope.getLicenseScope();
        return this.getLicenseClient(licenseScope).getReportService();
    }

    private LicenseClient getLicenseClient(LicenseScope licenseScope) {
        try {
            return this._licenseClientProvider.getLicenseClient(licenseScope);
        }
        catch (Exception exception) {
            throw new ReportException(exception);
        }
    }
}

