/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.util;

import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.util.Formatter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class ErrorMessageBuilder {
    private ArrayList<String> _errorGroupsMessages = new ArrayList();

    public <T> void buildErrorGroup(String string, Collection<T> collection, Formatter<T> formatter) {
        if (ManagementUtil.isNullOrEmpty(collection)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (T t : collection) {
            String string2 = formatter.format(t);
            stringBuilder.append(string2);
        }
        String string3 = ManagementUtil.getLocalizedString(string, stringBuilder.toString());
        this._errorGroupsMessages.add(string3);
    }

    public String getErrorMessage(String string) {
        String string2 = ManagementUtil.getLocalizedString("errorMessageBuilder.defaultErrorGroupSeparator");
        return this.getErrorMessage(string, string2);
    }

    public String getErrorMessage(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("messageLocalizationKey and errorGroupSeparator should not be null");
        }
        if (this._errorGroupsMessages.isEmpty()) {
            return null;
        }
        String string3 = StringUtils.join(this._errorGroupsMessages, (String)string2);
        return ManagementUtil.getLocalizedString(string, string3);
    }
}

