/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.util;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LicenseScopeUtil {
    public static LicenseScope getLicenseScopeByMoRef(ManagedObjectReference managedObjectReference) {
        if (managedObjectReference == null) {
            return null;
        }
        String string = managedObjectReference.getServerGuid();
        return new LicenseScope(string);
    }

    public static LicenseScope getLicenseScopeByUiScope(LicenseUiScope licenseUiScope) {
        if (licenseUiScope == null || licenseUiScope.getId() == null) {
            return null;
        }
        return new LicenseScope(licenseUiScope.getId());
    }

    public static LicenseScope getLicenseScopeByUiObjectUri(URI uRI) {
        if (uRI == null) {
            return null;
        }
        String string = UriUtil.getLicenseScopeId(uRI);
        return new LicenseScope(string);
    }

    public static Map<LicenseScope, List<URI>> groupUiObjectsUrisByScope(URI[] uRIArray) {
        HashMap<LicenseScope, List<URI>> hashMap = new HashMap<LicenseScope, List<URI>>();
        if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
            return hashMap;
        }
        for (URI uRI : uRIArray) {
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
            if (licenseScope == null) continue;
            List<URI> list = hashMap.get(licenseScope);
            if (list == null) {
                list = new ArrayList<URI>();
                hashMap.put(licenseScope, list);
            }
            list.add(uRI);
        }
        return hashMap;
    }

    public static LicenseReportScope getLicenseReportScopeByUiObjectUri(URI uRI) {
        if (uRI == null) {
            return null;
        }
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        if (licenseScope == null) {
            return null;
        }
        Date date = UriUtil.getStartDate(uRI);
        Date date2 = UriUtil.getEndDate(uRI);
        return new LicenseReportScope(licenseScope, date, date2);
    }

    public static Map<LicenseReportScope, List<URI>> groupUiObjectsUrisByReportScope(URI[] uRIArray) {
        HashMap<LicenseReportScope, List<URI>> hashMap = new HashMap<LicenseReportScope, List<URI>>();
        if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
            return hashMap;
        }
        for (URI uRI : uRIArray) {
            LicenseReportScope licenseReportScope = LicenseScopeUtil.getLicenseReportScopeByUiObjectUri(uRI);
            if (licenseReportScope == null) continue;
            List<URI> list = hashMap.get(uRIArray);
            if (list == null) {
                list = new ArrayList<URI>();
                hashMap.put(licenseReportScope, list);
            }
            list.add(uRI);
        }
        return hashMap;
    }
}

