/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.management.adapter;

import com.vmware.license.client.management.adapter.LicenseCollectUriException;
import com.vmware.license.client.management.adapter.LicenseProviderInitializationException;
import com.vmware.license.client.util.ManagementUtil;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.ServicePropertyProviderAdapter;
import com.vmware.vise.data.query.impl.Utils;
import java.net.URI;
import java.util.ArrayList;

public abstract class BaseLicensePropertyProvider
implements PropertyProviderBean {
    private static String SCOPE_PROPERTY = "scope";
    protected ServicePropertyProviderAdapter _servicePropertyProviderAdapter = new ServicePropertyProviderAdapter((PropertyProviderBean)this);
    protected String _scope = "";
    protected Boolean _forceRefresh;

    public ResultSet getResultSet(QuerySpec querySpec) {
        ResultSet resultSet = new ResultSet();
        URI[] uRIArray = new URI[]{};
        try {
            this._scope = this.getQueryScope(querySpec);
            if (this._scope == null) {
                return null;
            }
            this._forceRefresh = ManagementUtil.isFreshDataRequested(querySpec.resourceSpec.propertySpecs);
            this.refreshData();
            uRIArray = this.getRelatedUriObjects(querySpec);
            this.validateObjectsExistence(uRIArray);
            PropertyRequestSpec propertyRequestSpec = new PropertyRequestSpec();
            propertyRequestSpec.objects = uRIArray;
            propertyRequestSpec.properties = this.filterPropertySpecsByType(querySpec.resourceSpec.propertySpecs);
            ResultSet resultSet2 = this._servicePropertyProviderAdapter.getProperties(propertyRequestSpec);
            if (resultSet2 != null) {
                resultSet = resultSet2;
            }
        }
        catch (Exception exception) {
            resultSet.error = ManagementUtil.buildLicenseMethodFault(exception);
        }
        resultSet.queryName = querySpec.name;
        resultSet.totalMatchedObjectCount = uRIArray.length;
        return resultSet;
    }

    protected abstract void refreshData() throws LicenseProviderInitializationException;

    protected abstract URI[] getAllUriObjects();

    protected abstract URI[] getRelatedUriObjects(Object var1, String var2) throws LicenseCollectUriException;

    protected abstract String getProvidedType();

    protected abstract void validateObjectsExistence(URI[] var1);

    private URI[] getUris(Object[] objectArray) {
        if (objectArray == null) {
            return new URI[0];
        }
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (Object object : objectArray) {
            if (!ManagementUtil.isUriOfType(object, this.getProvidedType())) continue;
            arrayList.add((URI)object);
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    private String getQueryScope(QuerySpec querySpec) {
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (RelationalConstraint.class.isInstance(constraint)) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)relationalConstraint.constraintOnRelatedObject;
            return ManagementUtil.getEntityScope(objectIdentityConstraint.target);
        }
        if (ObjectIdentityConstraint.class.isInstance(constraint) || CompositeConstraint.class.isInstance(constraint)) {
            URI[] uRIArray = this.getUris(Utils.getEnumeratedObjects((QuerySpec)querySpec));
            return ManagementUtil.getEntityScope(uRIArray[0]);
        }
        if (PropertyConstraint.class.isInstance(constraint)) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            if (SCOPE_PROPERTY.equals(propertyConstraint.propertyName)) {
                return (String)propertyConstraint.comparableValue;
            }
        }
        return "";
    }

    private URI[] getRelatedUriObjects(QuerySpec querySpec) throws LicenseCollectUriException {
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (RelationalConstraint.class.isInstance(constraint)) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)relationalConstraint.constraintOnRelatedObject;
            return this.getRelatedUriObjects(objectIdentityConstraint.target, relationalConstraint.relation);
        }
        if (ObjectIdentityConstraint.class.isInstance(constraint) || CompositeConstraint.class.isInstance(constraint)) {
            return this.getUris(Utils.getEnumeratedObjects((QuerySpec)querySpec));
        }
        if (PropertyConstraint.class.isInstance(constraint)) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            if (SCOPE_PROPERTY.equals(propertyConstraint.propertyName)) {
                return this.getAllUriObjects();
            }
        } else if (Constraint.class.isInstance(querySpec.resourceSpec.constraint)) {
            return this.getAllUriObjects();
        }
        return new URI[0];
    }

    private PropertySpec[] filterPropertySpecsByType(PropertySpec[] propertySpecArray) {
        String string = this.getProvidedType();
        if (string == null) {
            return new PropertySpec[0];
        }
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        for (PropertySpec propertySpec : propertySpecArray) {
            if (propertySpec.type != null && !string.equals(propertySpec.type)) continue;
            arrayList.add(propertySpec);
        }
        return arrayList.toArray(new PropertySpec[arrayList.size()]);
    }
}

