/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.management.adapter;

import com.vmware.license.client.management.editor.AssignmentRetrievalException;
import com.vmware.license.client.util.LicensePropertyUtil;
import com.vmware.license.client.util.ManagementUtil;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HostLicensableHardwarePropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final String LICENSE_RESOURCE_INFO_PROPERTY = "licensableResource";
    private static final String CPU_COUNT_KEY = "numCpuPackages";
    private static final String CPU_CORES_COUNT_KEY = "numCpuCores";
    private static final String LICENSE_NUM_LICENSABLE_CPUS = "licenseNumLicensableCpus";
    private static final String LICENSE_NUM_LICENSABLE_CORES = "licenseNumLicensableCores";
    private static final String LICENSE_LICENSABLE_CORES_PER_CPU = "licenseLicensableCoresPerCpu";
    private static final String LICENSE_FORMATTED_LICENSABLE_CORES_PER_CPU = "licenseFormattedLicensableCoresPerCpu";
    private static final String[] PROPERTIES = new String[]{"licenseNumLicensableCpus", "licenseNumLicensableCores", "licenseLicensableCoresPerCpu", "licenseFormattedLicensableCoresPerCpu"};
    private DataService _dataService;

    public HostLicensableHardwarePropertyProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, DataService dataService) {
        dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._dataService = dataService;
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
        Object[] objectArray = propertyRequestSpec.objects;
        PropertySpec[] propertySpecArray = propertyRequestSpec.properties;
        ResultSet resultSet = new ResultSet();
        try {
            PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object[])objectArray, (String[])new String[]{LICENSE_RESOURCE_INFO_PROPERTY});
            resultSet.items = HostLicensableHardwarePropertyProviderAdapter.getResultItems(propertyValueArray, propertySpecArray);
        }
        catch (Exception exception) {
            resultSet.error = exception;
        }
        return resultSet;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = "HostSystem";
        typeInfo.properties = PROPERTIES;
        return new TypeInfo[]{typeInfo};
    }

    private static ResultItem[] getResultItems(PropertyValue[] propertyValueArray, PropertySpec[] propertySpecArray) throws AssignmentRetrievalException {
        if (propertyValueArray == null || propertySpecArray == null) {
            return new ResultItem[0];
        }
        Map<Object, Map<String, PropertyValue>> map = HostLicensableHardwarePropertyProviderAdapter.groupPropertyValuesByProvider(propertyValueArray);
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (Map.Entry<Object, Map<String, PropertyValue>> entry : map.entrySet()) {
            arrayList.add(HostLicensableHardwarePropertyProviderAdapter.buildResultItem(entry.getKey(), entry.getValue(), propertySpecArray));
        }
        return arrayList.toArray(new ResultItem[arrayList.size()]);
    }

    private static Map<Object, Map<String, PropertyValue>> groupPropertyValuesByProvider(PropertyValue[] propertyValueArray) {
        if (propertyValueArray == null) {
            return new HashMap<Object, Map<String, PropertyValue>>();
        }
        HashMap<Object, Map<String, PropertyValue>> hashMap = new HashMap<Object, Map<String, PropertyValue>>();
        for (PropertyValue propertyValue : propertyValueArray) {
            if (!hashMap.containsKey(propertyValue.resourceObject)) {
                hashMap.put(propertyValue.resourceObject, new HashMap());
            }
            Map<String, PropertyValue> map = hashMap.get(propertyValue.resourceObject);
            map.put(propertyValue.propertyName, propertyValue);
        }
        return hashMap;
    }

    private static ResultItem buildResultItem(Object object, Map<String, PropertyValue> map, PropertySpec[] resultItem) {
        LicenseManager.LicensableResourceInfo licensableResourceInfo = HostLicensableHardwarePropertyProviderAdapter.getLicensableResourceInfo(map);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        for (PropertySpec propertySpec : resultItem) {
            for (String string : propertySpec.propertyNames) {
                Object object2 = null;
                if (LICENSE_LICENSABLE_CORES_PER_CPU.equals(string)) {
                    object2 = HostLicensableHardwarePropertyProviderAdapter.getNumberOfLicensableCoresPerCpu(licensableResourceInfo);
                } else if (LICENSE_NUM_LICENSABLE_CPUS.equals(string)) {
                    object2 = HostLicensableHardwarePropertyProviderAdapter.getNumberOfLicensableCpus(licensableResourceInfo);
                } else if (LICENSE_NUM_LICENSABLE_CORES.equals(string)) {
                    object2 = HostLicensableHardwarePropertyProviderAdapter.getNumberOfLicensableCores(licensableResourceInfo);
                } else {
                    if (!LICENSE_FORMATTED_LICENSABLE_CORES_PER_CPU.equals(string)) continue;
                    Number number = HostLicensableHardwarePropertyProviderAdapter.getNumberOfLicensableCoresPerCpu(licensableResourceInfo);
                    object2 = HostLicensableHardwarePropertyProviderAdapter.formatCoresPerCpu(number);
                }
                arrayList.add(ManagementUtil.buildPropertyValue(string, object2, object));
            }
        }
        ResultItem resultItem2 = new ResultItem();
        resultItem2.resourceObject = object;
        resultItem2.properties = arrayList.toArray(new PropertyValue[arrayList.size()]);
        return resultItem2;
    }

    private static LicenseManager.LicensableResourceInfo getLicensableResourceInfo(Map<String, PropertyValue> map) {
        if (map == null) {
            return null;
        }
        PropertyValue propertyValue = map.get(LICENSE_RESOURCE_INFO_PROPERTY);
        if (propertyValue == null || !LicenseManager.LicensableResourceInfo.class.isInstance(propertyValue.value)) {
            return null;
        }
        return (LicenseManager.LicensableResourceInfo)propertyValue.value;
    }

    private static Number getNumberOfLicensableCoresPerCpu(LicenseManager.LicensableResourceInfo licensableResourceInfo) {
        Number number = HostLicensableHardwarePropertyProviderAdapter.getNumberOfLicensableCpus(licensableResourceInfo);
        Number number2 = HostLicensableHardwarePropertyProviderAdapter.getNumberOfLicensableCores(licensableResourceInfo);
        if (number2 == null || number == null || number.intValue() == 0) {
            return null;
        }
        Double d = number2.doubleValue() / number.doubleValue();
        return ManagementUtil.roundNumber(d, 100);
    }

    private static Number getNumberOfLicensableCpus(LicenseManager.LicensableResourceInfo licensableResourceInfo) {
        return licensableResourceInfo == null ? (Number)null : (Number)((Number)LicensePropertyUtil.getPropertyValue(licensableResourceInfo.resource, CPU_COUNT_KEY));
    }

    private static Number getNumberOfLicensableCores(LicenseManager.LicensableResourceInfo licensableResourceInfo) {
        return licensableResourceInfo == null ? (Number)null : (Number)((Number)LicensePropertyUtil.getPropertyValue(licensableResourceInfo.resource, CPU_CORES_COUNT_KEY));
    }

    private static String formatCoresPerCpu(Number number) {
        return number == null ? "" : ManagementUtil.getLocalizedString("host.format.coresPerCpuProperty", new String[]{number.toString()});
    }
}

