/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.management.adapter;

import com.vmware.license.client.management.adapter.BaseLicensePropertyProvider;
import com.vmware.license.client.management.adapter.LicenseCollectUriException;
import com.vmware.license.client.management.adapter.LicenseProviderInitializationException;
import com.vmware.license.client.management.ds.Assignment;
import com.vmware.license.client.management.ds.LicenseKey;
import com.vmware.license.client.management.editor.EntityType;
import com.vmware.license.client.management.editor.LicenseEditor;
import com.vmware.license.client.management.editor.LicenseRetrievalException;
import com.vmware.license.client.util.LicensePropertyUtil;
import com.vmware.license.client.util.ManagementUtil;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.NumberDataObject;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.StringUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseKeyPropertyProvider
extends BaseLicensePropertyProvider {
    private static final String LICENCE_KEY_PROPERTY = "licenseKey";
    private LicenseEditor _licenseEditor;
    private Map<String, LicenseKey> _licenseKeyByUriValue = null;
    private Log _logger = LogFactory.getLog(LicenseKeyPropertyProvider.class);

    public LicenseKeyPropertyProvider(LicenseEditor licenseEditor) {
        this._licenseEditor = licenseEditor;
    }

    @type(value="LicenseKey")
    public String getLicenseKey(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getLicenseKey();
    }

    @type(value="LicenseKey")
    public String getProductKey(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getProductKey();
    }

    @type(value="LicenseKey")
    public String getName(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getFormattedLicenseKey();
    }

    @type(value="LicenseKey")
    public String getProductName(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getName();
    }

    @type(value="LicenseKey")
    public String getFormattedProductName(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getFormattedProductName();
    }

    @type(value="LicenseKey")
    public String getCostUnit(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getCostUnit();
    }

    @type(value="LicenseKey")
    public int getTotal(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getTotal();
    }

    @type(value="LicenseKey")
    public Integer getUsed(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getUsed();
    }

    @type(value="LicenseKey")
    public KeyAnyValue[] getProperties(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getProperties();
    }

    @type(value="LicenseKey")
    public KeyValue[] getLabels(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getLabels();
    }

    @type(value="LicenseKey")
    public boolean getIsUnlimitedCapacity(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.isUnlimitedCapacity();
    }

    @type(value="LicenseKey")
    public boolean getIsForVirtualCenter(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return EntityType.VIRTUAL_CENTER.equals((Object)licenseKey.getEntityType()) || licenseKey.isEvaluation();
    }

    @type(value="LicenseKey")
    public boolean getIsForHost(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return EntityType.HOST.equals((Object)licenseKey.getEntityType()) || licenseKey.isEvaluation() || licenseKey.isSuiteLicense();
    }

    @type(value="LicenseKey")
    public boolean getIsForSolution(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return EntityType.SOLUTION.equals((Object)licenseKey.getEntityType()) || licenseKey.isEvaluation() || licenseKey.isSuiteLicense();
    }

    @type(value="LicenseKey")
    public boolean getIsForCluster(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return EntityType.CLUSTER.equals((Object)licenseKey.getEntityType()) || licenseKey.isEvaluation();
    }

    @type(value="LicenseKey")
    public boolean getIsEvaluation(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.isEvaluation();
    }

    @type(value="LicenseKey")
    public NumberDataObject getExpirationTime(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return ManagementUtil.createNumberDataObject(licenseKey.getExpirationTime());
    }

    @type(value="LicenseKey")
    public String getFormattedExpirationDate(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return LicensePropertyUtil.getFormattedExpirationDate(licenseKey.getExpirationTime());
    }

    @type(value="LicenseKey")
    public boolean getIsLicenseAssigned(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.isAssigned();
    }

    @type(value="LicenseKey")
    public boolean getIsRemovable(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.isRemovable();
    }

    @type(value="LicenseKey")
    public NumberDataObject getVsanPerHostSsdEntitlementInGb(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return ManagementUtil.createNumberDataObject(licenseKey.getVsanPerHostSsdEntitlementInGb());
    }

    @type(value="LicenseKey")
    public String getFormattedTotal(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getFormattedTotal();
    }

    @type(value="LicenseKey")
    public String getFormattedUsed(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getFormattedUsed();
    }

    @type(value="LicenseKey")
    public String getFormattedAssignmentState(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getFormattedAssignmentState();
    }

    @type(value="LicenseKey")
    public String getFormattedLabel(URI uRI) {
        LicenseKey licenseKey = this.retrieveLicenseKey(uRI);
        return licenseKey.getFormattedLabel();
    }

    @Override
    protected void refreshData() throws LicenseProviderInitializationException {
        if (this._licenseKeyByUriValue != null) {
            this._licenseKeyByUriValue.clear();
            this._licenseKeyByUriValue = null;
        }
        try {
            this._licenseKeyByUriValue = LicenseKeyPropertyProvider.buildLicenseKeyMap(this._licenseEditor.getLicenseKeys(this._scope, this._forceRefresh));
        }
        catch (LicenseRetrievalException licenseRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error initializing LicenseKeyPropertyProvider", (Throwable)licenseRetrievalException);
            }
            throw new LicenseProviderInitializationException(licenseRetrievalException);
        }
    }

    @Override
    protected URI[] getAllUriObjects() {
        if (this._licenseKeyByUriValue == null || this._licenseKeyByUriValue.isEmpty()) {
            return new URI[0];
        }
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (String string : this._licenseKeyByUriValue.keySet()) {
            arrayList.add(LicenseKeyPropertyProvider.buildLicenseKeyUri(string, this._scope));
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected URI[] getRelatedUriObjects(Object object, String string) throws LicenseCollectUriException {
        if (object == null || StringUtil.isNullOrEmpty((String)string) || this._licenseKeyByUriValue == null || this._licenseKeyByUriValue.isEmpty()) {
            return new URI[0];
        }
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (URI.class.isInstance(object)) {
            URI uRI = (URI)object;
            String string2 = DefaultUriSchemeUtil.getType((URI)uRI);
            String string3 = ManagementUtil.getLicenseUriValue(uRI);
            String string4 = ManagementUtil.getLicenseUriScope(uRI);
            if (!"LicenseProduct".equals(string2) || !LICENCE_KEY_PROPERTY.equals(string)) return arrayList.toArray(new URI[arrayList.size()]);
            for (LicenseKey licenseKey : this._licenseKeyByUriValue.values()) {
                if (!licenseKey.getProductKey().equals(string3)) continue;
                arrayList.add(LicenseKeyPropertyProvider.buildLicenseKeyUri(licenseKey.getLicenseKey(), string4));
            }
            return arrayList.toArray(new URI[arrayList.size()]);
        } else {
            ManagedObjectReference managedObjectReference;
            if (!ManagedObjectReference.class.isInstance(object) || !"HostSystem".equals((managedObjectReference = (ManagedObjectReference)object).getType()) && !"LicenseSolution".equals(managedObjectReference.getType()) && !"Folder".equals(managedObjectReference.getType()) || !LICENCE_KEY_PROPERTY.equals(string)) return arrayList.toArray(new URI[arrayList.size()]);
            try {
                Assignment[] assignmentArray = this._licenseEditor.getLicenseAssignments(managedObjectReference.getValue(), managedObjectReference.getServerGuid(), false);
                if (assignmentArray == null || assignmentArray.length <= 0 || assignmentArray[0] == null) return arrayList.toArray(new URI[arrayList.size()]);
                arrayList.add(LicenseKeyPropertyProvider.buildLicenseKeyUri(assignmentArray[0].getLicenseKey().getLicenseKey(), managedObjectReference.getServerGuid()));
                return arrayList.toArray(new URI[arrayList.size()]);
            }
            catch (LicenseRetrievalException licenseRetrievalException) {
                if (!this._logger.isErrorEnabled()) throw new LicenseCollectUriException(licenseRetrievalException);
                this._logger.error((Object)"Error collecting URIs for LicenseKeyPropertyProvider", (Throwable)licenseRetrievalException);
                throw new LicenseCollectUriException(licenseRetrievalException);
            }
        }
    }

    @Override
    protected String getProvidedType() {
        return "LicenseKey";
    }

    @Override
    protected void validateObjectsExistence(URI[] uRIArray) {
        Set<String> set;
        Set<String> set2 = set = this._licenseKeyByUriValue == null ? null : this._licenseKeyByUriValue.keySet();
        if (!ManagementUtil.doesSetContainLicenseUriValuesForUris(set, uRIArray)) {
            ManagementUtil.reportNotExistingObject();
        }
    }

    private LicenseKey retrieveLicenseKey(URI uRI) {
        LicenseKey licenseKey = this._licenseKeyByUriValue.get(ManagementUtil.getLicenseUriValue(uRI));
        assert (licenseKey != null) : "license key not found for uri: " + uRI;
        return licenseKey;
    }

    private static URI buildLicenseKeyUri(String string, String string2) {
        return ManagementUtil.buildLicenseUri("LicenseKey", string, string2);
    }

    private static HashMap<String, LicenseKey> buildLicenseKeyMap(LicenseKey[] licenseKeyArray) {
        HashMap<String, LicenseKey> hashMap = new HashMap<String, LicenseKey>();
        for (LicenseKey licenseKey : licenseKeyArray) {
            hashMap.put(licenseKey.getLicenseKey(), licenseKey);
        }
        return hashMap;
    }
}

